/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.app.WallpaperColors;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Pair;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import com.android.systemui.monet.ColorScheme;
import com.android.systemui.monet.DynamicColors;
import com.google.ux.material.libmonet.dynamiccolor.DynamicColor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamicRenderResources
extends RenderResources {
    private final RenderResources mBaseResources;
    private Map<String, Integer> mDynamicColorMap;

    public DynamicRenderResources(RenderResources baseResources) {
        this.mBaseResources = baseResources;
    }

    public void setLogger(ILayoutLog logger) {
        this.mBaseResources.setLogger(logger);
    }

    public StyleResourceValue getDefaultTheme() {
        return this.mBaseResources.getDefaultTheme();
    }

    public void applyStyle(StyleResourceValue theme, boolean useAsPrimary) {
        this.mBaseResources.applyStyle(theme, useAsPrimary);
    }

    public void clearStyles() {
        this.mBaseResources.clearStyles();
    }

    public List<StyleResourceValue> getAllThemes() {
        return this.mBaseResources.getAllThemes();
    }

    public ResourceValue findItemInTheme(ResourceReference attr2) {
        ResourceValue baseValue = this.mBaseResources.findItemInTheme(attr2);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue findItemInStyle(StyleResourceValue style2, ResourceReference attr2) {
        ResourceValue baseValue = this.mBaseResources.findItemInStyle(style2, attr2);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue findResValue(String reference, boolean forceFrameworkOnly) {
        ResourceValue baseValue = this.mBaseResources.findResValue(reference, forceFrameworkOnly);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue dereference(ResourceValue resourceValue) {
        ResourceValue baseValue = this.mBaseResources.dereference(resourceValue);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue getUnresolvedResource(ResourceReference reference) {
        ResourceValue baseValue = this.mBaseResources.getUnresolvedResource(reference);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue getResolvedResource(ResourceReference reference) {
        ResourceValue baseValue = this.mBaseResources.getResolvedResource(reference);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue resolveResValue(ResourceValue value) {
        ResourceValue baseValue = this.mBaseResources.resolveResValue(value);
        return this.resolveDynamicColors(baseValue);
    }

    public StyleResourceValue getParent(StyleResourceValue style2) {
        return this.mBaseResources.getParent(style2);
    }

    public StyleResourceValue getStyle(ResourceReference reference) {
        return this.mBaseResources.getStyle(reference);
    }

    private ResourceValue resolveDynamicColors(ResourceValue baseValue) {
        if (this.hasDynamicColors() && baseValue != null && this.isDynamicColor(baseValue)) {
            int dynamicColor = this.mDynamicColorMap.get(baseValue.getName());
            String colorHex = "#" + Integer.toHexString(dynamicColor).substring(2);
            return new ResourceValueImpl(baseValue.getNamespace(), baseValue.getResourceType(), baseValue.getName(), colorHex);
        }
        return baseValue;
    }

    public void setWallpaper(String wallpaperPath) {
        if (wallpaperPath == null) {
            this.mDynamicColorMap = null;
            return;
        }
        this.mDynamicColorMap = DynamicRenderResources.createDynamicColorMap(wallpaperPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map<String, Integer> createDynamicColorMap(String wallpaperPath) {
        try (InputStream stream = DynamicRenderResources.class.getResourceAsStream(wallpaperPath);){
            Bitmap wallpaper = BitmapFactory.decodeStream(stream);
            if (wallpaper == null) {
                Map<String, Integer> map = null;
                return map;
            }
            WallpaperColors wallpaperColors = WallpaperColors.fromBitmap(wallpaper);
            int seed = ColorScheme.getSeedColor(wallpaperColors);
            ColorScheme lightScheme = new ColorScheme(seed, false);
            ColorScheme darkScheme = new ColorScheme(seed, true);
            HashMap<String, Integer> dynamicColorMap = new HashMap<String, Integer>();
            DynamicRenderResources.extractDynamicColors(dynamicColorMap, lightScheme, darkScheme, DynamicColors.getAllAccentPalette(), false);
            DynamicRenderResources.extractDynamicColors(dynamicColorMap, lightScheme, darkScheme, DynamicColors.getAllNeutralPalette(), false);
            DynamicRenderResources.extractDynamicColors(dynamicColorMap, lightScheme, darkScheme, DynamicColors.getAllDynamicColorsMapped(), false);
            DynamicRenderResources.extractDynamicColors(dynamicColorMap, lightScheme, darkScheme, DynamicColors.getFixedColorsMapped(), true);
            DynamicRenderResources.extractDynamicColors(dynamicColorMap, lightScheme, darkScheme, DynamicColors.getCustomColorsMapped(), false);
            HashMap<String, Integer> hashMap = dynamicColorMap;
            return hashMap;
        }
        catch (IOException | IllegalArgumentException ignore) {
            return null;
        }
    }

    private static void extractDynamicColors(Map<String, Integer> colorMap, ColorScheme lightScheme, ColorScheme darkScheme, List<Pair<String, DynamicColor>> colors, Boolean isFixed) {
        colors.forEach(p -> {
            String prefix = "system_" + (String)p.first;
            if (isFixed.booleanValue()) {
                colorMap.put(prefix, ((DynamicColor)p.second).getArgb(lightScheme.getMaterialScheme()));
                return;
            }
            colorMap.put(prefix + "_light", ((DynamicColor)p.second).getArgb(lightScheme.getMaterialScheme()));
            colorMap.put(prefix + "_dark", ((DynamicColor)p.second).getArgb(darkScheme.getMaterialScheme()));
        });
    }

    private boolean isDynamicColor(ResourceValue resourceValue) {
        if (!resourceValue.isFramework() || resourceValue.getResourceType() != ResourceType.COLOR) {
            return false;
        }
        return this.mDynamicColorMap.containsKey(resourceValue.getName());
    }

    public boolean hasDynamicColors() {
        return this.mDynamicColorMap != null;
    }
}

