/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.ResourceHelper;

public class NavigationHandle
extends View {
    private static final int RADIUS_DP = 2;
    private static final int BOTTOM_DP = 10;
    private static final int WIDTH_DP = 108;
    private static final String LIGHT_COLOR = "#EBffffff";
    private static final String DARK_COLOR = "#99000000";
    private final Paint mPaint = new Paint();
    private final float mRadius;
    private final float mBottom;
    private boolean mRequiresInvalidate;
    private final int mWidth;
    private final RectF mTmpBoundsRectF = new RectF();

    public NavigationHandle(Context context) {
        super(context);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mRadius = (int)TypedValue.applyDimension(1, 2.0f, displayMetrics);
        this.mBottom = (int)TypedValue.applyDimension(1, 10.0f, displayMetrics);
        this.mPaint.setAntiAlias(true);
        boolean isLightTheme = ResourceHelper.getBooleanThemeFrameworkAttrValue(((BridgeContext)context).getRenderResources(), "isLightTheme", false);
        if (isLightTheme) {
            this.mPaint.setColor(ResourceHelper.getColor(DARK_COLOR));
        } else {
            this.mPaint.setColor(ResourceHelper.getColor(LIGHT_COLOR));
        }
        this.setFocusable(false);
        this.mWidth = (int)TypedValue.applyDimension(1, 108.0f, displayMetrics);
    }

    @Override
    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        if (alpha > 0.0f && this.mRequiresInvalidate) {
            this.mRequiresInvalidate = false;
            this.invalidate();
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.drawRoundRect(this.computeHomeHandleBounds(), this.mRadius, this.mRadius, this.mPaint);
    }

    private RectF computeHomeHandleBounds() {
        float height = this.mRadius * 2.0f;
        float left = (float)this.getWidth() / 2.0f - (float)this.mWidth / 2.0f;
        float top = (float)this.getHeight() - this.mBottom - height;
        float right = (float)this.getWidth() / 2.0f + (float)this.mWidth / 2.0f;
        float bottom = top + height;
        this.mTmpBoundsRectF.set(left, top, right, bottom);
        return this.mTmpBoundsRectF;
    }
}

