/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl.binding;

import android.database.DataSetObserver;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ExpandableListAdapter;
import android.widget.HeterogeneousExpandableList;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.layoutlib.bridge.impl.binding.AdapterHelper;
import com.android.layoutlib.bridge.impl.binding.AdapterItem;
import java.util.ArrayList;
import java.util.List;

public class FakeExpandableAdapter
implements ExpandableListAdapter,
HeterogeneousExpandableList {
    private final LayoutlibCallback mCallback;
    private final ResourceReference mAdapterRef;
    private boolean mSkipCallbackParser = false;
    private final List<AdapterItem> mItems = new ArrayList<AdapterItem>();
    private final List<ResourceReference> mGroupTypes = new ArrayList<ResourceReference>();
    private final List<ResourceReference> mChildrenTypes = new ArrayList<ResourceReference>();

    public FakeExpandableAdapter(ResourceReference adapterRef, AdapterBinding binding, LayoutlibCallback callback) {
        this.mAdapterRef = adapterRef;
        this.mCallback = callback;
        this.createItems((Iterable<DataBindingItem>)binding, binding.getItemCount(), binding.getRepeatCount(), this.mGroupTypes, 1);
    }

    private void createItems(Iterable<DataBindingItem> iterable, int itemCount, int repeatCount, List<ResourceReference> types, int depth) {
        int[] typeCount = new int[itemCount];
        for (int r = 0; r < repeatCount; ++r) {
            for (DataBindingItem dataBindingItem : iterable) {
                ResourceReference viewRef = dataBindingItem.getViewReference();
                int typeIndex = types.indexOf(viewRef);
                if (typeIndex == -1) {
                    typeIndex = types.size();
                    types.add(viewRef);
                }
                List children = dataBindingItem.getChildren();
                int count = dataBindingItem.getCount();
                if (!children.isEmpty()) {
                    count = 1;
                }
                int index = typeCount[typeIndex];
                int n = typeIndex;
                typeCount[n] = typeCount[n] + count;
                for (int k = 0; k < count; ++k) {
                    AdapterItem item = new AdapterItem(dataBindingItem, typeIndex, this.mItems.size(), index++);
                    this.mItems.add(item);
                    if (children.isEmpty()) continue;
                    this.createItems(dataBindingItem, depth + 1);
                }
            }
        }
    }

    private void createItems(DataBindingItem item, int depth) {
        if (depth == 2) {
            this.createItems((Iterable<DataBindingItem>)item, item.getChildren().size(), item.getCount(), this.mChildrenTypes, depth);
        }
    }

    private AdapterItem getChildItem(int groupPosition, int childPosition) {
        AdapterItem item = this.mItems.get(groupPosition);
        List<AdapterItem> children = item.getChildren();
        return children.get(childPosition);
    }

    @Override
    public int getGroupCount() {
        return this.mItems.size();
    }

    @Override
    public int getChildrenCount(int groupPosition) {
        AdapterItem item = this.mItems.get(groupPosition);
        return item.getChildren().size();
    }

    @Override
    public Object getGroup(int groupPosition) {
        return this.mItems.get(groupPosition);
    }

    @Override
    public Object getChild(int groupPosition, int childPosition) {
        return this.getChildItem(groupPosition, childPosition);
    }

    @Override
    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        AdapterItem item = this.mItems.get(groupPosition);
        Pair<View, Boolean> pair = AdapterHelper.getView(item, null, parent, this.mCallback, this.mAdapterRef, this.mSkipCallbackParser);
        this.mSkipCallbackParser = (Boolean)pair.second;
        return (View)pair.first;
    }

    @Override
    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        AdapterItem parentItem = this.mItems.get(groupPosition);
        AdapterItem item = this.getChildItem(groupPosition, childPosition);
        Pair<View, Boolean> pair = AdapterHelper.getView(item, parentItem, parent, this.mCallback, this.mAdapterRef, this.mSkipCallbackParser);
        this.mSkipCallbackParser = (Boolean)pair.second;
        return (View)pair.first;
    }

    @Override
    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    @Override
    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    @Override
    public long getCombinedGroupId(long groupId) {
        return groupId << 16 | 0xFFFFL;
    }

    @Override
    public long getCombinedChildId(long groupId, long childId) {
        return groupId << 16 | childId;
    }

    @Override
    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    @Override
    public void onGroupCollapsed(int groupPosition) {
    }

    @Override
    public void onGroupExpanded(int groupPosition) {
    }

    @Override
    public void registerDataSetObserver(DataSetObserver observer) {
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver observer) {
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public boolean areAllItemsEnabled() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.mItems.isEmpty();
    }

    @Override
    public int getChildType(int groupPosition, int childPosition) {
        return this.getChildItem(groupPosition, childPosition).getType();
    }

    @Override
    public int getChildTypeCount() {
        return this.mChildrenTypes.size();
    }

    @Override
    public int getGroupType(int groupPosition) {
        return this.mItems.get(groupPosition).getType();
    }

    @Override
    public int getGroupTypeCount() {
        return this.mGroupTypes.size();
    }
}

