/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.resources;

import com.android.layoutlib.bridge.bars.Config;
import com.android.resources.Density;
import com.android.resources.LayoutDirection;
import java.io.InputStream;

public class IconLoader {
    private final String mIconName;
    private final Density mDesiredDensity;
    private final int mPlatformVersion;
    private final LayoutDirection mDirection;
    private Density mCurrentDensity;
    private final StringBuilder mCurrentPath;

    public IconLoader(String iconName, Density density, int platformVersion, LayoutDirection direction) {
        this.mIconName = iconName;
        this.mDesiredDensity = density;
        this.mPlatformVersion = platformVersion;
        this.mDirection = direction;
        int iconPathLength = 24;
        this.mCurrentPath = new StringBuilder(24 + iconName.length());
    }

    public InputStream getIcon() {
        for (String resourceDir : Config.getResourceDirs(this.mPlatformVersion)) {
            this.mCurrentDensity = null;
            InputStream stream = this.getIcon(resourceDir);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    public Density getDensity() {
        return this.mCurrentDensity;
    }

    public String getPath() {
        return this.mCurrentPath.toString();
    }

    private InputStream getIcon(String resourceDir) {
        InputStream stream = this.getIcon(resourceDir, this.mDesiredDensity);
        if (stream != null) {
            this.mCurrentDensity = this.mDesiredDensity;
            return stream;
        }
        for (Density density : Density.values()) {
            if (density == this.mDesiredDensity || (stream = this.getIcon(resourceDir, density)) == null) continue;
            this.mCurrentDensity = density;
            return stream;
        }
        return null;
    }

    private InputStream getIcon(String resourceDir, Density density) {
        this.mCurrentPath.setLength(0);
        if (this.mDirection == LayoutDirection.RTL) {
            this.mCurrentPath.append(resourceDir).append(this.mDirection.getResourceValue()).append('-').append(density.getResourceValue()).append('/').append(this.mIconName);
            InputStream stream = this.getClass().getResourceAsStream(this.mCurrentPath.toString());
            if (stream != null) {
                return stream;
            }
            this.mCurrentPath.setLength(0);
        }
        this.mCurrentPath.append(resourceDir).append(density.getResourceValue()).append('/').append(this.mIconName);
        return this.getClass().getResourceAsStream(this.mCurrentPath.toString());
    }
}

