/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.jsoup.nodes;

import com.android.layoutlib.jsoup.helper.StringUtil;
import com.android.layoutlib.jsoup.helper.Validate;
import com.android.layoutlib.jsoup.nodes.Attributes;
import com.android.layoutlib.jsoup.nodes.DataNode;
import com.android.layoutlib.jsoup.nodes.Document;
import com.android.layoutlib.jsoup.nodes.Node;
import com.android.layoutlib.jsoup.nodes.TextNode;
import com.android.layoutlib.jsoup.parser.Parser;
import com.android.layoutlib.jsoup.parser.Tag;
import com.android.layoutlib.jsoup.select.Collector;
import com.android.layoutlib.jsoup.select.Elements;
import com.android.layoutlib.jsoup.select.Evaluator;
import com.android.layoutlib.jsoup.select.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends Node {
    private Tag tag;
    private Set<String> classNames;

    public Element(Tag tag, String baseUri, Attributes attributes) {
        super(baseUri, attributes);
        Validate.notNull(tag);
        this.tag = tag;
    }

    public Element(Tag tag, String baseUri) {
        this(tag, baseUri, new Attributes());
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    public Element tagName(String tagName) {
        Validate.notEmpty(tagName, "Tag name must not be empty.");
        this.tag = Tag.valueOf(tagName);
        return this;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        String id2 = this.attr("id");
        return id2 == null ? "" : id2;
    }

    @Override
    public Element attr(String attributeKey, String attributeValue) {
        super.attr(attributeKey, attributeValue);
        return this;
    }

    public Map<String, String> dataset() {
        return this.attributes.dataset();
    }

    @Override
    public final Element parent() {
        return (Element)this.parentNode;
    }

    public Elements parents() {
        Elements parents = new Elements();
        Element.accumulateParents(this, parents);
        return parents;
    }

    private static void accumulateParents(Element el, Elements parents) {
        Element parent = el.parent();
        if (parent != null && !parent.tagName().equals("#root")) {
            parents.add(parent);
            Element.accumulateParents(parent, parents);
        }
    }

    public Element child(int index) {
        return this.children().get(index);
    }

    public Elements children() {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node node : this.childNodes) {
            if (!(node instanceof Element)) continue;
            elements.add((Element)node);
        }
        return new Elements((List<Element>)elements);
    }

    public List<TextNode> textNodes() {
        ArrayList<TextNode> textNodes = new ArrayList<TextNode>();
        for (Node node : this.childNodes) {
            if (!(node instanceof TextNode)) continue;
            textNodes.add((TextNode)node);
        }
        return Collections.unmodifiableList(textNodes);
    }

    public List<DataNode> dataNodes() {
        ArrayList<DataNode> dataNodes = new ArrayList<DataNode>();
        for (Node node : this.childNodes) {
            if (!(node instanceof DataNode)) continue;
            dataNodes.add((DataNode)node);
        }
        return Collections.unmodifiableList(dataNodes);
    }

    public Elements select(String cssQuery) {
        return Selector.select(cssQuery, this);
    }

    public Element appendChild(Node child) {
        Validate.notNull(child);
        this.addChildren(child);
        return this;
    }

    public Element prependChild(Node child) {
        Validate.notNull(child);
        this.addChildren(0, child);
        return this;
    }

    public Element appendElement(String tagName) {
        Element child = new Element(Tag.valueOf(tagName), this.baseUri());
        this.appendChild(child);
        return child;
    }

    public Element prependElement(String tagName) {
        Element child = new Element(Tag.valueOf(tagName), this.baseUri());
        this.prependChild(child);
        return child;
    }

    public Element appendText(String text) {
        TextNode node = new TextNode(text, this.baseUri());
        this.appendChild(node);
        return this;
    }

    public Element prependText(String text) {
        TextNode node = new TextNode(text, this.baseUri());
        this.prependChild(node);
        return this;
    }

    public Element append(String html) {
        Validate.notNull(html);
        List<Node> nodes = Parser.parseFragment(html, this, this.baseUri());
        this.addChildren(nodes.toArray(new Node[nodes.size()]));
        return this;
    }

    public Element prepend(String html) {
        Validate.notNull(html);
        List<Node> nodes = Parser.parseFragment(html, this, this.baseUri());
        this.addChildren(0, nodes.toArray(new Node[nodes.size()]));
        return this;
    }

    @Override
    public Element before(String html) {
        return (Element)super.before(html);
    }

    @Override
    public Element before(Node node) {
        return (Element)super.before(node);
    }

    @Override
    public Element after(String html) {
        return (Element)super.after(html);
    }

    @Override
    public Element after(Node node) {
        return (Element)super.after(node);
    }

    public Element empty() {
        this.childNodes.clear();
        return this;
    }

    @Override
    public Element wrap(String html) {
        return (Element)super.wrap(html);
    }

    public Elements siblingElements() {
        if (this.parentNode == null) {
            return new Elements(0);
        }
        Elements elements = this.parent().children();
        Elements siblings = new Elements(elements.size() - 1);
        for (Element el : elements) {
            if (el == this) continue;
            siblings.add(el);
        }
        return siblings;
    }

    public Element nextElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        Elements siblings = this.parent().children();
        Integer index = Element.indexInList(this, siblings);
        Validate.notNull(index);
        if (siblings.size() > index + 1) {
            return (Element)siblings.get(index + 1);
        }
        return null;
    }

    public Element previousElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        Elements siblings = this.parent().children();
        Integer index = Element.indexInList(this, siblings);
        Validate.notNull(index);
        if (index > 0) {
            return (Element)siblings.get(index - 1);
        }
        return null;
    }

    public Element firstElementSibling() {
        Elements siblings = this.parent().children();
        return siblings.size() > 1 ? (Element)siblings.get(0) : null;
    }

    public Integer elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        return Element.indexInList(this, this.parent().children());
    }

    public Element lastElementSibling() {
        Elements siblings = this.parent().children();
        return siblings.size() > 1 ? (Element)siblings.get(siblings.size() - 1) : null;
    }

    private static <E extends Element> Integer indexInList(Element search, List<E> elements) {
        Validate.notNull(search);
        Validate.notNull(elements);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            if (!element.equals(search)) continue;
            return i;
        }
        return null;
    }

    public Elements getElementsByTag(String tagName) {
        Validate.notEmpty(tagName);
        tagName = tagName.toLowerCase().trim();
        return Collector.collect(new Evaluator.Tag(tagName), this);
    }

    public Element getElementById(String id2) {
        Validate.notEmpty(id2);
        Elements elements = Collector.collect(new Evaluator.Id(id2), this);
        if (elements.size() > 0) {
            return elements.get(0);
        }
        return null;
    }

    public Elements getElementsByClass(String className) {
        Validate.notEmpty(className);
        return Collector.collect(new Evaluator.Class(className), this);
    }

    public Elements getElementsByAttribute(String key) {
        Validate.notEmpty(key);
        key = key.trim().toLowerCase();
        return Collector.collect(new Evaluator.Attribute(key), this);
    }

    public Elements getElementsByAttributeStarting(String keyPrefix) {
        Validate.notEmpty(keyPrefix);
        keyPrefix = keyPrefix.trim().toLowerCase();
        return Collector.collect(new Evaluator.AttributeStarting(keyPrefix), this);
    }

    public Elements getElementsByAttributeValue(String key, String value) {
        return Collector.collect(new Evaluator.AttributeWithValue(key, value), this);
    }

    public Elements getElementsByAttributeValueNot(String key, String value) {
        return Collector.collect(new Evaluator.AttributeWithValueNot(key, value), this);
    }

    public Elements getElementsByAttributeValueStarting(String key, String valuePrefix) {
        return Collector.collect(new Evaluator.AttributeWithValueStarting(key, valuePrefix), this);
    }

    public Elements getElementsByAttributeValueEnding(String key, String valueSuffix) {
        return Collector.collect(new Evaluator.AttributeWithValueEnding(key, valueSuffix), this);
    }

    public Elements getElementsByAttributeValueContaining(String key, String match) {
        return Collector.collect(new Evaluator.AttributeWithValueContaining(key, match), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, Pattern pattern) {
        return Collector.collect(new Evaluator.AttributeWithValueMatching(key, pattern), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsByAttributeValueMatching(key, pattern);
    }

    public Elements getElementsByIndexLessThan(int index) {
        return Collector.collect(new Evaluator.IndexLessThan(index), this);
    }

    public Elements getElementsByIndexGreaterThan(int index) {
        return Collector.collect(new Evaluator.IndexGreaterThan(index), this);
    }

    public Elements getElementsByIndexEquals(int index) {
        return Collector.collect(new Evaluator.IndexEquals(index), this);
    }

    public Elements getElementsContainingText(String searchText) {
        return Collector.collect(new Evaluator.ContainsText(searchText), this);
    }

    public Elements getElementsContainingOwnText(String searchText) {
        return Collector.collect(new Evaluator.ContainsOwnText(searchText), this);
    }

    public Elements getElementsMatchingText(Pattern pattern) {
        return Collector.collect(new Evaluator.Matches(pattern), this);
    }

    public Elements getElementsMatchingText(String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsMatchingText(pattern);
    }

    public Elements getElementsMatchingOwnText(Pattern pattern) {
        return Collector.collect(new Evaluator.MatchesOwn(pattern), this);
    }

    public Elements getElementsMatchingOwnText(String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsMatchingOwnText(pattern);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    public String text() {
        StringBuilder sb = new StringBuilder();
        this.text(sb);
        return sb.toString().trim();
    }

    private void text(StringBuilder accum) {
        Element.appendWhitespaceIfBr(this, accum);
        for (Node child : this.childNodes) {
            if (child instanceof TextNode) {
                TextNode textNode = (TextNode)child;
                this.appendNormalisedText(accum, textNode);
                continue;
            }
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            if (accum.length() > 0 && element.isBlock() && !TextNode.lastCharIsWhitespace(accum)) {
                accum.append(" ");
            }
            element.text(accum);
        }
    }

    public String ownText() {
        StringBuilder sb = new StringBuilder();
        this.ownText(sb);
        return sb.toString().trim();
    }

    private void ownText(StringBuilder accum) {
        for (Node child : this.childNodes) {
            if (child instanceof TextNode) {
                TextNode textNode = (TextNode)child;
                this.appendNormalisedText(accum, textNode);
                continue;
            }
            if (!(child instanceof Element)) continue;
            Element.appendWhitespaceIfBr((Element)child, accum);
        }
    }

    private void appendNormalisedText(StringBuilder accum, TextNode textNode) {
        String text = textNode.getWholeText();
        if (!this.preserveWhitespace()) {
            text = TextNode.normaliseWhitespace(text);
            if (TextNode.lastCharIsWhitespace(accum)) {
                text = TextNode.stripLeadingWhitespace(text);
            }
        }
        accum.append(text);
    }

    private static void appendWhitespaceIfBr(Element element, StringBuilder accum) {
        if (element.tag.getName().equals("br") && !TextNode.lastCharIsWhitespace(accum)) {
            accum.append(" ");
        }
    }

    boolean preserveWhitespace() {
        return this.tag.preserveWhitespace() || this.parent() != null && this.parent().preserveWhitespace();
    }

    public Element text(String text) {
        Validate.notNull(text);
        this.empty();
        TextNode textNode = new TextNode(text, this.baseUri);
        this.appendChild(textNode);
        return this;
    }

    public boolean hasText() {
        for (Node child : this.childNodes) {
            Element el;
            TextNode textNode;
            if (!(child instanceof TextNode ? !(textNode = (TextNode)child).isBlank() : child instanceof Element && (el = (Element)child).hasText())) continue;
            return true;
        }
        return false;
    }

    public String data() {
        StringBuilder sb = new StringBuilder();
        for (Node childNode : this.childNodes) {
            if (childNode instanceof DataNode) {
                DataNode data = (DataNode)childNode;
                sb.append(data.getWholeData());
                continue;
            }
            if (!(childNode instanceof Element)) continue;
            Element element = (Element)childNode;
            String elementData = element.data();
            sb.append(elementData);
        }
        return sb.toString();
    }

    public String className() {
        return this.attr("class");
    }

    public Set<String> classNames() {
        if (this.classNames == null) {
            String[] names = this.className().split("\\s+");
            this.classNames = new LinkedHashSet<String>(Arrays.asList(names));
        }
        return this.classNames;
    }

    public Element classNames(Set<String> classNames) {
        Validate.notNull(classNames);
        this.attributes.put("class", StringUtil.join(classNames, " "));
        return this;
    }

    public boolean hasClass(String className) {
        Set<String> classNames = this.classNames();
        for (String name : classNames) {
            if (!className.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Element addClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.add(className);
        this.classNames(classes);
        return this;
    }

    public Element removeClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.remove(className);
        this.classNames(classes);
        return this;
    }

    public Element toggleClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        if (classes.contains(className)) {
            classes.remove(className);
        } else {
            classes.add(className);
        }
        this.classNames(classes);
        return this;
    }

    public String val() {
        if (this.tagName().equals("textarea")) {
            return this.text();
        }
        return this.attr("value");
    }

    public Element val(String value) {
        if (this.tagName().equals("textarea")) {
            this.text(value);
        } else {
            this.attr("value", value);
        }
        return this;
    }

    @Override
    void outerHtmlHead(StringBuilder accum, int depth, Document.OutputSettings out) {
        if (accum.length() > 0 && out.prettyPrint() && (this.tag.formatAsBlock() || this.parent() != null && this.parent().tag().formatAsBlock())) {
            this.indent(accum, depth, out);
        }
        accum.append("<").append(this.tagName());
        this.attributes.html(accum, out);
        if (this.childNodes.isEmpty() && this.tag.isSelfClosing()) {
            accum.append(" />");
        } else {
            accum.append(">");
        }
    }

    @Override
    void outerHtmlTail(StringBuilder accum, int depth, Document.OutputSettings out) {
        if (!this.childNodes.isEmpty() || !this.tag.isSelfClosing()) {
            if (out.prettyPrint() && !this.childNodes.isEmpty() && this.tag.formatAsBlock()) {
                this.indent(accum, depth, out);
            }
            accum.append("</").append(this.tagName()).append(">");
        }
    }

    public String html() {
        StringBuilder accum = new StringBuilder();
        this.html(accum);
        return accum.toString().trim();
    }

    private void html(StringBuilder accum) {
        for (Node node : this.childNodes) {
            node.outerHtml(accum);
        }
    }

    public Element html(String html) {
        this.empty();
        this.append(html);
        return this;
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
        return result;
    }

    @Override
    public Element clone() {
        Element clone = (Element)super.clone();
        clone.classNames();
        return clone;
    }
}

