/*
 * Decompiled with CFR 0.152.
 */
package com.android.ondevicepersonalization.internal.util;

import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.android.ondevicepersonalization.internal.util.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

abstract class BaseOdpParceledListSlice<T>
implements Parcelable {
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getLogger();
    private static final boolean DEBUG = false;
    private static final String TAG = BaseOdpParceledListSlice.class.getSimpleName();
    private static final int MAX_IPC_SIZE = IBinder.getSuggestedMaxIpcSizeBytes();
    private final List<T> mList;
    private int mInlineCountLimit = Integer.MAX_VALUE;

    BaseOdpParceledListSlice(List<T> list) {
        this.mList = list;
    }

    BaseOdpParceledListSlice(Parcel p, ClassLoader loader) {
        int i;
        int numItems = p.readInt();
        this.mList = new ArrayList<T>(numItems);
        if (numItems <= 0) {
            return;
        }
        Parcelable.Creator<?> creator = this.readParcelableCreator(p, loader);
        Class<?> listElementClass = null;
        for (i = 0; i < numItems && p.readInt() != 0; ++i) {
            T parcelable = this.readCreator(creator, p, loader);
            if (listElementClass == null) {
                listElementClass = parcelable.getClass();
            } else {
                BaseOdpParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
            }
            this.mList.add(parcelable);
        }
        if (i >= numItems) {
            return;
        }
        IBinder retriever = p.readStrongBinder();
        while (i < numItems) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            data.writeInt(i);
            try {
                retriever.transact(1, data, reply, 0);
            }
            catch (RemoteException e) {
                sLogger.w(e, TAG + ": Failure retrieving array; only received " + i + " of " + numItems, new Object[0]);
                return;
            }
            while (i < numItems && reply.readInt() != 0) {
                T parcelable = this.readCreator(creator, reply, loader);
                BaseOdpParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                this.mList.add(parcelable);
                ++i;
            }
            reply.recycle();
            data.recycle();
        }
    }

    private static void verifySameType(Class<?> expected, Class<?> actual) {
        if (!actual.equals(expected)) {
            throw new IllegalArgumentException("Can't unparcel type " + (actual == null ? null : actual.getName()) + " in list of type " + (expected == null ? null : expected.getName()));
        }
    }

    private T readCreator(Parcelable.Creator<?> creator, Parcel p, ClassLoader loader) {
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return classLoaderCreator.createFromParcel(p, loader);
        }
        return (T)creator.createFromParcel(p);
    }

    public List<T> getList() {
        return this.mList;
    }

    public void setInlineCountLimit(int maxCount) {
        this.mInlineCountLimit = maxCount;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        final int numItems = this.mList.size();
        final int callFlags = flags;
        dest.writeInt(numItems);
        if (numItems > 0) {
            int i;
            final Class<?> listElementClass = this.mList.get(0).getClass();
            this.writeParcelableCreator(this.mList.get(0), dest);
            for (i = 0; i < numItems && i < this.mInlineCountLimit && dest.dataSize() < MAX_IPC_SIZE; ++i) {
                dest.writeInt(1);
                T parcelable = this.mList.get(i);
                BaseOdpParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                this.writeElement(parcelable, dest, callFlags);
            }
            if (i < numItems) {
                dest.writeInt(0);
                Binder retriever = new Binder(){

                    @Override
                    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                        int i;
                        if (code != 1) {
                            return super.onTransact(code, data, reply, flags);
                        }
                        for (i = data.readInt(); i < numItems && reply.dataSize() < MAX_IPC_SIZE; ++i) {
                            reply.writeInt(1);
                            Object parcelable = BaseOdpParceledListSlice.this.mList.get(i);
                            BaseOdpParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                            BaseOdpParceledListSlice.this.writeElement(parcelable, reply, callFlags);
                        }
                        if (i < numItems) {
                            reply.writeInt(0);
                        }
                        return true;
                    }
                };
                dest.writeStrongBinder(retriever);
            }
        }
    }

    protected abstract void writeElement(T var1, Parcel var2, int var3);

    protected abstract void writeParcelableCreator(T var1, Parcel var2);

    protected abstract Parcelable.Creator<?> readParcelableCreator(Parcel var1, ClassLoader var2);
}

