/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.monet;

import android.app.WallpaperColors;
import android.graphics.Color;
import com.android.internal.graphics.ColorUtils;
import com.android.systemui.monet.SchemeClock;
import com.android.systemui.monet.SchemeClockVibrant;
import com.android.systemui.monet.TonalPalette;
import com.google.ux.material.libmonet.dynamiccolor.DynamicScheme;
import com.google.ux.material.libmonet.hct.Hct;
import com.google.ux.material.libmonet.scheme.SchemeContent;
import com.google.ux.material.libmonet.scheme.SchemeExpressive;
import com.google.ux.material.libmonet.scheme.SchemeFruitSalad;
import com.google.ux.material.libmonet.scheme.SchemeMonochrome;
import com.google.ux.material.libmonet.scheme.SchemeNeutral;
import com.google.ux.material.libmonet.scheme.SchemeRainbow;
import com.google.ux.material.libmonet.scheme.SchemeTonalSpot;
import com.google.ux.material.libmonet.scheme.SchemeVibrant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Deprecated
public class ColorScheme {
    public static final int GOOGLE_BLUE = -14979341;
    private static final float ACCENT1_CHROMA = 48.0f;
    private static final int MIN_CHROMA = 5;
    private final int mSeed;
    private final boolean mIsDark;
    private final int mStyle;
    private final DynamicScheme mMaterialScheme;
    private final TonalPalette mAccent1;
    private final TonalPalette mAccent2;
    private final TonalPalette mAccent3;
    private final TonalPalette mNeutral1;
    private final TonalPalette mNeutral2;
    private final TonalPalette mError;
    private final Hct mProposedSeedHct;

    public ColorScheme(int seed, boolean isDark, int style2, double contrastLevel) {
        DynamicScheme dynamicScheme;
        this.mSeed = seed;
        this.mIsDark = isDark;
        this.mStyle = style2;
        this.mProposedSeedHct = Hct.fromInt(seed);
        Hct seedHct = Hct.fromInt(seed == 0 ? -14979341 : (style2 != 6 && this.mProposedSeedHct.getChroma() < 5.0 ? -14979341 : seed));
        switch (style2) {
            case 0: {
                dynamicScheme = new SchemeNeutral(seedHct, isDark, contrastLevel);
                break;
            }
            case 1: {
                dynamicScheme = new SchemeTonalSpot(seedHct, isDark, contrastLevel);
                break;
            }
            case 2: {
                dynamicScheme = new SchemeVibrant(seedHct, isDark, contrastLevel);
                break;
            }
            case 3: {
                dynamicScheme = new SchemeExpressive(seedHct, isDark, contrastLevel);
                break;
            }
            case 4: {
                dynamicScheme = new SchemeRainbow(seedHct, isDark, contrastLevel);
                break;
            }
            case 5: {
                dynamicScheme = new SchemeFruitSalad(seedHct, isDark, contrastLevel);
                break;
            }
            case 6: {
                dynamicScheme = new SchemeContent(seedHct, isDark, contrastLevel);
                break;
            }
            case 7: {
                dynamicScheme = new SchemeMonochrome(seedHct, isDark, contrastLevel);
                break;
            }
            case 8: {
                dynamicScheme = new SchemeClock(seedHct, isDark, contrastLevel);
                break;
            }
            case 9: {
                dynamicScheme = new SchemeClockVibrant(seedHct, isDark, contrastLevel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown style: " + style2);
            }
        }
        this.mMaterialScheme = dynamicScheme;
        this.mAccent1 = new TonalPalette(this.mMaterialScheme.primaryPalette);
        this.mAccent2 = new TonalPalette(this.mMaterialScheme.secondaryPalette);
        this.mAccent3 = new TonalPalette(this.mMaterialScheme.tertiaryPalette);
        this.mNeutral1 = new TonalPalette(this.mMaterialScheme.neutralPalette);
        this.mNeutral2 = new TonalPalette(this.mMaterialScheme.neutralVariantPalette);
        this.mError = new TonalPalette(this.mMaterialScheme.errorPalette);
    }

    public ColorScheme(int seed, boolean darkTheme) {
        this(seed, darkTheme, 1);
    }

    public ColorScheme(int seed, boolean darkTheme, int style2) {
        this(seed, darkTheme, style2, 0.0);
    }

    public ColorScheme(WallpaperColors wallpaperColors, boolean darkTheme, int style2) {
        this(ColorScheme.getSeedColor(wallpaperColors, style2 != 6), darkTheme, style2);
    }

    public ColorScheme(WallpaperColors wallpaperColors, boolean darkTheme) {
        this(wallpaperColors, darkTheme, 1);
    }

    public int getBackgroundColor() {
        return ColorUtils.setAlphaComponent(this.mIsDark ? this.mNeutral1.getS700() : this.mNeutral1.getS10(), 255);
    }

    public int getAccentColor() {
        return ColorUtils.setAlphaComponent(this.mIsDark ? this.mAccent1.getS100() : this.mAccent1.getS500(), 255);
    }

    public double getSeedTone() {
        return 1000.0 - this.mProposedSeedHct.getTone() * 10.0;
    }

    public int getSeed() {
        return this.mSeed;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public DynamicScheme getMaterialScheme() {
        return this.mMaterialScheme;
    }

    public TonalPalette getAccent1() {
        return this.mAccent1;
    }

    public TonalPalette getAccent2() {
        return this.mAccent2;
    }

    public TonalPalette getAccent3() {
        return this.mAccent3;
    }

    public TonalPalette getNeutral1() {
        return this.mNeutral1;
    }

    public TonalPalette getNeutral2() {
        return this.mNeutral2;
    }

    public TonalPalette getError() {
        return this.mError;
    }

    public String toString() {
        return "ColorScheme {\n  seed color: " + ColorScheme.stringForColor(this.mSeed) + "\n  style: " + this.mStyle + "\n  palettes: \n  " + ColorScheme.humanReadable("PRIMARY", this.mAccent1.allShades) + "\n  " + ColorScheme.humanReadable("SECONDARY", this.mAccent2.allShades) + "\n  " + ColorScheme.humanReadable("TERTIARY", this.mAccent3.allShades) + "\n  " + ColorScheme.humanReadable("NEUTRAL", this.mNeutral1.allShades) + "\n  " + ColorScheme.humanReadable("NEUTRAL VARIANT", this.mNeutral2.allShades) + "\n}";
    }

    public static int getSeedColor(WallpaperColors wallpaperColors, boolean filter) {
        return ColorScheme.getSeedColors(wallpaperColors, filter).get(0);
    }

    public static int getSeedColor(WallpaperColors wallpaperColors) {
        return ColorScheme.getSeedColor(wallpaperColors, true);
    }

    public static List<Integer> getSeedColors(WallpaperColors wallpaperColors, boolean filter) {
        boolean totalPopulationMeaningless;
        double totalPopulation = wallpaperColors.getAllColors().values().stream().mapToInt(Integer::intValue).sum();
        boolean bl = totalPopulationMeaningless = totalPopulation == 0.0;
        if (totalPopulationMeaningless) {
            List<Integer> distinctColors = wallpaperColors.getMainColors().stream().map(Color::toArgb).distinct().filter(color2 -> !filter || Hct.fromInt(color2).getChroma() >= 5.0).collect(Collectors.toList());
            if (distinctColors.isEmpty()) {
                return List.of(Integer.valueOf(-14979341));
            }
            return distinctColors;
        }
        Map<Integer, Double> intToProportion = wallpaperColors.getAllColors().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Integer)entry.getValue()).doubleValue() / totalPopulation));
        Map<Integer, Hct> intToHct = wallpaperColors.getAllColors().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Hct.fromInt((Integer)entry.getKey())));
        List<Double> hueProportions = ColorScheme.huePopulations(intToHct, intToProportion, filter);
        Map<Integer, Double> intToHueProportion = wallpaperColors.getAllColors().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Hct hct = (Hct)intToHct.get(entry.getKey());
            int hue = (int)Math.round(hct.getHue());
            double proportion = 0.0;
            for (int i = hue - 15; i <= hue + 15; ++i) {
                proportion += ((Double)hueProportions.get(ColorScheme.wrapDegrees(i))).doubleValue();
            }
            return proportion;
        }));
        Map<Integer, Hct> filteredIntToHct = filter ? intToHct.entrySet().stream().filter(entry -> {
            Hct hct = (Hct)entry.getValue();
            double proportion = (Double)intToHueProportion.get(entry.getKey());
            return hct.getChroma() >= 5.0 && proportion > 0.01;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : intToHct;
        List intToScore = filteredIntToHct.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<Integer, Double>((Integer)entry.getKey(), ColorScheme.score((Hct)entry.getValue(), (Double)intToHueProportion.get(entry.getKey())))).sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
        int minimumHueDistance = 15;
        ArrayList<Integer> seeds = new ArrayList<Integer>();
        for (int i = 90; i >= minimumHueDistance; --i) {
            seeds.clear();
            for (Map.Entry entry2 : intToScore) {
                int currentColor = (Integer)entry2.getKey();
                int finalI = i;
                boolean existingSeedNearby = seeds.stream().anyMatch(seed -> {
                    double hueB;
                    double hueA = ((Hct)intToHct.get(currentColor)).getHue();
                    return ColorScheme.hueDiff(hueA, hueB = ((Hct)intToHct.get(seed)).getHue()) < (double)finalI;
                });
                if (existingSeedNearby) continue;
                seeds.add(currentColor);
                if (seeds.size() < 4) continue;
                break;
            }
            if (!seeds.isEmpty()) break;
        }
        if (seeds.isEmpty()) {
            seeds.add(-14979341);
        }
        return seeds;
    }

    public static List<Integer> getSeedColors(WallpaperColors newWallpaperColors) {
        return ColorScheme.getSeedColors(newWallpaperColors, true);
    }

    private static int wrapDegrees(int degrees) {
        if (degrees < 0) {
            return degrees % 360 + 360;
        }
        if (degrees >= 360) {
            return degrees % 360;
        }
        return degrees;
    }

    private static double hueDiff(double a, double b) {
        double diff = Math.abs(a - b);
        if (diff > 180.0) {
            diff = 360.0 - diff;
        }
        return diff;
    }

    private static String stringForColor(int color2) {
        int width = 4;
        Hct hct = Hct.fromInt(color2);
        String h = "H" + String.format("%" + width + "s", Math.round(hct.getHue()));
        String c = "C" + String.format("%" + width + "s", Math.round(hct.getChroma()));
        String t = "T" + String.format("%" + width + "s", Math.round(hct.getTone()));
        String hex = Integer.toHexString(color2 & 0xFFFFFF).toUpperCase();
        return h + c + t + " = #" + hex;
    }

    private static String humanReadable(String paletteName, List<Integer> colors) {
        return paletteName + "\n" + colors.stream().map(ColorScheme::stringForColor).collect(Collectors.joining("\n"));
    }

    private static double score(Hct hct, double proportion) {
        double proportionScore = 70.0 * proportion;
        double chromaScore = hct.getChroma() < 48.0 ? 0.1 * (hct.getChroma() - 48.0) : 0.3 * (hct.getChroma() - 48.0);
        return chromaScore + proportionScore;
    }

    private static List<Double> huePopulations(Map<Integer, Hct> hctByColor, Map<Integer, Double> populationByColor, boolean filter) {
        ArrayList<Double> huePopulation = new ArrayList<Double>(Collections.nCopies(360, 0.0));
        for (Map.Entry<Integer, Double> entry : populationByColor.entrySet()) {
            double population = entry.getValue();
            Hct hct = hctByColor.get(entry.getKey());
            int hue = (int)Math.round(hct.getHue()) % 360;
            if (filter && hct.getChroma() <= 5.0) continue;
            huePopulation.set(hue, (Double)huePopulation.get(hue) + population);
        }
        return huePopulation;
    }
}

