/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.monet;

import android.annotation.NonNull;
import android.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Style {
    public static final int SPRITZ = 0;
    public static final int TONAL_SPOT = 1;
    public static final int VIBRANT = 2;
    public static final int EXPRESSIVE = 3;
    public static final int RAINBOW = 4;
    public static final int FRUIT_SALAD = 5;
    public static final int CONTENT = 6;
    public static final int MONOCHROMATIC = 7;
    public static final int CLOCK = 8;
    public static final int CLOCK_VIBRANT = 9;

    private Style() {
    }

    @NonNull
    public static String toString(@Nullable Integer style2) {
        String string2;
        if (style2 == null) {
            throw new IllegalArgumentException("Invalid style value: null");
        }
        switch (style2) {
            case 0: {
                string2 = "SPRITZ";
                break;
            }
            case 1: {
                string2 = "TONAL_SPOT";
                break;
            }
            case 2: {
                string2 = "VIBRANT";
                break;
            }
            case 3: {
                string2 = "EXPRESSIVE";
                break;
            }
            case 4: {
                string2 = "RAINBOW";
                break;
            }
            case 5: {
                string2 = "FRUIT_SALAD";
                break;
            }
            case 6: {
                string2 = "CONTENT";
                break;
            }
            case 7: {
                string2 = "MONOCHROMATIC";
                break;
            }
            case 8: {
                string2 = "CLOCK";
                break;
            }
            case 9: {
                string2 = "CLOCK_VIBRANT";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid style value: " + style2);
            }
        }
        return string2;
    }

    public static int valueOf(@Nullable @NonNull String styleName) {
        int n;
        if (styleName == null) {
            throw new IllegalArgumentException("Invalid style value: null");
        }
        switch (styleName) {
            case "SPRITZ": {
                n = 0;
                break;
            }
            case "TONAL_SPOT": {
                n = 1;
                break;
            }
            case "VIBRANT": {
                n = 2;
                break;
            }
            case "EXPRESSIVE": {
                n = 3;
                break;
            }
            case "RAINBOW": {
                n = 4;
                break;
            }
            case "FRUIT_SALAD": {
                n = 5;
                break;
            }
            case "CONTENT": {
                n = 6;
                break;
            }
            case "MONOCHROMATIC": {
                n = 7;
                break;
            }
            case "CLOCK": {
                n = 8;
                break;
            }
            case "CLOCK_VIBRANT": {
                n = 9;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid style name: " + styleName);
            }
        }
        return n;
    }

    @NonNull
    public static String name(int style2) {
        return Style.toString(style2);
    }

    public static int[] values() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

