/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.validator;

import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.tools.idea.validator.ValidatorData;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;

public class ValidatorResult {
    private final ImmutableBiMap<Long, View> mSrcMap;
    private final ImmutableBiMap<Long, AccessibilityNodeInfo> mNodeInfoMap;
    private final ArrayList<ValidatorData.Issue> mIssues;
    private final Metric mMetric;

    private ValidatorResult(BiMap<Long, View> srcMap, BiMap<Long, AccessibilityNodeInfo> nodeInfoMap, ArrayList<ValidatorData.Issue> issues, Metric metric) {
        this.mSrcMap = ImmutableBiMap.builder().putAll(srcMap).build();
        this.mNodeInfoMap = ImmutableBiMap.builder().putAll(nodeInfoMap).build();
        this.mIssues = issues;
        this.mMetric = metric;
    }

    public ImmutableBiMap<Long, View> getSrcMap() {
        return this.mSrcMap;
    }

    public ImmutableBiMap<Long, AccessibilityNodeInfo> getNodeInfoMap() {
        return this.mNodeInfoMap;
    }

    public List<ValidatorData.Issue> getIssues() {
        return this.mIssues;
    }

    public Metric getMetric() {
        return this.mMetric;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("Result containing ").append(this.mIssues.size()).append(" issues:\n");
        for (ValidatorData.Issue issue : this.mIssues) {
            if (issue.mLevel != ValidatorData.Level.ERROR) continue;
            builder.append(" - [").append(issue.mLevel.name()).append("] ").append(issue.mMsg).append("\n");
        }
        return builder.toString();
    }

    public static class Metric {
        public String mErrorMessage = null;
        public long mHierarchyCreationMs = 0L;
        public long mGenerateResultsMs = 0L;
        public long mImageMemoryBytes = 0L;
        public final List<ImageSize> mImageSizes = new ArrayList<ImageSize>();
        private long mHierarchyCreationTimeStart;
        private long mGenerateRulesTimeStart;

        private Metric() {
        }

        public void startHierarchyCreationTimer() {
            this.mHierarchyCreationTimeStart = System.currentTimeMillis();
        }

        public void recordHierarchyCreationTime() {
            this.mHierarchyCreationMs = System.currentTimeMillis() - this.mHierarchyCreationTimeStart;
        }

        public void startGenerateResultsTimer() {
            this.mGenerateRulesTimeStart = System.currentTimeMillis();
        }

        public void recordGenerateResultsTime() {
            this.mGenerateResultsMs = System.currentTimeMillis() - this.mGenerateRulesTimeStart;
        }

        public String toString() {
            return "Validation result metric: { hierarchy creation=" + this.mHierarchyCreationMs + "ms, image memory=" + this.readableBytes() + " }";
        }

        private String readableBytes() {
            if (this.mImageMemoryBytes > 1000000000L) {
                return this.mImageMemoryBytes / 1000000000L + "gb";
            }
            if (this.mImageMemoryBytes > 1000000L) {
                return this.mImageMemoryBytes / 1000000L + "mb";
            }
            if (this.mImageMemoryBytes > 1000L) {
                return this.mImageMemoryBytes / 1000L + "kb";
            }
            return this.mImageMemoryBytes + "bytes";
        }
    }

    public static class ImageSize {
        private final int mLeft;
        private final int mTop;
        private final int mWidth;
        private final int mHeight;

        public ImageSize(int left, int top, int width, int height) {
            this.mLeft = left;
            this.mTop = top;
            this.mWidth = width;
            this.mHeight = height;
        }

        public String toString() {
            return "ImageSize{mLeft=" + this.mLeft + ", mTop=" + this.mTop + ", mWidth=" + this.mWidth + ", mHeight=" + this.mHeight + '}';
        }
    }

    public static class Builder {
        public final BiMap<Long, View> mSrcMap = HashBiMap.create();
        public final BiMap<Long, AccessibilityNodeInfo> mNodeInfoMap = HashBiMap.create();
        public final ArrayList<ValidatorData.Issue> mIssues = new ArrayList();
        public final Metric mMetric = new Metric();

        public ValidatorResult build() {
            return new ValidatorResult(this.mSrcMap, this.mNodeInfoMap, this.mIssues, this.mMetric);
        }
    }
}

