/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.replacements;

import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AndroidFrameworkProtos;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LayoutParams {
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    private final int width;
    private final int height;

    public LayoutParams(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public LayoutParams(AndroidFrameworkProtos.LayoutParamsProto layoutParamsProto) {
        this(layoutParamsProto.getWidth(), layoutParamsProto.getHeight());
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public AndroidFrameworkProtos.LayoutParamsProto toProto() {
        return (AndroidFrameworkProtos.LayoutParamsProto)AndroidFrameworkProtos.LayoutParamsProto.newBuilder().setWidth(this.width).setHeight(this.height).build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LayoutParams) {
            LayoutParams params = (LayoutParams)o;
            return params.width == this.width && params.height == this.height;
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.width + this.height;
    }

    public String toString() {
        return "LayoutParams(" + this.width + ", " + this.height + ")";
    }
}

