/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.replacements;

import com.google.android.apps.common.testing.accessibility.framework.replacements.Span;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Spans;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AndroidFrameworkProtos;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class SpannableString
implements CharSequence {
    protected final CharSequence rawString;
    protected ImmutableList<Span> spans;

    public SpannableString(AndroidFrameworkProtos.CharSequenceProto proto) {
        this.rawString = proto.getText();
        ImmutableList.Builder spansBuilder = ImmutableList.builder();
        for (AndroidFrameworkProtos.SpanProto span : proto.getSpanList()) {
            Span localSpan;
            switch (span.getType()) {
                case URL: {
                    localSpan = new Spans.URLSpan(span);
                    break;
                }
                case CLICKABLE: {
                    localSpan = new Spans.ClickableSpan(span);
                    break;
                }
                case STYLE: {
                    localSpan = new Spans.StyleSpan(span);
                    break;
                }
                case UNDERLINE: {
                    localSpan = new Spans.UnderlineSpan(span);
                    break;
                }
                case BACKGROUND_COLOR: {
                    localSpan = new Spans.BackgroundColorSpan(span);
                    break;
                }
                case FOREGROUND_COLOR: {
                    localSpan = new Spans.ForegroundColorSpan(span);
                    break;
                }
                case UNKNOWN: {
                    localSpan = new Span(span);
                    break;
                }
                default: {
                    localSpan = null;
                }
            }
            if (localSpan == null) continue;
            spansBuilder.add((Object)localSpan);
        }
        this.spans = spansBuilder.build();
    }

    public SpannableString(CharSequence rawString, List<Span> spans) {
        this.rawString = rawString;
        this.spans = ImmutableList.copyOf(spans);
    }

    protected SpannableString(CharSequence rawString) {
        this(rawString, (List<Span>)ImmutableList.of());
    }

    public List<Span> getSpans() {
        return this.spans;
    }

    @Override
    public int length() {
        return this.rawString.length();
    }

    @Override
    public char charAt(int index) {
        return this.rawString.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.rawString.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.rawString.toString();
    }

    public AndroidFrameworkProtos.CharSequenceProto toProto() {
        AndroidFrameworkProtos.CharSequenceProto.Builder builder = AndroidFrameworkProtos.CharSequenceProto.newBuilder();
        builder.setText(this.rawString.toString());
        for (Span span : this.spans) {
            builder.addSpan(span.toProto());
        }
        return (AndroidFrameworkProtos.CharSequenceProto)builder.build();
    }
}

