/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestionProducer;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.SetViewAttributeFixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.ContrastUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class BaseTextContrastFixSuggestionProducer
implements FixSuggestionProducer<SetViewAttributeFixSuggestion> {
    BaseTextContrastFixSuggestionProducer() {
    }

    @Override
    public @Nullable SetViewAttributeFixSuggestion produceFixSuggestion(AccessibilityHierarchyCheckResult checkResult, AccessibilityHierarchy hierarchy, @Nullable Parameters parameters) {
        ResultMetadata metadata = checkResult.getMetadata();
        if (metadata == null) {
            return null;
        }
        ViewHierarchyElement element = checkResult.getElement();
        if (element == null) {
            return null;
        }
        if (metadata.getBoolean("KEY_IS_POTENTIALLY_OBSCURED", false)) {
            return null;
        }
        return this.produceTextContrastFixSuggestion(checkResult.getResultId(), element, metadata);
    }

    protected abstract @Nullable SetViewAttributeFixSuggestion produceTextContrastFixSuggestion(int var1, ViewHierarchyElement var2, ResultMetadata var3);

    static SetViewAttributeFixSuggestion createSetViewAttributeFixSuggestion(String viewAttributeName, int suggestedColor) {
        String suggestedColorValue = ContrastUtils.colorToHexString(suggestedColor);
        return new SetViewAttributeFixSuggestion(viewAttributeName, suggestedColorValue);
    }

    static int getTextColor(ResultMetadata metadata) {
        if (metadata.containsKey("KEY_TEXT_COLOR")) {
            return metadata.getInt("KEY_TEXT_COLOR");
        }
        return metadata.getInt("KEY_FOREGROUND_COLOR");
    }

    static int getBackgroundColor(ResultMetadata metadata) {
        return metadata.getInt("KEY_BACKGROUND_COLOR");
    }

    static double getRequiredContrastRatio(ResultMetadata metadata) {
        if (metadata.containsKey("KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO")) {
            return metadata.getDouble("KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO");
        }
        return metadata.getDouble("KEY_REQUIRED_CONTRAST_RATIO");
    }
}

