/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchyOrigin;
import com.google.android.apps.common.testing.accessibility.framework.uielement.DeviceState;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.WindowHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AccessibilityHierarchy {
    private final DeviceState deviceState;
    private final AccessibilityHierarchyOrigin origin;
    private final ImmutableList<? extends WindowHierarchyElement> windowHierarchyElements;
    private final WindowHierarchyElement activeWindow;
    protected final ViewElementClassNames viewElementClassNames;

    protected AccessibilityHierarchy(DeviceState deviceState, AccessibilityHierarchyOrigin origin, ImmutableList<? extends WindowHierarchyElement> windowHierarchyElements, WindowHierarchyElement activeWindow, ViewElementClassNames viewElementClassNames) {
        this.deviceState = deviceState;
        this.origin = origin;
        this.windowHierarchyElements = windowHierarchyElements;
        this.activeWindow = activeWindow;
        this.viewElementClassNames = viewElementClassNames;
    }

    public DeviceState getDeviceState() {
        return this.deviceState;
    }

    public AccessibilityHierarchyOrigin getOrigin() {
        return this.origin;
    }

    public Collection<? extends WindowHierarchyElement> getAllWindows() {
        return this.windowHierarchyElements;
    }

    public WindowHierarchyElement getActiveWindow() {
        return this.activeWindow;
    }

    public WindowHierarchyElement getWindowById(int id2) {
        if (id2 < 0 || id2 >= this.windowHierarchyElements.size()) {
            throw new NoSuchElementException();
        }
        return (WindowHierarchyElement)this.windowHierarchyElements.get(id2);
    }

    public ViewHierarchyElement getViewById(long condensedUniqueId) {
        int windowId = (int)(condensedUniqueId >>> 32);
        int viewId = (int)condensedUniqueId;
        return this.getWindowById(windowId).getViewById(viewId);
    }

    public AccessibilityHierarchyProtos.AccessibilityHierarchyProto toProto() {
        AccessibilityHierarchyProtos.AccessibilityHierarchyProto.Builder builder = AccessibilityHierarchyProtos.AccessibilityHierarchyProto.newBuilder();
        builder.setDeviceState(this.getDeviceState().toProto()).setOrigin(this.getOrigin().toProto()).setActiveWindowId(this.getActiveWindow().getId()).setViewElementClassNames(this.getViewElementClassNames().toProto());
        for (WindowHierarchyElement window : this.windowHierarchyElements) {
            builder.addWindows(window.toProto());
        }
        return (AccessibilityHierarchyProtos.AccessibilityHierarchyProto)builder.build();
    }

    private void setAccessibilityHierarchy() {
        for (WindowHierarchyElement window : this.windowHierarchyElements) {
            window.setAccessibilityHierarchy(this);
        }
    }

    public static Builder newBuilder(AccessibilityHierarchyProtos.AccessibilityHierarchyProto proto) {
        Preconditions.checkNotNull((Object)proto);
        return new Builder(proto);
    }

    ViewElementClassNames getViewElementClassNames() {
        return this.viewElementClassNames;
    }

    static class ViewElementClassNames {
        protected ImmutableBiMap<String, Integer> uniqueViewElementsClassNames;

        protected ViewElementClassNames() {
        }

        public ViewElementClassNames(Map<String, Integer> viewElementsMap) {
            this.uniqueViewElementsClassNames = ImmutableBiMap.copyOf(viewElementsMap);
        }

        public ViewElementClassNames(AccessibilityHierarchyProtos.ViewElementClassNamesProto proto) {
            this.uniqueViewElementsClassNames = ImmutableBiMap.copyOf(proto.getClassNameMap());
        }

        public @Nullable Integer getIdentifierForClassName(String className) {
            return (Integer)this.uniqueViewElementsClassNames.get((Object)className);
        }

        public @Nullable String getClassNameForIdentifier(int id2) {
            return (String)this.uniqueViewElementsClassNames.inverse().get((Object)id2);
        }

        AccessibilityHierarchyProtos.ViewElementClassNamesProto toProto() {
            return (AccessibilityHierarchyProtos.ViewElementClassNamesProto)AccessibilityHierarchyProtos.ViewElementClassNamesProto.newBuilder().putAllClassName((Map<String, Integer>)this.uniqueViewElementsClassNames).build();
        }

        ImmutableBiMap<String, Integer> getMap() {
            return this.uniqueViewElementsClassNames;
        }
    }

    public static class Builder {
        private final AccessibilityHierarchyProtos.AccessibilityHierarchyProto proto;

        Builder(AccessibilityHierarchyProtos.AccessibilityHierarchyProto proto) {
            this.proto = proto;
        }

        public AccessibilityHierarchy build() {
            DeviceState deviceState = new DeviceState(this.proto.getDeviceState());
            AccessibilityHierarchyOrigin origin = AccessibilityHierarchyOrigin.fromProto(this.proto.getOrigin());
            int activeWindowId = this.proto.getActiveWindowId();
            ImmutableList.Builder windowHierarchyElementsBuilder = ImmutableList.builderWithExpectedSize((int)this.proto.getWindowsCount());
            for (AccessibilityHierarchyProtos.WindowHierarchyElementProto windowProto : this.proto.getWindowsList()) {
                windowHierarchyElementsBuilder.add((Object)WindowHierarchyElement.newBuilder(windowProto).build());
            }
            ImmutableList windowHierarchyElements = windowHierarchyElementsBuilder.build();
            Preconditions.checkState((!windowHierarchyElements.isEmpty() ? 1 : 0) != 0, (Object)"Hierarchies must contain at least one window.");
            WindowHierarchyElement activeWindow = (WindowHierarchyElement)windowHierarchyElements.get(activeWindowId);
            ViewElementClassNames viewElementClassNames = new ViewElementClassNames(this.proto.getViewElementClassNames());
            AccessibilityHierarchy hierarchy = new AccessibilityHierarchy(deviceState, origin, (ImmutableList<? extends WindowHierarchyElement>)windowHierarchyElements, activeWindow, viewElementClassNames);
            hierarchy.setAccessibilityHierarchy();
            return hierarchy;
        }
    }
}

