/*
 * Decompiled with CFR 0.152.
 */
package com.google.ux.material.libmonet.dynamiccolor;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.google.ux.material.libmonet.contrast.Contrast;
import com.google.ux.material.libmonet.dislike.DislikeAnalyzer;
import com.google.ux.material.libmonet.dynamiccolor.ColorSpec;
import com.google.ux.material.libmonet.dynamiccolor.ContrastCurve;
import com.google.ux.material.libmonet.dynamiccolor.DynamicColor;
import com.google.ux.material.libmonet.dynamiccolor.DynamicScheme;
import com.google.ux.material.libmonet.dynamiccolor.ToneDeltaPair;
import com.google.ux.material.libmonet.dynamiccolor.TonePolarity;
import com.google.ux.material.libmonet.dynamiccolor.Variant;
import com.google.ux.material.libmonet.hct.Hct;
import com.google.ux.material.libmonet.palettes.TonalPalette;
import com.google.ux.material.libmonet.temperature.TemperatureCache;
import com.google.ux.material.libmonet.utils.MathUtils;
import java.util.ArrayList;
import java.util.Optional;

class ColorSpec2021
implements ColorSpec {
    ColorSpec2021() {
    }

    @Override
    @NonNull
    public DynamicColor primaryPaletteKeyColor() {
        return new DynamicColor.Builder().setName("primary_palette_key_color").setPalette(s -> s.primaryPalette).setTone(s -> s.primaryPalette.getKeyColor().getTone()).build();
    }

    @Override
    @NonNull
    public DynamicColor secondaryPaletteKeyColor() {
        return new DynamicColor.Builder().setName("secondary_palette_key_color").setPalette(s -> s.secondaryPalette).setTone(s -> s.secondaryPalette.getKeyColor().getTone()).build();
    }

    @Override
    @NonNull
    public DynamicColor tertiaryPaletteKeyColor() {
        return new DynamicColor.Builder().setName("tertiary_palette_key_color").setPalette(s -> s.tertiaryPalette).setTone(s -> s.tertiaryPalette.getKeyColor().getTone()).build();
    }

    @Override
    @NonNull
    public DynamicColor neutralPaletteKeyColor() {
        return new DynamicColor.Builder().setName("neutral_palette_key_color").setPalette(s -> s.neutralPalette).setTone(s -> s.neutralPalette.getKeyColor().getTone()).build();
    }

    @Override
    @NonNull
    public DynamicColor neutralVariantPaletteKeyColor() {
        return new DynamicColor.Builder().setName("neutral_variant_palette_key_color").setPalette(s -> s.neutralVariantPalette).setTone(s -> s.neutralVariantPalette.getKeyColor().getTone()).build();
    }

    @Override
    @NonNull
    public DynamicColor errorPaletteKeyColor() {
        return new DynamicColor.Builder().setName("error_palette_key_color").setPalette(s -> s.errorPalette).setTone(s -> s.errorPalette.getKeyColor().getTone()).build();
    }

    @Override
    @NonNull
    public DynamicColor background() {
        return new DynamicColor.Builder().setName("background").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 6.0 : 98.0).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor onBackground() {
        return new DynamicColor.Builder().setName("on_background").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 90.0 : 10.0).setBackground(s -> this.background()).setContrastCurve(s -> new ContrastCurve(3.0, 3.0, 4.5, 7.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor surface() {
        return new DynamicColor.Builder().setName("surface").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 6.0 : 98.0).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor surfaceDim() {
        return new DynamicColor.Builder().setName("surface_dim").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 6.0 : new ContrastCurve(87.0, 87.0, 80.0, 75.0).get(s.contrastLevel)).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor surfaceBright() {
        return new DynamicColor.Builder().setName("surface_bright").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? new ContrastCurve(24.0, 24.0, 29.0, 34.0).get(s.contrastLevel) : 98.0).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor surfaceContainerLowest() {
        return new DynamicColor.Builder().setName("surface_container_lowest").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? new ContrastCurve(4.0, 4.0, 2.0, 0.0).get(s.contrastLevel) : 100.0).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor surfaceContainerLow() {
        return new DynamicColor.Builder().setName("surface_container_low").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? new ContrastCurve(10.0, 10.0, 11.0, 12.0).get(s.contrastLevel) : new ContrastCurve(96.0, 96.0, 96.0, 95.0).get(s.contrastLevel)).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor surfaceContainer() {
        return new DynamicColor.Builder().setName("surface_container").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? new ContrastCurve(12.0, 12.0, 16.0, 20.0).get(s.contrastLevel) : new ContrastCurve(94.0, 94.0, 92.0, 90.0).get(s.contrastLevel)).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor surfaceContainerHigh() {
        return new DynamicColor.Builder().setName("surface_container_high").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? new ContrastCurve(17.0, 17.0, 21.0, 25.0).get(s.contrastLevel) : new ContrastCurve(92.0, 92.0, 88.0, 85.0).get(s.contrastLevel)).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor surfaceContainerHighest() {
        return new DynamicColor.Builder().setName("surface_container_highest").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? new ContrastCurve(22.0, 22.0, 26.0, 30.0).get(s.contrastLevel) : new ContrastCurve(90.0, 90.0, 84.0, 80.0).get(s.contrastLevel)).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor onSurface() {
        return new DynamicColor.Builder().setName("on_surface").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 90.0 : 10.0).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(4.5, 7.0, 11.0, 21.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor surfaceVariant() {
        return new DynamicColor.Builder().setName("surface_variant").setPalette(s -> s.neutralVariantPalette).setTone(s -> s.isDark ? 30.0 : 90.0).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor onSurfaceVariant() {
        return new DynamicColor.Builder().setName("on_surface_variant").setPalette(s -> s.neutralVariantPalette).setTone(s -> s.isDark ? 80.0 : 30.0).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 11.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor inverseSurface() {
        return new DynamicColor.Builder().setName("inverse_surface").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 90.0 : 20.0).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor inverseOnSurface() {
        return new DynamicColor.Builder().setName("inverse_on_surface").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 20.0 : 95.0).setBackground(s -> this.inverseSurface()).setContrastCurve(s -> new ContrastCurve(4.5, 7.0, 11.0, 21.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor outline() {
        return new DynamicColor.Builder().setName("outline").setPalette(s -> s.neutralVariantPalette).setTone(s -> s.isDark ? 60.0 : 50.0).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.5, 3.0, 4.5, 7.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor outlineVariant() {
        return new DynamicColor.Builder().setName("outline_variant").setPalette(s -> s.neutralVariantPalette).setTone(s -> s.isDark ? 30.0 : 80.0).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.0, 1.0, 3.0, 4.5)).build();
    }

    @Override
    @NonNull
    public DynamicColor shadow() {
        return new DynamicColor.Builder().setName("shadow").setPalette(s -> s.neutralPalette).setTone(s -> 0.0).build();
    }

    @Override
    @NonNull
    public DynamicColor scrim() {
        return new DynamicColor.Builder().setName("scrim").setPalette(s -> s.neutralPalette).setTone(s -> 0.0).build();
    }

    @Override
    @NonNull
    public DynamicColor surfaceTint() {
        return new DynamicColor.Builder().setName("surface_tint").setPalette(s -> s.primaryPalette).setTone(s -> s.isDark ? 80.0 : 40.0).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor primary() {
        return new DynamicColor.Builder().setName("primary").setPalette(s -> s.primaryPalette).setTone(s -> {
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 100.0 : 0.0;
            }
            return s.isDark ? 80.0 : 40.0;
        }).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 7.0)).setToneDeltaPair(s -> new ToneDeltaPair(this.primaryContainer(), this.primary(), 10.0, TonePolarity.NEARER, false)).build();
    }

    @Override
    @Nullable
    public DynamicColor primaryDim() {
        return null;
    }

    @Override
    @NonNull
    public DynamicColor onPrimary() {
        return new DynamicColor.Builder().setName("on_primary").setPalette(s -> s.primaryPalette).setTone(s -> {
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 10.0 : 90.0;
            }
            return s.isDark ? 20.0 : 100.0;
        }).setBackground(s -> this.primary()).setContrastCurve(s -> new ContrastCurve(4.5, 7.0, 11.0, 21.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor primaryContainer() {
        return new DynamicColor.Builder().setName("primary_container").setPalette(s -> s.primaryPalette).setTone(s -> {
            if (this.isFidelity((DynamicScheme)s)) {
                return s.sourceColorHct.getTone();
            }
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 85.0 : 25.0;
            }
            return s.isDark ? 30.0 : 90.0;
        }).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.0, 1.0, 3.0, 4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.primaryContainer(), this.primary(), 10.0, TonePolarity.NEARER, false)).build();
    }

    @Override
    @NonNull
    public DynamicColor onPrimaryContainer() {
        return new DynamicColor.Builder().setName("on_primary_container").setPalette(s -> s.primaryPalette).setTone(s -> {
            if (this.isFidelity((DynamicScheme)s)) {
                return DynamicColor.foregroundTone(this.primaryContainer().tone.apply((DynamicScheme)s), 4.5);
            }
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 0.0 : 100.0;
            }
            return s.isDark ? 90.0 : 30.0;
        }).setBackground(s -> this.primaryContainer()).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 11.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor inversePrimary() {
        return new DynamicColor.Builder().setName("inverse_primary").setPalette(s -> s.primaryPalette).setTone(s -> s.isDark ? 40.0 : 80.0).setBackground(s -> this.inverseSurface()).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 7.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor secondary() {
        return new DynamicColor.Builder().setName("secondary").setPalette(s -> s.secondaryPalette).setTone(s -> s.isDark ? 80.0 : 40.0).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 7.0)).setToneDeltaPair(s -> new ToneDeltaPair(this.secondaryContainer(), this.secondary(), 10.0, TonePolarity.NEARER, false)).build();
    }

    @Override
    @Nullable
    public DynamicColor secondaryDim() {
        return null;
    }

    @Override
    @NonNull
    public DynamicColor onSecondary() {
        return new DynamicColor.Builder().setName("on_secondary").setPalette(s -> s.secondaryPalette).setTone(s -> {
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 10.0 : 100.0;
            }
            return s.isDark ? 20.0 : 100.0;
        }).setBackground(s -> this.secondary()).setContrastCurve(s -> new ContrastCurve(4.5, 7.0, 11.0, 21.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor secondaryContainer() {
        return new DynamicColor.Builder().setName("secondary_container").setPalette(s -> s.secondaryPalette).setTone(s -> {
            double initialTone;
            double d = initialTone = s.isDark ? 30.0 : 90.0;
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 30.0 : 85.0;
            }
            if (!this.isFidelity((DynamicScheme)s)) {
                return initialTone;
            }
            return ColorSpec2021.findDesiredChromaByTone(s.secondaryPalette.getHue(), s.secondaryPalette.getChroma(), initialTone, !s.isDark);
        }).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.0, 1.0, 3.0, 4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.secondaryContainer(), this.secondary(), 10.0, TonePolarity.NEARER, false)).build();
    }

    @Override
    @NonNull
    public DynamicColor onSecondaryContainer() {
        return new DynamicColor.Builder().setName("on_secondary_container").setPalette(s -> s.secondaryPalette).setTone(s -> {
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 90.0 : 10.0;
            }
            if (!this.isFidelity((DynamicScheme)s)) {
                return s.isDark ? 90.0 : 30.0;
            }
            return DynamicColor.foregroundTone(this.secondaryContainer().tone.apply((DynamicScheme)s), 4.5);
        }).setBackground(s -> this.secondaryContainer()).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 11.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor tertiary() {
        return new DynamicColor.Builder().setName("tertiary").setPalette(s -> s.tertiaryPalette).setTone(s -> {
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 90.0 : 25.0;
            }
            return s.isDark ? 80.0 : 40.0;
        }).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 7.0)).setToneDeltaPair(s -> new ToneDeltaPair(this.tertiaryContainer(), this.tertiary(), 10.0, TonePolarity.NEARER, false)).build();
    }

    @Override
    @Nullable
    public DynamicColor tertiaryDim() {
        return null;
    }

    @Override
    @NonNull
    public DynamicColor onTertiary() {
        return new DynamicColor.Builder().setName("on_tertiary").setPalette(s -> s.tertiaryPalette).setTone(s -> {
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 10.0 : 90.0;
            }
            return s.isDark ? 20.0 : 100.0;
        }).setBackground(s -> this.tertiary()).setContrastCurve(s -> new ContrastCurve(4.5, 7.0, 11.0, 21.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor tertiaryContainer() {
        return new DynamicColor.Builder().setName("tertiary_container").setPalette(s -> s.tertiaryPalette).setTone(s -> {
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 60.0 : 49.0;
            }
            if (!this.isFidelity((DynamicScheme)s)) {
                return s.isDark ? 30.0 : 90.0;
            }
            Hct proposedHct = s.tertiaryPalette.getHct(s.sourceColorHct.getTone());
            return DislikeAnalyzer.fixIfDisliked(proposedHct).getTone();
        }).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.0, 1.0, 3.0, 4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.tertiaryContainer(), this.tertiary(), 10.0, TonePolarity.NEARER, false)).build();
    }

    @Override
    @NonNull
    public DynamicColor onTertiaryContainer() {
        return new DynamicColor.Builder().setName("on_tertiary_container").setPalette(s -> s.tertiaryPalette).setTone(s -> {
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 0.0 : 100.0;
            }
            if (!this.isFidelity((DynamicScheme)s)) {
                return s.isDark ? 90.0 : 30.0;
            }
            return DynamicColor.foregroundTone(this.tertiaryContainer().tone.apply((DynamicScheme)s), 4.5);
        }).setBackground(s -> this.tertiaryContainer()).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 11.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor error() {
        return new DynamicColor.Builder().setName("error").setPalette(s -> s.errorPalette).setTone(s -> s.isDark ? 80.0 : 40.0).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 7.0)).setToneDeltaPair(s -> new ToneDeltaPair(this.errorContainer(), this.error(), 10.0, TonePolarity.NEARER, false)).build();
    }

    @Override
    @Nullable
    public DynamicColor errorDim() {
        return null;
    }

    @Override
    @NonNull
    public DynamicColor onError() {
        return new DynamicColor.Builder().setName("on_error").setPalette(s -> s.errorPalette).setTone(s -> s.isDark ? 20.0 : 100.0).setBackground(s -> this.error()).setContrastCurve(s -> new ContrastCurve(4.5, 7.0, 11.0, 21.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor errorContainer() {
        return new DynamicColor.Builder().setName("error_container").setPalette(s -> s.errorPalette).setTone(s -> s.isDark ? 30.0 : 90.0).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.0, 1.0, 3.0, 4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.errorContainer(), this.error(), 10.0, TonePolarity.NEARER, false)).build();
    }

    @Override
    @NonNull
    public DynamicColor onErrorContainer() {
        return new DynamicColor.Builder().setName("on_error_container").setPalette(s -> s.errorPalette).setTone(s -> {
            if (ColorSpec2021.isMonochrome(s)) {
                return s.isDark ? 90.0 : 10.0;
            }
            return s.isDark ? 90.0 : 30.0;
        }).setBackground(s -> this.errorContainer()).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 11.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor primaryFixed() {
        return new DynamicColor.Builder().setName("primary_fixed").setPalette(s -> s.primaryPalette).setTone(s -> ColorSpec2021.isMonochrome(s) ? 40.0 : 90.0).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.0, 1.0, 3.0, 4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.primaryFixed(), this.primaryFixedDim(), 10.0, TonePolarity.LIGHTER, true)).build();
    }

    @Override
    @NonNull
    public DynamicColor primaryFixedDim() {
        return new DynamicColor.Builder().setName("primary_fixed_dim").setPalette(s -> s.primaryPalette).setTone(s -> ColorSpec2021.isMonochrome(s) ? 30.0 : 80.0).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.0, 1.0, 3.0, 4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.primaryFixed(), this.primaryFixedDim(), 10.0, TonePolarity.LIGHTER, true)).build();
    }

    @Override
    @NonNull
    public DynamicColor onPrimaryFixed() {
        return new DynamicColor.Builder().setName("on_primary_fixed").setPalette(s -> s.primaryPalette).setTone(s -> ColorSpec2021.isMonochrome(s) ? 100.0 : 10.0).setBackground(s -> this.primaryFixedDim()).setSecondBackground(s -> this.primaryFixed()).setContrastCurve(s -> new ContrastCurve(4.5, 7.0, 11.0, 21.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor onPrimaryFixedVariant() {
        return new DynamicColor.Builder().setName("on_primary_fixed_variant").setPalette(s -> s.primaryPalette).setTone(s -> ColorSpec2021.isMonochrome(s) ? 90.0 : 30.0).setBackground(s -> this.primaryFixedDim()).setSecondBackground(s -> this.primaryFixed()).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 11.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor secondaryFixed() {
        return new DynamicColor.Builder().setName("secondary_fixed").setPalette(s -> s.secondaryPalette).setTone(s -> ColorSpec2021.isMonochrome(s) ? 80.0 : 90.0).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.0, 1.0, 3.0, 4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.secondaryFixed(), this.secondaryFixedDim(), 10.0, TonePolarity.LIGHTER, true)).build();
    }

    @Override
    @NonNull
    public DynamicColor secondaryFixedDim() {
        return new DynamicColor.Builder().setName("secondary_fixed_dim").setPalette(s -> s.secondaryPalette).setTone(s -> ColorSpec2021.isMonochrome(s) ? 70.0 : 80.0).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.0, 1.0, 3.0, 4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.secondaryFixed(), this.secondaryFixedDim(), 10.0, TonePolarity.LIGHTER, true)).build();
    }

    @Override
    @NonNull
    public DynamicColor onSecondaryFixed() {
        return new DynamicColor.Builder().setName("on_secondary_fixed").setPalette(s -> s.secondaryPalette).setTone(s -> 10.0).setBackground(s -> this.secondaryFixedDim()).setSecondBackground(s -> this.secondaryFixed()).setContrastCurve(s -> new ContrastCurve(4.5, 7.0, 11.0, 21.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor onSecondaryFixedVariant() {
        return new DynamicColor.Builder().setName("on_secondary_fixed_variant").setPalette(s -> s.secondaryPalette).setTone(s -> ColorSpec2021.isMonochrome(s) ? 25.0 : 30.0).setBackground(s -> this.secondaryFixedDim()).setSecondBackground(s -> this.secondaryFixed()).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 11.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor tertiaryFixed() {
        return new DynamicColor.Builder().setName("tertiary_fixed").setPalette(s -> s.tertiaryPalette).setTone(s -> ColorSpec2021.isMonochrome(s) ? 40.0 : 90.0).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.0, 1.0, 3.0, 4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.tertiaryFixed(), this.tertiaryFixedDim(), 10.0, TonePolarity.LIGHTER, true)).build();
    }

    @Override
    @NonNull
    public DynamicColor tertiaryFixedDim() {
        return new DynamicColor.Builder().setName("tertiary_fixed_dim").setPalette(s -> s.tertiaryPalette).setTone(s -> ColorSpec2021.isMonochrome(s) ? 30.0 : 80.0).setIsBackground(true).setBackground(this::highestSurface).setContrastCurve(s -> new ContrastCurve(1.0, 1.0, 3.0, 4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.tertiaryFixed(), this.tertiaryFixedDim(), 10.0, TonePolarity.LIGHTER, true)).build();
    }

    @Override
    @NonNull
    public DynamicColor onTertiaryFixed() {
        return new DynamicColor.Builder().setName("on_tertiary_fixed").setPalette(s -> s.tertiaryPalette).setTone(s -> ColorSpec2021.isMonochrome(s) ? 100.0 : 10.0).setBackground(s -> this.tertiaryFixedDim()).setSecondBackground(s -> this.tertiaryFixed()).setContrastCurve(s -> new ContrastCurve(4.5, 7.0, 11.0, 21.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor onTertiaryFixedVariant() {
        return new DynamicColor.Builder().setName("on_tertiary_fixed_variant").setPalette(s -> s.tertiaryPalette).setTone(s -> ColorSpec2021.isMonochrome(s) ? 90.0 : 30.0).setBackground(s -> this.tertiaryFixedDim()).setSecondBackground(s -> this.tertiaryFixed()).setContrastCurve(s -> new ContrastCurve(3.0, 4.5, 7.0, 11.0)).build();
    }

    @Override
    @NonNull
    public DynamicColor controlActivated() {
        return new DynamicColor.Builder().setName("control_activated").setPalette(s -> s.primaryPalette).setTone(s -> s.isDark ? 30.0 : 90.0).setIsBackground(true).build();
    }

    @Override
    @NonNull
    public DynamicColor controlNormal() {
        return new DynamicColor.Builder().setName("control_normal").setPalette(s -> s.neutralVariantPalette).setTone(s -> s.isDark ? 80.0 : 30.0).build();
    }

    @Override
    @NonNull
    public DynamicColor controlHighlight() {
        return new DynamicColor.Builder().setName("control_highlight").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 100.0 : 0.0).setOpacity(s -> s.isDark ? 0.2 : 0.12).build();
    }

    @Override
    @NonNull
    public DynamicColor textPrimaryInverse() {
        return new DynamicColor.Builder().setName("text_primary_inverse").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 10.0 : 90.0).build();
    }

    @Override
    @NonNull
    public DynamicColor textSecondaryAndTertiaryInverse() {
        return new DynamicColor.Builder().setName("text_secondary_and_tertiary_inverse").setPalette(s -> s.neutralVariantPalette).setTone(s -> s.isDark ? 30.0 : 80.0).build();
    }

    @Override
    @NonNull
    public DynamicColor textPrimaryInverseDisableOnly() {
        return new DynamicColor.Builder().setName("text_primary_inverse_disable_only").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 10.0 : 90.0).build();
    }

    @Override
    @NonNull
    public DynamicColor textSecondaryAndTertiaryInverseDisabled() {
        return new DynamicColor.Builder().setName("text_secondary_and_tertiary_inverse_disabled").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 10.0 : 90.0).build();
    }

    @Override
    @NonNull
    public DynamicColor textHintInverse() {
        return new DynamicColor.Builder().setName("text_hint_inverse").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 10.0 : 90.0).build();
    }

    @Override
    @NonNull
    public DynamicColor highestSurface(@NonNull DynamicScheme s) {
        return s.isDark ? this.surfaceBright() : this.surfaceDim();
    }

    private boolean isFidelity(DynamicScheme scheme) {
        return scheme.variant == Variant.FIDELITY || scheme.variant == Variant.CONTENT;
    }

    private static boolean isMonochrome(DynamicScheme scheme) {
        return scheme.variant == Variant.MONOCHROME;
    }

    private static double findDesiredChromaByTone(double hue, double chroma, double tone, boolean byDecreasingTone) {
        double answer = tone;
        Hct closestToChroma = Hct.from(hue, chroma, tone);
        if (closestToChroma.getChroma() < chroma) {
            Hct potentialSolution;
            double chromaPeak = closestToChroma.getChroma();
            while (closestToChroma.getChroma() < chroma && !(chromaPeak > (potentialSolution = Hct.from(hue, chroma, answer += byDecreasingTone ? -1.0 : 1.0)).getChroma()) && !(Math.abs(potentialSolution.getChroma() - chroma) < 0.4)) {
                double currentDelta;
                double potentialDelta = Math.abs(potentialSolution.getChroma() - chroma);
                if (potentialDelta < (currentDelta = Math.abs(closestToChroma.getChroma() - chroma))) {
                    closestToChroma = potentialSolution;
                }
                chromaPeak = Math.max(chromaPeak, potentialSolution.getChroma());
            }
        }
        return answer;
    }

    @Override
    @NonNull
    public Hct getHct(DynamicScheme scheme, DynamicColor color2) {
        double tone = this.getTone(scheme, color2);
        return color2.palette.apply(scheme).getHct(tone);
    }

    @Override
    public double getTone(DynamicScheme scheme, DynamicColor color2) {
        boolean prefersLight;
        ToneDeltaPair toneDeltaPair;
        boolean decreasingContrast = scheme.contrastLevel < 0.0;
        ToneDeltaPair toneDeltaPair2 = toneDeltaPair = color2.toneDeltaPair == null ? null : color2.toneDeltaPair.apply(scheme);
        if (toneDeltaPair != null) {
            DynamicColor roleA = toneDeltaPair.getRoleA();
            DynamicColor roleB = toneDeltaPair.getRoleB();
            double delta = toneDeltaPair.getDelta();
            TonePolarity polarity = toneDeltaPair.getPolarity();
            boolean stayTogether = toneDeltaPair.getStayTogether();
            boolean aIsNearer = polarity == TonePolarity.NEARER || polarity == TonePolarity.LIGHTER && !scheme.isDark || polarity == TonePolarity.DARKER && !scheme.isDark;
            DynamicColor nearer = aIsNearer ? roleA : roleB;
            DynamicColor farther = aIsNearer ? roleB : roleA;
            boolean amNearer = color2.name.equals(nearer.name);
            double expansionDir = scheme.isDark ? 1.0 : -1.0;
            double nTone = nearer.tone.apply(scheme);
            double fTone = farther.tone.apply(scheme);
            if (color2.background != null && nearer.contrastCurve != null && farther.contrastCurve != null) {
                DynamicColor bg = color2.background.apply(scheme);
                ContrastCurve nContrastCurve = nearer.contrastCurve.apply(scheme);
                ContrastCurve fContrastCurve = farther.contrastCurve.apply(scheme);
                if (bg != null && nContrastCurve != null && fContrastCurve != null) {
                    double nContrast = nContrastCurve.get(scheme.contrastLevel);
                    double fContrast = fContrastCurve.get(scheme.contrastLevel);
                    double bgTone = bg.getTone(scheme);
                    if (Contrast.ratioOfTones(bgTone, nTone) < nContrast) {
                        nTone = DynamicColor.foregroundTone(bgTone, nContrast);
                    }
                    if (Contrast.ratioOfTones(bgTone, fTone) < fContrast) {
                        fTone = DynamicColor.foregroundTone(bgTone, fContrast);
                    }
                    if (decreasingContrast) {
                        nTone = DynamicColor.foregroundTone(bgTone, nContrast);
                        fTone = DynamicColor.foregroundTone(bgTone, fContrast);
                    }
                }
            }
            if ((fTone - nTone) * expansionDir < delta && ((fTone = MathUtils.clampDouble(0.0, 100.0, nTone + delta * expansionDir)) - nTone) * expansionDir < delta) {
                nTone = MathUtils.clampDouble(0.0, 100.0, fTone - delta * expansionDir);
            }
            if (50.0 <= nTone && nTone < 60.0) {
                if (expansionDir > 0.0) {
                    nTone = 60.0;
                    fTone = Math.max(fTone, nTone + delta * expansionDir);
                } else {
                    nTone = 49.0;
                    fTone = Math.min(fTone, nTone + delta * expansionDir);
                }
            } else if (50.0 <= fTone && fTone < 60.0) {
                if (stayTogether) {
                    if (expansionDir > 0.0) {
                        nTone = 60.0;
                        fTone = Math.max(fTone, nTone + delta * expansionDir);
                    } else {
                        nTone = 49.0;
                        fTone = Math.min(fTone, nTone + delta * expansionDir);
                    }
                } else {
                    fTone = expansionDir > 0.0 ? 60.0 : 49.0;
                }
            }
            return amNearer ? nTone : fTone;
        }
        double answer = color2.tone.apply(scheme);
        if (color2.background == null || color2.background.apply(scheme) == null || color2.contrastCurve == null || color2.contrastCurve.apply(scheme) == null) {
            return answer;
        }
        double bgTone = color2.background.apply(scheme).getTone(scheme);
        double desiredRatio = color2.contrastCurve.apply(scheme).get(scheme.contrastLevel);
        if (!(Contrast.ratioOfTones(bgTone, answer) >= desiredRatio)) {
            answer = DynamicColor.foregroundTone(bgTone, desiredRatio);
        }
        if (decreasingContrast) {
            answer = DynamicColor.foregroundTone(bgTone, desiredRatio);
        }
        if (color2.isBackground && 50.0 <= answer && answer < 60.0) {
            answer = Contrast.ratioOfTones(49.0, bgTone) >= desiredRatio ? 49.0 : 60.0;
        }
        if (color2.secondBackground == null || color2.secondBackground.apply(scheme) == null) {
            return answer;
        }
        double bgTone1 = color2.background.apply(scheme).getTone(scheme);
        double bgTone2 = color2.secondBackground.apply(scheme).getTone(scheme);
        double upper = Math.max(bgTone1, bgTone2);
        double lower = Math.min(bgTone1, bgTone2);
        if (Contrast.ratioOfTones(upper, answer) >= desiredRatio && Contrast.ratioOfTones(lower, answer) >= desiredRatio) {
            return answer;
        }
        double lightOption = Contrast.lighter(upper, desiredRatio);
        double darkOption = Contrast.darker(lower, desiredRatio);
        ArrayList<Double> availables = new ArrayList<Double>();
        if (lightOption != -1.0) {
            availables.add(lightOption);
        }
        if (darkOption != -1.0) {
            availables.add(darkOption);
        }
        boolean bl = prefersLight = DynamicColor.tonePrefersLightForeground(bgTone1) || DynamicColor.tonePrefersLightForeground(bgTone2);
        if (prefersLight) {
            return lightOption == -1.0 ? 100.0 : lightOption;
        }
        if (availables.size() == 1) {
            return (Double)availables.get(0);
        }
        return darkOption == -1.0 ? 0.0 : darkOption;
    }

    @Override
    @NonNull
    public TonalPalette getPrimaryPalette(Variant variant, Hct sourceColorHct, boolean isDark, DynamicScheme.Platform platform, double contrastLevel) {
        TonalPalette tonalPalette;
        switch (variant) {
            default: {
                throw new MatchException(null, null);
            }
            case CONTENT: 
            case FIDELITY: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), sourceColorHct.getChroma());
                break;
            }
            case FRUIT_SALAD: {
                tonalPalette = TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() - 50.0), 48.0);
                break;
            }
            case MONOCHROME: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
                break;
            }
            case NEUTRAL: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 12.0);
                break;
            }
            case RAINBOW: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 48.0);
                break;
            }
            case TONAL_SPOT: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 36.0);
                break;
            }
            case EXPRESSIVE: {
                tonalPalette = TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() + 240.0), 40.0);
                break;
            }
            case VIBRANT: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 200.0);
            }
        }
        return tonalPalette;
    }

    @Override
    @NonNull
    public TonalPalette getSecondaryPalette(Variant variant, Hct sourceColorHct, boolean isDark, DynamicScheme.Platform platform, double contrastLevel) {
        TonalPalette tonalPalette;
        switch (variant) {
            default: {
                throw new MatchException(null, null);
            }
            case CONTENT: 
            case FIDELITY: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), Math.max(sourceColorHct.getChroma() - 32.0, sourceColorHct.getChroma() * 0.5));
                break;
            }
            case FRUIT_SALAD: {
                tonalPalette = TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() - 50.0), 36.0);
                break;
            }
            case MONOCHROME: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
                break;
            }
            case NEUTRAL: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 8.0);
                break;
            }
            case RAINBOW: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 16.0);
                break;
            }
            case TONAL_SPOT: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 16.0);
                break;
            }
            case EXPRESSIVE: {
                tonalPalette = TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 21.0, 51.0, 121.0, 151.0, 191.0, 271.0, 321.0, 360.0}, new double[]{45.0, 95.0, 45.0, 20.0, 45.0, 90.0, 45.0, 45.0, 45.0}), 24.0);
                break;
            }
            case VIBRANT: {
                tonalPalette = TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 41.0, 61.0, 101.0, 131.0, 181.0, 251.0, 301.0, 360.0}, new double[]{18.0, 15.0, 10.0, 12.0, 15.0, 18.0, 15.0, 12.0, 12.0}), 24.0);
            }
        }
        return tonalPalette;
    }

    @Override
    @NonNull
    public TonalPalette getTertiaryPalette(Variant variant, Hct sourceColorHct, boolean isDark, DynamicScheme.Platform platform, double contrastLevel) {
        TonalPalette tonalPalette;
        switch (variant) {
            default: {
                throw new MatchException(null, null);
            }
            case CONTENT: {
                tonalPalette = TonalPalette.fromHct(DislikeAnalyzer.fixIfDisliked(new TemperatureCache(sourceColorHct).getAnalogousColors(3, 6).get(2)));
                break;
            }
            case FIDELITY: {
                tonalPalette = TonalPalette.fromHct(DislikeAnalyzer.fixIfDisliked(new TemperatureCache(sourceColorHct).getComplement()));
                break;
            }
            case FRUIT_SALAD: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 36.0);
                break;
            }
            case MONOCHROME: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
                break;
            }
            case NEUTRAL: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 16.0);
                break;
            }
            case RAINBOW: 
            case TONAL_SPOT: {
                tonalPalette = TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() + 60.0), 24.0);
                break;
            }
            case EXPRESSIVE: {
                tonalPalette = TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 21.0, 51.0, 121.0, 151.0, 191.0, 271.0, 321.0, 360.0}, new double[]{120.0, 120.0, 20.0, 45.0, 20.0, 15.0, 20.0, 120.0, 120.0}), 32.0);
                break;
            }
            case VIBRANT: {
                tonalPalette = TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 41.0, 61.0, 101.0, 131.0, 181.0, 251.0, 301.0, 360.0}, new double[]{35.0, 30.0, 20.0, 25.0, 30.0, 35.0, 30.0, 25.0, 25.0}), 32.0);
            }
        }
        return tonalPalette;
    }

    @Override
    @NonNull
    public TonalPalette getNeutralPalette(Variant variant, Hct sourceColorHct, boolean isDark, DynamicScheme.Platform platform, double contrastLevel) {
        TonalPalette tonalPalette;
        switch (variant) {
            default: {
                throw new MatchException(null, null);
            }
            case CONTENT: 
            case FIDELITY: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), sourceColorHct.getChroma() / 8.0);
                break;
            }
            case FRUIT_SALAD: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 10.0);
                break;
            }
            case MONOCHROME: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
                break;
            }
            case NEUTRAL: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 2.0);
                break;
            }
            case RAINBOW: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
                break;
            }
            case TONAL_SPOT: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 6.0);
                break;
            }
            case EXPRESSIVE: {
                tonalPalette = TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() + 15.0), 8.0);
                break;
            }
            case VIBRANT: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 10.0);
            }
        }
        return tonalPalette;
    }

    @Override
    @NonNull
    public TonalPalette getNeutralVariantPalette(Variant variant, Hct sourceColorHct, boolean isDark, DynamicScheme.Platform platform, double contrastLevel) {
        TonalPalette tonalPalette;
        switch (variant) {
            default: {
                throw new MatchException(null, null);
            }
            case CONTENT: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), sourceColorHct.getChroma() / 8.0 + 4.0);
                break;
            }
            case FIDELITY: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), sourceColorHct.getChroma() / 8.0 + 4.0);
                break;
            }
            case FRUIT_SALAD: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 16.0);
                break;
            }
            case MONOCHROME: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
                break;
            }
            case NEUTRAL: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 2.0);
                break;
            }
            case RAINBOW: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 0.0);
                break;
            }
            case TONAL_SPOT: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 8.0);
                break;
            }
            case EXPRESSIVE: {
                tonalPalette = TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() + 15.0), 12.0);
                break;
            }
            case VIBRANT: {
                tonalPalette = TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 12.0);
            }
        }
        return tonalPalette;
    }

    @Override
    @NonNull
    public Optional<TonalPalette> getErrorPalette(Variant variant, Hct sourceColorHct, boolean isDark, DynamicScheme.Platform platform, double contrastLevel) {
        switch (variant) {
            default: {
                throw new MatchException(null, null);
            }
            case CONTENT: 
            case FIDELITY: 
            case FRUIT_SALAD: 
            case MONOCHROME: 
            case NEUTRAL: 
            case RAINBOW: 
            case TONAL_SPOT: 
            case EXPRESSIVE: 
            case VIBRANT: 
        }
        return Optional.empty();
    }
}

