/*
 * Decompiled with CFR 0.152.
 */
package com.google.ux.material.libmonet.hct;

import com.google.ux.material.libmonet.hct.ViewingConditions;
import com.google.ux.material.libmonet.utils.ColorUtils;

public class Cam16 {
    static final double[][] XYZ_TO_CAM16RGB = new double[][]{{0.401288, 0.650173, -0.051461}, {-0.250268, 1.204414, 0.045854}, {-0.002079, 0.048952, 0.953127}};
    static final double[][] CAM16RGB_TO_XYZ = new double[][]{{1.8620678, -1.0112547, 0.14918678}, {0.38752654, 0.62144744, -0.00897398}, {-0.0158415, -0.03412294, 1.0499644}};
    private final double hue;
    private final double chroma;
    private final double j;
    private final double q;
    private final double m;
    private final double s;
    private final double jstar;
    private final double astar;
    private final double bstar;
    private final double[] tempArray = new double[]{0.0, 0.0, 0.0};

    public double distance(Cam16 other) {
        double dJ = this.getJstar() - other.getJstar();
        double dA = this.getAstar() - other.getAstar();
        double dB = this.getBstar() - other.getBstar();
        double dEPrime = Math.sqrt(dJ * dJ + dA * dA + dB * dB);
        double dE = 1.41 * Math.pow(dEPrime, 0.63);
        return dE;
    }

    public double getHue() {
        return this.hue;
    }

    public double getChroma() {
        return this.chroma;
    }

    public double getJ() {
        return this.j;
    }

    public double getQ() {
        return this.q;
    }

    public double getM() {
        return this.m;
    }

    public double getS() {
        return this.s;
    }

    public double getJstar() {
        return this.jstar;
    }

    public double getAstar() {
        return this.astar;
    }

    public double getBstar() {
        return this.bstar;
    }

    private Cam16(double hue, double chroma, double j, double q, double m, double s, double jstar, double astar, double bstar) {
        this.hue = hue;
        this.chroma = chroma;
        this.j = j;
        this.q = q;
        this.m = m;
        this.s = s;
        this.jstar = jstar;
        this.astar = astar;
        this.bstar = bstar;
    }

    public static Cam16 fromInt(int argb) {
        return Cam16.fromIntInViewingConditions(argb, ViewingConditions.DEFAULT);
    }

    static Cam16 fromIntInViewingConditions(int argb, ViewingConditions viewingConditions) {
        int red = (argb & 0xFF0000) >> 16;
        int green = (argb & 0xFF00) >> 8;
        int blue = argb & 0xFF;
        double redL = ColorUtils.linearized(red);
        double greenL = ColorUtils.linearized(green);
        double blueL = ColorUtils.linearized(blue);
        double x = 0.41233895 * redL + 0.35762064 * greenL + 0.18051042 * blueL;
        double y = 0.2126 * redL + 0.7152 * greenL + 0.0722 * blueL;
        double z = 0.01932141 * redL + 0.11916382 * greenL + 0.95034478 * blueL;
        return Cam16.fromXyzInViewingConditions(x, y, z, viewingConditions);
    }

    static Cam16 fromXyzInViewingConditions(double x, double y, double z, ViewingConditions viewingConditions) {
        double[][] matrix = XYZ_TO_CAM16RGB;
        double rT = x * matrix[0][0] + y * matrix[0][1] + z * matrix[0][2];
        double gT = x * matrix[1][0] + y * matrix[1][1] + z * matrix[1][2];
        double bT = x * matrix[2][0] + y * matrix[2][1] + z * matrix[2][2];
        double rD = viewingConditions.getRgbD()[0] * rT;
        double gD = viewingConditions.getRgbD()[1] * gT;
        double bD = viewingConditions.getRgbD()[2] * bT;
        double rAF = Math.pow(viewingConditions.getFl() * Math.abs(rD) / 100.0, 0.42);
        double gAF = Math.pow(viewingConditions.getFl() * Math.abs(gD) / 100.0, 0.42);
        double bAF = Math.pow(viewingConditions.getFl() * Math.abs(bD) / 100.0, 0.42);
        double rA = Math.signum(rD) * 400.0 * rAF / (rAF + 27.13);
        double gA = Math.signum(gD) * 400.0 * gAF / (gAF + 27.13);
        double bA = Math.signum(bD) * 400.0 * bAF / (bAF + 27.13);
        double a = (11.0 * rA + -12.0 * gA + bA) / 11.0;
        double b = (rA + gA - 2.0 * bA) / 9.0;
        double u = (20.0 * rA + 20.0 * gA + 21.0 * bA) / 20.0;
        double p2 = (40.0 * rA + 20.0 * gA + bA) / 20.0;
        double atan2 = Math.atan2(b, a);
        double atanDegrees = Math.toDegrees(atan2);
        double hue = atanDegrees < 0.0 ? atanDegrees + 360.0 : (atanDegrees >= 360.0 ? atanDegrees - 360.0 : atanDegrees);
        double hueRadians = Math.toRadians(hue);
        double ac = p2 * viewingConditions.getNbb();
        double j = 100.0 * Math.pow(ac / viewingConditions.getAw(), viewingConditions.getC() * viewingConditions.getZ());
        double q = 4.0 / viewingConditions.getC() * Math.sqrt(j / 100.0) * (viewingConditions.getAw() + 4.0) * viewingConditions.getFlRoot();
        double huePrime = hue < 20.14 ? hue + 360.0 : hue;
        double eHue = 0.25 * (Math.cos(Math.toRadians(huePrime) + 2.0) + 3.8);
        double p1 = 3846.153846153846 * eHue * viewingConditions.getNc() * viewingConditions.getNcb();
        double t = p1 * Math.hypot(a, b) / (u + 0.305);
        double alpha = Math.pow(1.64 - Math.pow(0.29, viewingConditions.getN()), 0.73) * Math.pow(t, 0.9);
        double c = alpha * Math.sqrt(j / 100.0);
        double m = c * viewingConditions.getFlRoot();
        double s = 50.0 * Math.sqrt(alpha * viewingConditions.getC() / (viewingConditions.getAw() + 4.0));
        double jstar = 1.7000000000000002 * j / (1.0 + 0.007 * j);
        double mstar = 43.859649122807014 * Math.log1p(0.0228 * m);
        double astar = mstar * Math.cos(hueRadians);
        double bstar = mstar * Math.sin(hueRadians);
        return new Cam16(hue, c, j, q, m, s, jstar, astar, bstar);
    }

    static Cam16 fromJch(double j, double c, double h) {
        return Cam16.fromJchInViewingConditions(j, c, h, ViewingConditions.DEFAULT);
    }

    private static Cam16 fromJchInViewingConditions(double j, double c, double h, ViewingConditions viewingConditions) {
        double q = 4.0 / viewingConditions.getC() * Math.sqrt(j / 100.0) * (viewingConditions.getAw() + 4.0) * viewingConditions.getFlRoot();
        double m = c * viewingConditions.getFlRoot();
        double alpha = c / Math.sqrt(j / 100.0);
        double s = 50.0 * Math.sqrt(alpha * viewingConditions.getC() / (viewingConditions.getAw() + 4.0));
        double hueRadians = Math.toRadians(h);
        double jstar = 1.7000000000000002 * j / (1.0 + 0.007 * j);
        double mstar = 43.859649122807014 * Math.log1p(0.0228 * m);
        double astar = mstar * Math.cos(hueRadians);
        double bstar = mstar * Math.sin(hueRadians);
        return new Cam16(h, c, j, q, m, s, jstar, astar, bstar);
    }

    public static Cam16 fromUcs(double jstar, double astar, double bstar) {
        return Cam16.fromUcsInViewingConditions(jstar, astar, bstar, ViewingConditions.DEFAULT);
    }

    public static Cam16 fromUcsInViewingConditions(double jstar, double astar, double bstar, ViewingConditions viewingConditions) {
        double m = Math.hypot(astar, bstar);
        double m2 = Math.expm1(m * 0.0228) / 0.0228;
        double c = m2 / viewingConditions.getFlRoot();
        double h = Math.atan2(bstar, astar) * 57.29577951308232;
        if (h < 0.0) {
            h += 360.0;
        }
        double j = jstar / (1.0 - (jstar - 100.0) * 0.007);
        return Cam16.fromJchInViewingConditions(j, c, h, viewingConditions);
    }

    public int toInt() {
        return this.viewed(ViewingConditions.DEFAULT);
    }

    int viewed(ViewingConditions viewingConditions) {
        double[] xyz = this.xyzInViewingConditions(viewingConditions, this.tempArray);
        return ColorUtils.argbFromXyz(xyz[0], xyz[1], xyz[2]);
    }

    double[] xyzInViewingConditions(ViewingConditions viewingConditions, double[] returnArray) {
        double alpha = this.getChroma() == 0.0 || this.getJ() == 0.0 ? 0.0 : this.getChroma() / Math.sqrt(this.getJ() / 100.0);
        double t = Math.pow(alpha / Math.pow(1.64 - Math.pow(0.29, viewingConditions.getN()), 0.73), 1.1111111111111112);
        double hRad = Math.toRadians(this.getHue());
        double eHue = 0.25 * (Math.cos(hRad + 2.0) + 3.8);
        double ac = viewingConditions.getAw() * Math.pow(this.getJ() / 100.0, 1.0 / viewingConditions.getC() / viewingConditions.getZ());
        double p1 = eHue * 3846.153846153846 * viewingConditions.getNc() * viewingConditions.getNcb();
        double p2 = ac / viewingConditions.getNbb();
        double hSin = Math.sin(hRad);
        double hCos = Math.cos(hRad);
        double gamma = 23.0 * (p2 + 0.305) * t / (23.0 * p1 + 11.0 * t * hCos + 108.0 * t * hSin);
        double a = gamma * hCos;
        double b = gamma * hSin;
        double rA = (460.0 * p2 + 451.0 * a + 288.0 * b) / 1403.0;
        double gA = (460.0 * p2 - 891.0 * a - 261.0 * b) / 1403.0;
        double bA = (460.0 * p2 - 220.0 * a - 6300.0 * b) / 1403.0;
        double rCBase = Math.max(0.0, 27.13 * Math.abs(rA) / (400.0 - Math.abs(rA)));
        double rC = Math.signum(rA) * (100.0 / viewingConditions.getFl()) * Math.pow(rCBase, 2.380952380952381);
        double gCBase = Math.max(0.0, 27.13 * Math.abs(gA) / (400.0 - Math.abs(gA)));
        double gC = Math.signum(gA) * (100.0 / viewingConditions.getFl()) * Math.pow(gCBase, 2.380952380952381);
        double bCBase = Math.max(0.0, 27.13 * Math.abs(bA) / (400.0 - Math.abs(bA)));
        double bC = Math.signum(bA) * (100.0 / viewingConditions.getFl()) * Math.pow(bCBase, 2.380952380952381);
        double rF = rC / viewingConditions.getRgbD()[0];
        double gF = gC / viewingConditions.getRgbD()[1];
        double bF = bC / viewingConditions.getRgbD()[2];
        double[][] matrix = CAM16RGB_TO_XYZ;
        double x = rF * matrix[0][0] + gF * matrix[0][1] + bF * matrix[0][2];
        double y = rF * matrix[1][0] + gF * matrix[1][1] + bF * matrix[1][2];
        double z = rF * matrix[2][0] + gF * matrix[2][1] + bF * matrix[2][2];
        if (returnArray != null) {
            returnArray[0] = x;
            returnArray[1] = y;
            returnArray[2] = z;
            return returnArray;
        }
        return new double[]{x, y, z};
    }
}

