/*
 * Decompiled with CFR 0.152.
 */
package libcore.net;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public abstract class NetworkSecurityPolicy {
    private static volatile NetworkSecurityPolicy instance = new DefaultNetworkSecurityPolicy();

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public NetworkSecurityPolicy() {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static NetworkSecurityPolicy getInstance() {
        return instance;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void setInstance(NetworkSecurityPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("policy == null");
        }
        instance = policy;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public abstract boolean isCleartextTrafficPermitted();

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public abstract boolean isCleartextTrafficPermitted(String var1);

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public abstract boolean isCertificateTransparencyVerificationRequired(String var1);

    public static class DefaultNetworkSecurityPolicy
    extends NetworkSecurityPolicy {
        @Override
        public boolean isCleartextTrafficPermitted() {
            return true;
        }

        @Override
        public boolean isCleartextTrafficPermitted(String hostname) {
            return this.isCleartextTrafficPermitted();
        }

        @Override
        public boolean isCertificateTransparencyVerificationRequired(String hostname) {
            return false;
        }
    }
}

