/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.event;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import com.android.internal.lang.System_Delegate;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import libcore.net.event.NetworkEventListener;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class NetworkEventDispatcher {
    private static final NetworkEventDispatcher instance = new NetworkEventDispatcher();
    private final List<NetworkEventListener> listeners = new CopyOnWriteArrayList<NetworkEventListener>();

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static NetworkEventDispatcher getInstance() {
        return instance;
    }

    @UnsupportedAppUsage
    public void addListener(NetworkEventListener toAdd) {
        if (toAdd == null) {
            throw new NullPointerException("toAdd == null");
        }
        this.listeners.add(toAdd);
    }

    public void removeListener(NetworkEventListener toRemove) {
        for (NetworkEventListener listener : this.listeners) {
            if (listener != toRemove) continue;
            this.listeners.remove(listener);
            return;
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void dispatchNetworkConfigurationChange() {
        for (NetworkEventListener listener : this.listeners) {
            try {
                listener.onNetworkConfigurationChanged();
            }
            catch (RuntimeException e) {
                System_Delegate.log("Exception thrown during network event propagation", e);
            }
        }
    }
}

