/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionRecorder {
    @NotNull
    private final Map<XmlNode.NodeKey, Actions.DecisionTreeRecord> mRecords = new LinkedHashMap<XmlNode.NodeKey, Actions.DecisionTreeRecord>();

    synchronized void recordAddedNodeAction(@NotNull XmlElement xmlElement, boolean exhaustiveSearch) {
        boolean nodeRecorded;
        boolean bl = nodeRecorded = !this.getDecisionTreeRecord(xmlElement).getNodeRecords().isEmpty();
        if (!nodeRecorded) {
            this.recordNodeAction(xmlElement, Actions.ActionType.ADDED);
        } else if (!exhaustiveSearch) {
            return;
        }
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            if (nodeRecorded && this.getAttributeCreationRecord(xmlAttribute) != null) continue;
            this.recordAttributeAction(xmlAttribute, Actions.ActionType.ADDED, xmlElement.getAttributeOperationType(xmlAttribute.getName()));
        }
        for (XmlElement childNode : xmlElement.getMergeableElements()) {
            this.recordAddedNodeAction(childNode, exhaustiveSearch);
        }
    }

    synchronized void recordImpliedNodeAction(@NotNull XmlElement xmlElement, @Nullable String reason) {
        Actions.DecisionTreeRecord nodeDecisionTree = this.getDecisionTreeRecord(xmlElement);
        Actions.NodeRecord record = new Actions.NodeRecord(Actions.ActionType.IMPLIED, new SourceFilePosition(xmlElement.getDocument().getSourceFile(), xmlElement.getDocument().getRootNode().getPosition()), xmlElement.getOriginalId(), reason, xmlElement.getOperationType());
        nodeDecisionTree.addNodeRecord(record);
    }

    synchronized void recordNodeAction(@NotNull XmlElement xmlElement, @NotNull Actions.ActionType actionType) {
        this.recordNodeAction(xmlElement, actionType, xmlElement);
    }

    synchronized void recordNodeAction(@NotNull XmlElement mergedElement, @NotNull Actions.ActionType actionType, @NotNull XmlElement targetElement) {
        Actions.NodeRecord record = new Actions.NodeRecord(actionType, new SourceFilePosition(targetElement.getDocument().getSourceFile(), targetElement.getPosition()), targetElement.getOriginalId(), null, mergedElement.getOperationType());
        this.recordNodeAction(mergedElement, record);
    }

    synchronized void recordNodeAction(@NotNull XmlElement mergedElement, @NotNull Actions.NodeRecord nodeRecord) {
        Actions.DecisionTreeRecord nodeDecisionTree = this.getDecisionTreeRecord(mergedElement);
        nodeDecisionTree.addNodeRecord(nodeRecord);
        this.updateRecordsIfNodeKeyChanged(mergedElement);
    }

    @NotNull
    private synchronized Actions.DecisionTreeRecord getDecisionTreeRecord(@NotNull XmlElement xmlElement) {
        return this.mRecords.computeIfAbsent(xmlElement.getOriginalId(), k -> new Actions.DecisionTreeRecord());
    }

    synchronized void recordAttributeAction(@NotNull XmlAttribute attribute, @NotNull Actions.ActionType actionType, @Nullable AttributeOperationType attributeOperationType) {
        this.recordAttributeAction(attribute, attribute.getPosition(), actionType, attributeOperationType);
    }

    synchronized void recordAttributeAction(@NotNull XmlAttribute attribute, @NotNull SourcePosition attributePosition, @NotNull Actions.ActionType actionType, @Nullable AttributeOperationType attributeOperationType) {
        XmlElement originElement = attribute.getOwnerElement();
        Actions.AttributeRecord attributeRecord = new Actions.AttributeRecord(actionType, new SourceFilePosition(originElement.getDocument().getSourceFile(), attributePosition), attribute.getOriginalId(), null, attributeOperationType);
        this.recordAttributeAction(attribute, attributeRecord);
    }

    synchronized void recordAttributeAction(@NotNull XmlAttribute attribute, @NotNull Actions.AttributeRecord attributeRecord) {
        List<Actions.AttributeRecord> attributeRecords = this.getAttributeRecords(attribute);
        attributeRecords.add(attributeRecord);
    }

    synchronized void recordImplicitRejection(@NotNull XmlAttribute attribute, @NotNull XmlElement implicitAttributeOwner) {
        List<Actions.AttributeRecord> attributeRecords = this.getAttributeRecords(attribute);
        Actions.AttributeRecord attributeRecord = new Actions.AttributeRecord(Actions.ActionType.REJECTED, new SourceFilePosition(implicitAttributeOwner.getDocument().getSourceFile(), implicitAttributeOwner.getPosition()), attribute.getOriginalId(), null, AttributeOperationType.REPLACE);
        attributeRecords.add(attributeRecord);
    }

    private synchronized void updateRecordsIfNodeKeyChanged(@NotNull XmlElement xmlElement) {
        XmlNode.NodeKey originalNodeKey = xmlElement.getOriginalId();
        Preconditions.checkState((boolean)this.mRecords.containsKey(originalNodeKey), (String)"No record for key [%s]", (Object)originalNodeKey);
        this.mRecords.putIfAbsent(xmlElement.getId(), this.mRecords.get(originalNodeKey));
    }

    @Nullable
    synchronized Actions.AttributeRecord getAttributeCreationRecord(@NotNull XmlAttribute attribute) {
        for (Actions.AttributeRecord attributeRecord : this.getAttributeRecords(attribute)) {
            if (attributeRecord.getActionType() != Actions.ActionType.ADDED) continue;
            return attributeRecord;
        }
        return null;
    }

    @NotNull
    private synchronized List<Actions.AttributeRecord> getAttributeRecords(@NotNull XmlAttribute attribute) {
        XmlElement originElement = attribute.getOwnerElement();
        XmlNode.NodeKey storageKey = originElement.getOriginalId();
        @Nullable Actions.DecisionTreeRecord nodeDecisionTree = this.mRecords.get(storageKey);
        Preconditions.checkNotNull((Object)nodeDecisionTree, (String)"No record for key [%s]", (Object)storageKey);
        List attributeRecords = nodeDecisionTree.mAttributeRecords.computeIfAbsent(attribute.getName(), k -> new ArrayList());
        return attributeRecords;
    }

    @NotNull
    synchronized Actions build() {
        return new Actions((Map<XmlNode.NodeKey, Actions.DecisionTreeRecord>)ImmutableMap.copyOf(this.mRecords));
    }
}

