/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.model.AbstractPaginatedTableModel;
import com.android.tools.adtui.stdui.CommonButton;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RowSorter;
import javax.swing.border.Border;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u0001:\u00016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u000e\u00102\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000303H\u0002J\b\u00104\u001a\u00020.H\u0002J\b\u00105\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0016\u001a\u0004\b\u001b\u0010\u0018R\u001c\u0010\u001c\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0016\u001a\u0004\b\u001e\u0010\u0018R\u001c\u0010\u001f\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010\u0016\u001a\u0004\b!\u0010\u0018R\u001c\u0010\"\u001a\u00020#8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010\u0016\u001a\u0004\b%\u0010&R*\u0010'\u001a\u0010\u0012\f\u0012\n )*\u0004\u0018\u00010\u00060\u00060(8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u0016\u001a\u0004\b+\u0010,\u00a8\u00067"}, d2={"Lcom/android/tools/adtui/PaginatedTableView;", "", "tableModel", "Lcom/android/tools/adtui/model/AbstractPaginatedTableModel;", "pageSizeValues", "", "", "<init>", "(Lcom/android/tools/adtui/model/AbstractPaginatedTableModel;[Ljava/lang/Integer;)V", "getTableModel", "()Lcom/android/tools/adtui/model/AbstractPaginatedTableModel;", "table", "Lcom/intellij/ui/table/JBTable;", "getTable", "()Lcom/intellij/ui/table/JBTable;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "firstPageButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "getFirstPageButton$annotations", "()V", "getFirstPageButton", "()Lcom/android/tools/adtui/stdui/CommonButton;", "lastPageButton", "getLastPageButton$annotations", "getLastPageButton", "prevPageButton", "getPrevPageButton$annotations", "getPrevPageButton", "nextPageButton", "getNextPageButton$annotations", "getNextPageButton", "pageInfoLabel", "Ljavax/swing/JLabel;", "getPageInfoLabel$annotations", "getPageInfoLabel", "()Ljavax/swing/JLabel;", "pageSizeComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "kotlin.jvm.PlatformType", "getPageSizeComboBox$annotations", "getPageSizeComboBox", "()Lcom/intellij/openapi/ui/ComboBox;", "updateColumnComparators", "", "sortKeys", "", "Ljavax/swing/RowSorter$SortKey;", "rowSorter", "Ljavax/swing/DefaultRowSorter;", "updateToolbar", "buildToolbar", "Companion", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nPaginatedTableView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaginatedTableView.kt\ncom/android/tools/adtui/PaginatedTableView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1869#2,2:180\n*S KotlinDebug\n*F\n+ 1 PaginatedTableView.kt\ncom/android/tools/adtui/PaginatedTableView\n*L\n93#1:180,2\n*E\n"})
public final class PaginatedTableView {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractPaginatedTableModel tableModel;
    @NotNull
    private final JBTable table;
    @NotNull
    private final JComponent component;
    @NotNull
    private final CommonButton firstPageButton;
    @NotNull
    private final CommonButton lastPageButton;
    @NotNull
    private final CommonButton prevPageButton;
    @NotNull
    private final CommonButton nextPageButton;
    @NotNull
    private final JLabel pageInfoLabel;
    @NotNull
    private final ComboBox<Integer> pageSizeComboBox;
    @NotNull
    private static final Icon FIRST_PAGE_ICON;
    @NotNull
    private static final Icon LAST_PAGE_ICON;
    @NotNull
    private static final Icon PREV_PAGE_ICON;
    @NotNull
    private static final Icon NEXT_PAGE_ICON;

    /*
     * WARNING - void declaration
     */
    public PaginatedTableView(@NotNull AbstractPaginatedTableModel tableModel, @NotNull Integer[] pageSizeValues) {
        void $this$_init__u24lambda_u244;
        void $this$lambda_u242_u24lambda_u241;
        Object $this$_init__u24lambda_u242;
        TableRowSorter<TableModel> tableRowSorter;
        Object object;
        Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
        Intrinsics.checkNotNullParameter((Object)pageSizeValues, (String)"pageSizeValues");
        this.tableModel = tableModel;
        this.firstPageButton = new CommonButton(FIRST_PAGE_ICON);
        this.lastPageButton = new CommonButton(LAST_PAGE_ICON);
        this.prevPageButton = new CommonButton(PREV_PAGE_ICON);
        this.nextPageButton = new CommonButton(NEXT_PAGE_ICON);
        this.pageInfoLabel = new JLabel();
        this.pageSizeComboBox = new ComboBox((Object[])pageSizeValues);
        JBTable jBTable = object = new JBTable((TableModel)this.tableModel);
        PaginatedTableView paginatedTableView = this;
        boolean bl = false;
        TableRowSorter<TableModel> tableRowSorter2 = tableRowSorter = new TableRowSorter<TableModel>(this.tableModel);
        void var8_9 = $this$_init__u24lambda_u242;
        boolean bl2 = false;
        $this$lambda_u242_u24lambda_u241.addRowSorterListener(arg_0 -> PaginatedTableView.lambda$2$lambda$1$lambda$0((JBTable)$this$_init__u24lambda_u242, this, (TableRowSorter)$this$lambda_u242_u24lambda_u241, arg_0));
        var8_9.setRowSorter((RowSorter)tableRowSorter);
        paginatedTableView.table = object;
        this.tableModel.addTableModelListener(arg_0 -> PaginatedTableView._init_$lambda$3(this, arg_0));
        $this$_init__u24lambda_u242 = object = new JPanel(new BorderLayout());
        paginatedTableView = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u244.add((Component)this.buildToolbar(), "North");
        $this$_init__u24lambda_u244.add((Component)new JBScrollPane((Component)this.table), "Center");
        paginatedTableView.component = (JComponent)object;
    }

    public /* synthetic */ PaginatedTableView(AbstractPaginatedTableModel abstractPaginatedTableModel, Integer[] integerArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            integerArray = new Integer[]{};
        }
        this(abstractPaginatedTableModel, integerArray);
    }

    @NotNull
    public final AbstractPaginatedTableModel getTableModel() {
        return this.tableModel;
    }

    @NotNull
    public final JBTable getTable() {
        return this.table;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final CommonButton getFirstPageButton() {
        return this.firstPageButton;
    }

    @VisibleForTesting
    public static /* synthetic */ void getFirstPageButton$annotations() {
    }

    @NotNull
    public final CommonButton getLastPageButton() {
        return this.lastPageButton;
    }

    @VisibleForTesting
    public static /* synthetic */ void getLastPageButton$annotations() {
    }

    @NotNull
    public final CommonButton getPrevPageButton() {
        return this.prevPageButton;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPrevPageButton$annotations() {
    }

    @NotNull
    public final CommonButton getNextPageButton() {
        return this.nextPageButton;
    }

    @VisibleForTesting
    public static /* synthetic */ void getNextPageButton$annotations() {
    }

    @NotNull
    public final JLabel getPageInfoLabel() {
        return this.pageInfoLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPageInfoLabel$annotations() {
    }

    @NotNull
    public final ComboBox<Integer> getPageSizeComboBox() {
        return this.pageSizeComboBox;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPageSizeComboBox$annotations() {
    }

    private final void updateColumnComparators(List<? extends RowSorter.SortKey> sortKeys, DefaultRowSorter<?, ?> rowSorter) {
        Iterable $this$forEach$iv = sortKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RowSorter.SortKey it = (RowSorter.SortKey)element$iv;
            boolean bl = false;
            rowSorter.setComparator(it.getColumn(), (arg_0, arg_1) -> PaginatedTableView.updateColumnComparators$lambda$6$lambda$5(this, it, arg_0, arg_1));
        }
    }

    private final void updateToolbar() {
        int firstRowIndex = this.tableModel.getPageIndex() * this.tableModel.getPageSize() + 1;
        int lastRowIndex = firstRowIndex + this.tableModel.getRowCount() - 1;
        this.pageInfoLabel.setText(firstRowIndex + " - " + lastRowIndex + " of " + this.tableModel.getDataSize());
        this.firstPageButton.setEnabled(!this.tableModel.isOnFirstPage());
        this.lastPageButton.setEnabled(!this.tableModel.isOnLastPage());
        this.prevPageButton.setEnabled(!this.tableModel.isOnFirstPage());
        this.nextPageButton.setEnabled(!this.tableModel.isOnLastPage());
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent buildToolbar() {
        void $this$buildToolbar_u24lambda_u2418_u24lambda_u2417;
        JPanel jPanel;
        JPanel jPanel2;
        ComboBox<Integer> comboBox;
        ComboBox<Integer> $this$buildToolbar_u24lambda_u248 = comboBox = this.firstPageButton;
        boolean bl = false;
        $this$buildToolbar_u24lambda_u248.setDisabledIcon(IconLoader.getDisabledIcon((Icon)FIRST_PAGE_ICON));
        $this$buildToolbar_u24lambda_u248.setToolTipText("Go to first page");
        $this$buildToolbar_u24lambda_u248.addActionListener(arg_0 -> PaginatedTableView.buildToolbar$lambda$8$lambda$7(this, arg_0));
        ComboBox<Integer> $this$buildToolbar_u24lambda_u2410 = comboBox = this.lastPageButton;
        boolean bl2 = false;
        $this$buildToolbar_u24lambda_u2410.setDisabledIcon(IconLoader.getDisabledIcon((Icon)LAST_PAGE_ICON));
        $this$buildToolbar_u24lambda_u2410.setToolTipText("Go to last page");
        $this$buildToolbar_u24lambda_u2410.addActionListener(arg_0 -> PaginatedTableView.buildToolbar$lambda$10$lambda$9(this, arg_0));
        ComboBox<Integer> $this$buildToolbar_u24lambda_u2412 = comboBox = this.prevPageButton;
        boolean bl3 = false;
        $this$buildToolbar_u24lambda_u2412.setDisabledIcon(IconLoader.getDisabledIcon((Icon)PREV_PAGE_ICON));
        $this$buildToolbar_u24lambda_u2412.setToolTipText("Go to previous page");
        $this$buildToolbar_u24lambda_u2412.addActionListener(arg_0 -> PaginatedTableView.buildToolbar$lambda$12$lambda$11(this, arg_0));
        ComboBox<Integer> $this$buildToolbar_u24lambda_u2414 = comboBox = this.nextPageButton;
        boolean bl4 = false;
        $this$buildToolbar_u24lambda_u2414.setDisabledIcon(IconLoader.getDisabledIcon((Icon)NEXT_PAGE_ICON));
        $this$buildToolbar_u24lambda_u2414.setToolTipText("Go to next page");
        $this$buildToolbar_u24lambda_u2414.addActionListener(arg_0 -> PaginatedTableView.buildToolbar$lambda$14$lambda$13(this, arg_0));
        ComboBox<Integer> $this$buildToolbar_u24lambda_u2416 = comboBox = this.pageSizeComboBox;
        boolean bl5 = false;
        $this$buildToolbar_u24lambda_u2416.setVisible($this$buildToolbar_u24lambda_u2416.getItemCount() > 0);
        $this$buildToolbar_u24lambda_u2416.setSelectedItem((Object)this.tableModel.getPageSize());
        $this$buildToolbar_u24lambda_u2416.addActionListener(arg_0 -> PaginatedTableView.buildToolbar$lambda$16$lambda$15(this, $this$buildToolbar_u24lambda_u2416, arg_0));
        JPanel $this$buildToolbar_u24lambda_u2418 = jPanel2 = new JPanel(new BorderLayout());
        boolean bl6 = false;
        $this$buildToolbar_u24lambda_u2418.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        $this$buildToolbar_u24lambda_u2418.add((Component)this.pageInfoLabel, "Before");
        JPanel jPanel3 = jPanel = new JPanel(new FlowLayout(0));
        JPanel jPanel4 = $this$buildToolbar_u24lambda_u2418;
        boolean bl7 = false;
        $this$buildToolbar_u24lambda_u2418_u24lambda_u2417.add(this.firstPageButton);
        $this$buildToolbar_u24lambda_u2418_u24lambda_u2417.add(this.prevPageButton);
        $this$buildToolbar_u24lambda_u2418_u24lambda_u2417.add((Component)this.pageSizeComboBox);
        $this$buildToolbar_u24lambda_u2418_u24lambda_u2417.add(this.nextPageButton);
        $this$buildToolbar_u24lambda_u2418_u24lambda_u2417.add(this.lastPageButton);
        jPanel4.add((Component)jPanel, "After");
        JPanel toolbar = jPanel2;
        this.updateToolbar();
        return toolbar;
    }

    private static final void lambda$2$lambda$1$lambda$0(JBTable $this_apply, PaginatedTableView this$0, TableRowSorter $this_apply$1, RowSorterEvent event) {
        if (event.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
            $this_apply.clearSelection();
            List<RowSorter.SortKey> list = ((RowSorter)event.getSource()).getSortKeys();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSortKeys(...)");
            this$0.updateColumnComparators(list, $this_apply$1);
            AbstractPaginatedTableModel abstractPaginatedTableModel = this$0.tableModel;
            List<RowSorter.SortKey> list2 = ((RowSorter)event.getSource()).getSortKeys();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getSortKeys(...)");
            abstractPaginatedTableModel.sortData(list2);
        }
    }

    private static final void _init_$lambda$3(PaginatedTableView this$0, TableModelEvent it) {
        this$0.updateToolbar();
    }

    private static final int updateColumnComparators$lambda$6$lambda$5(PaginatedTableView this$0, RowSorter.SortKey $it, Object o1, Object o2) {
        int n;
        Class<?> clazz = this$0.tableModel.getColumnClass($it.getColumn());
        if (Intrinsics.areEqual(clazz, Long.TYPE)) {
            Intrinsics.checkNotNull((Object)o1, (String)"null cannot be cast to non-null type kotlin.Long");
            long l = (Long)o1;
            Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type kotlin.Long");
            n = Intrinsics.compare((long)l, (long)((Long)o2));
        } else if (Intrinsics.areEqual(clazz, Integer.class)) {
            Intrinsics.checkNotNull((Object)o1, (String)"null cannot be cast to non-null type kotlin.Int");
            int n2 = (Integer)o1;
            Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type kotlin.Int");
            n = Intrinsics.compare((int)n2, (int)((Integer)o2));
        } else if (Intrinsics.areEqual(clazz, Double.TYPE)) {
            Intrinsics.checkNotNull((Object)o1, (String)"null cannot be cast to non-null type kotlin.Double");
            double d = (Double)o1;
            Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type kotlin.Double");
            n = Double.compare(d, (Double)o2);
        } else if (Intrinsics.areEqual(clazz, Float.TYPE)) {
            Intrinsics.checkNotNull((Object)o1, (String)"null cannot be cast to non-null type kotlin.Float");
            float f = ((Float)o1).floatValue();
            Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type kotlin.Float");
            n = Float.compare(f, ((Float)o2).floatValue());
        } else if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
            Intrinsics.checkNotNull((Object)o1, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean bl = (Boolean)o1;
            Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            n = Boolean.compare(bl, (Boolean)o2);
        } else if (Intrinsics.areEqual(clazz, String.class)) {
            Intrinsics.checkNotNull((Object)o1, (String)"null cannot be cast to non-null type kotlin.String");
            String string = (String)o1;
            Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type kotlin.String");
            n = string.compareTo((String)o2);
        } else {
            n = o1.toString().compareTo(o2.toString());
        }
        return n;
    }

    private static final void buildToolbar$lambda$8$lambda$7(PaginatedTableView this$0, ActionEvent it) {
        this$0.tableModel.goToFirstPage();
    }

    private static final void buildToolbar$lambda$10$lambda$9(PaginatedTableView this$0, ActionEvent it) {
        this$0.tableModel.goToLastPage();
    }

    private static final void buildToolbar$lambda$12$lambda$11(PaginatedTableView this$0, ActionEvent it) {
        this$0.tableModel.goToPrevPage();
    }

    private static final void buildToolbar$lambda$14$lambda$13(PaginatedTableView this$0, ActionEvent it) {
        this$0.tableModel.goToNextPage();
    }

    private static final void buildToolbar$lambda$16$lambda$15(PaginatedTableView this$0, ComboBox $this_apply, ActionEvent it) {
        AbstractPaginatedTableModel abstractPaginatedTableModel = this$0.tableModel;
        Object object = $this_apply.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        abstractPaginatedTableModel.updatePageSize(((Number)object).intValue());
    }

    static {
        Icon icon = StudioIcons.LayoutEditor.Motion.GO_TO_START;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GO_TO_START");
        FIRST_PAGE_ICON = icon;
        Icon icon2 = StudioIcons.LayoutEditor.Motion.GO_TO_END;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"GO_TO_END");
        LAST_PAGE_ICON = icon2;
        Icon icon3 = StudioIcons.LayoutEditor.Motion.PREVIOUS_TICK;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"PREVIOUS_TICK");
        PREV_PAGE_ICON = icon3;
        Icon icon4 = StudioIcons.LayoutEditor.Motion.NEXT_TICK;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"NEXT_TICK");
        NEXT_PAGE_ICON = icon4;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/adtui/PaginatedTableView$Companion;", "", "<init>", "()V", "FIRST_PAGE_ICON", "Ljavax/swing/Icon;", "LAST_PAGE_ICON", "PREV_PAGE_ICON", "NEXT_PAGE_ICON", "intellij.android.adt.ui"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

