/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.device;

import com.android.io.CancellableFileIo;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinLayoutDefinition {
    private static final Splitter TOKEN_SPLITTER = Splitter.on((Pattern)Pattern.compile("\\s+")).omitEmptyStrings().trimResults();
    private static final Splitter QUERY_SPLITTER = Splitter.on((char)'.');
    private final Map<String, String> myProperties;
    private final Map<String, SkinLayoutDefinition> myChildren;

    @Nullable
    public static SkinLayoutDefinition parseFile(@NotNull File file) {
        String contents;
        try {
            contents = CancellableFileIo.readString((Path)file.toPath());
        }
        catch (IOException e) {
            return null;
        }
        return SkinLayoutDefinition.parseString(contents);
    }

    @NotNull
    public static SkinLayoutDefinition parseString(@NotNull String contents) {
        StringBuilder contentsWithoutComments = new StringBuilder();
        for (String line : Splitter.on((char)'\n').split((CharSequence)contents)) {
            if (line.trim().startsWith("#")) continue;
            contentsWithoutComments.append(line);
            contentsWithoutComments.append('\n');
        }
        return SkinLayoutDefinition.loadFromTokens(TOKEN_SPLITTER.split((CharSequence)contentsWithoutComments.toString()).iterator());
    }

    private SkinLayoutDefinition(@NotNull Map<String, String> properties, @NotNull Map<String, SkinLayoutDefinition> children) {
        this.myProperties = properties;
        this.myChildren = children;
    }

    private static SkinLayoutDefinition loadFromTokens(Iterator<String> tokens) {
        String key;
        ImmutableMap.Builder children = ImmutableMap.builder();
        ImmutableMap.Builder properties = ImmutableMap.builder();
        while (tokens.hasNext() && !(key = tokens.next()).equals("}")) {
            String value = tokens.next();
            if (value.equals("{")) {
                children.put((Object)key, (Object)SkinLayoutDefinition.loadFromTokens(tokens));
                continue;
            }
            properties.put((Object)key, (Object)value);
        }
        return new SkinLayoutDefinition((Map<String, String>)properties.build(), (Map<String, SkinLayoutDefinition>)children.build());
    }

    @Nullable
    public String getValue(@NotNull String queryString) {
        int lastDot = queryString.lastIndexOf(46);
        String name = queryString.substring(lastDot + 1);
        SkinLayoutDefinition node = lastDot < 0 ? this : this.getNode(queryString.substring(0, lastDot));
        return node == null ? null : node.myProperties.get(name);
    }

    @Nullable
    public SkinLayoutDefinition getNode(@NotNull String queryString) {
        SkinLayoutDefinition result = null;
        SkinLayoutDefinition node = this;
        for (String name : QUERY_SPLITTER.split((CharSequence)queryString)) {
            if (node == null) {
                return null;
            }
            result = node = node.myChildren.get(name);
        }
        return result;
    }

    @NotNull
    public Map<String, SkinLayoutDefinition> getChildren() {
        return this.myChildren;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.makeString(buf, 1);
        return buf.toString();
    }

    private void makeString(@NotNull StringBuilder buf, int depth) {
        buf.append("{\n");
        for (String key : ContainerUtil.sorted(this.myProperties.keySet())) {
            SkinLayoutDefinition.appendSpace(buf, depth);
            buf.append(key);
            buf.append("    ");
            buf.append(this.myProperties.get(key));
            buf.append("\n");
        }
        for (String key : ContainerUtil.sorted(this.myChildren.keySet())) {
            SkinLayoutDefinition.appendSpace(buf, depth);
            buf.append(key);
            buf.append("    ");
            this.myChildren.get(key).makeString(buf, depth + 1);
        }
        SkinLayoutDefinition.appendSpace(buf, depth - 1);
        buf.append("}\n");
    }

    private static void appendSpace(@NotNull StringBuilder buf, int depth) {
        for (int i = 0; i < depth; ++i) {
            buf.append("  ");
        }
    }
}

