/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.instructions.InstructionsRenderer;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.util.SwingUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstructionsPanel
extends JPanel {
    @Nullable
    private final EaseOutModel myEaseOutModel;
    @Nullable
    private AspectObserver myObserver;
    @Nullable
    private Consumer<InstructionsPanel> myEaseOutCompletionCallback;

    private InstructionsPanel(@NotNull Builder builder) {
        super(new TabularLayout("*,Fit-,*", "45*,Fit-,55*"));
        if (builder.myMode == Mode.FLOATING) {
            this.setOpaque(false);
        }
        this.setBackground(builder.myBackgroundColor);
        this.setForeground(builder.myForegroundColor);
        InstructionsComponent component = new InstructionsComponent(builder);
        this.add((Component)component, new TabularLayout.Constraint(1, 1));
        this.myEaseOutModel = builder.myEaseOutModel;
        this.myEaseOutCompletionCallback = builder.myEaseOutCompletionCallback;
        if (this.myEaseOutModel != null) {
            this.myObserver = new AspectObserver();
            this.myEaseOutModel.addDependency(this.myObserver).onChange(EaseOutModel.Aspect.EASING, this::modelChanged);
        }
    }

    private void modelChanged() {
        if (this.myEaseOutCompletionCallback == null) {
            return;
        }
        assert (this.myEaseOutModel != null);
        if (this.myEaseOutModel.getRatioComplete() >= 1.0f) {
            this.myEaseOutCompletionCallback.accept(this);
            this.myEaseOutCompletionCallback = null;
        }
    }

    @VisibleForTesting
    @NotNull
    public List<RenderInstruction> getRenderInstructionsForComponent(int component) {
        assert (component >= 0 && component < this.getComponentCount());
        InstructionsComponent instructionsComponent = (InstructionsComponent)this.getComponent(component);
        return instructionsComponent.getRenderInstructions();
    }

    @VisibleForTesting
    @NotNull
    public InstructionsRenderer getRenderer() {
        InstructionsRenderer renderer = null;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof InstructionsComponent)) continue;
            renderer = ((InstructionsComponent)c).myRenderer;
            break;
        }
        assert (renderer != null);
        return renderer;
    }

    public static final class Builder {
        private Mode myMode = Mode.FLOATING;
        private static final Color INSTRUCTIONS_BACKGROUND = new JBColor(new Color(-666483130, true), new Color(-655956250, true));
        private static final Color INSTRUCTIONS_FOREGROUND = new JBColor(new Color(0xFFFFFF), new Color(0));
        public static final int DEFAULT_PADDING_PX = JBUI.scale((int)12);
        private int myArcWidth;
        private int myArcHeight;
        private int myHorizontalPadding = DEFAULT_PADDING_PX;
        private int myVerticalPadding = DEFAULT_PADDING_PX;
        @Nullable
        private Color myBackgroundColor = INSTRUCTIONS_BACKGROUND;
        @NotNull
        private Color myForegroundColor = INSTRUCTIONS_FOREGROUND;
        private InstructionsRenderer.HorizontalAlignment myAlignment = InstructionsRenderer.HorizontalAlignment.CENTER;
        @Nullable
        private EaseOutModel myEaseOutModel;
        @Nullable
        private Consumer<InstructionsPanel> myEaseOutCompletionCallback;
        @NotNull
        private final List<RenderInstruction> myInstructions = new ArrayList<RenderInstruction>();
        @Nullable
        private BiFunction<Container, Cursor, Container> myCursorSetter;

        public Builder() {
        }

        public Builder(RenderInstruction ... instructions) {
            this.myInstructions.addAll(Arrays.asList(instructions));
        }

        public Builder addInstruction(@NotNull RenderInstruction instruction) {
            this.myInstructions.add(instruction);
            return this;
        }

        @NotNull
        public Builder setMode(Mode mode) {
            this.myMode = mode;
            return this;
        }

        @NotNull
        public Builder setColors(@NotNull Color foregroundColor, @Nullable Color backgroundColor) {
            this.myForegroundColor = foregroundColor;
            this.myBackgroundColor = backgroundColor;
            return this;
        }

        @NotNull
        public Builder setAlignment(@NotNull InstructionsRenderer.HorizontalAlignment alignment) {
            this.myAlignment = alignment;
            return this;
        }

        @NotNull
        public Builder setPaddings(int horizontalPadding, int verticalPadding) {
            this.myHorizontalPadding = horizontalPadding;
            this.myVerticalPadding = verticalPadding;
            return this;
        }

        @NotNull
        public Builder setBackgroundCornerRadius(int arcWidth, int arcHeight) {
            this.myArcWidth = arcWidth;
            this.myArcHeight = arcHeight;
            return this;
        }

        @NotNull
        public Builder setEaseOut(@NotNull EaseOutModel easeOutModel, @Nullable Consumer<InstructionsPanel> easeOutCompletionCallback) {
            this.myEaseOutModel = easeOutModel;
            this.myEaseOutCompletionCallback = easeOutCompletionCallback;
            return this;
        }

        @NotNull
        public Builder setCursorSetter(@NotNull BiFunction<Container, Cursor, Container> cursorSetter) {
            this.myCursorSetter = cursorSetter;
            return this;
        }

        @NotNull
        public InstructionsPanel build() {
            return new InstructionsPanel(this);
        }
    }

    public static enum Mode {
        FLOATING,
        FILL_PANEL;

    }

    private static class InstructionsComponent
    extends AnimatedComponent {
        private final int myHorizontalPadding;
        private final int myVerticalPadding;
        private final int myArcWidth;
        private final int myArcHeight;
        private float myAlpha;
        @Nullable
        private EaseOutModel myEaseOutModel;
        @NotNull
        private final InstructionsRenderer myRenderer;
        @Nullable
        private final BiFunction<Container, Cursor, Container> myCursorSetter;
        @Nullable
        private Container myCachedCursorContainer = null;
        @Nullable
        private RenderInstruction myFocusInstruction;

        public InstructionsComponent(@NotNull Builder builder) {
            this.setBackground(builder.myMode == Mode.FLOATING ? builder.myBackgroundColor : null);
            this.myEaseOutModel = builder.myEaseOutModel;
            this.myHorizontalPadding = builder.myHorizontalPadding;
            this.myVerticalPadding = builder.myVerticalPadding;
            this.myArcWidth = builder.myArcWidth;
            this.myArcHeight = builder.myArcHeight;
            this.myRenderer = new InstructionsRenderer(builder.myInstructions, builder.myAlignment);
            this.myAlpha = 1.0f;
            this.myCursorSetter = builder.myCursorSetter;
            if (this.myEaseOutModel != null) {
                this.myEaseOutModel.addDependency(this.myAspectObserver).onChange(EaseOutModel.Aspect.EASING, this::modelChanged);
            }
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    RenderInstruction instruction = this.delegateMouseEvent(e);
                    this.setCursor(instruction != null ? instruction.getCursorIcon() : null);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.delegateMouseEvent(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.delegateMouseEvent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.delegateMouseEvent(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (myFocusInstruction != null) {
                        this.handleMouseEvent(myFocusInstruction, e);
                        myFocusInstruction = null;
                        this.setCursor(null);
                    }
                }
            });
        }

        @Override
        public void setCursor(Cursor cursor) {
            if (this.myCachedCursorContainer != null) {
                this.myCachedCursorContainer.setCursor(cursor);
            } else if (this.myCursorSetter != null) {
                this.myCachedCursorContainer = this.myCursorSetter.apply(this, cursor);
            } else {
                super.setCursor(cursor);
            }
        }

        @VisibleForTesting
        @NotNull
        public List<RenderInstruction> getRenderInstructions() {
            return this.myRenderer.getInstructions();
        }

        @Nullable
        private RenderInstruction delegateMouseEvent(@NotNull MouseEvent event) {
            event.translatePoint(-this.myHorizontalPadding, -this.myVerticalPadding);
            Point position = event.getPoint();
            Point cursor = new Point(this.myRenderer.getStartX(0), 0);
            RenderInstruction focusInstruction = null;
            for (RenderInstruction instruction : this.myRenderer.getInstructions()) {
                Rectangle bounds = instruction.getBounds(this.myRenderer, cursor);
                if (bounds.contains(position)) {
                    event.translatePoint(-bounds.x, -bounds.y);
                    focusInstruction = instruction;
                    break;
                }
                instruction.moveCursor(this.myRenderer, cursor);
            }
            if (this.myFocusInstruction != focusInstruction) {
                if (this.myFocusInstruction != null) {
                    this.handleMouseEvent(this.myFocusInstruction, SwingUtil.convertMouseEventID(event, 505));
                }
                this.myFocusInstruction = focusInstruction;
            }
            if (this.myFocusInstruction != null) {
                this.handleMouseEvent(this.myFocusInstruction, event);
            }
            return this.myFocusInstruction;
        }

        private void handleMouseEvent(@NotNull RenderInstruction instruction, @NotNull MouseEvent e) {
            instruction.handleMouseEvent(e);
            this.repaint();
        }

        private void modelChanged() {
            if (this.myAlpha <= 0.0f) {
                return;
            }
            assert (this.myEaseOutModel != null);
            this.myAlpha = 1.0f - this.myEaseOutModel.getRatioComplete();
            this.opaqueRepaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension renderSize = this.myRenderer.getRenderSize();
            return new Dimension(renderSize.width + 2 * this.myHorizontalPadding, renderSize.height + 2 * this.myVerticalPadding);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        protected void draw(Graphics2D g2d, Dimension dim) {
            Color background;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setComposite(AlphaComposite.getInstance(3, this.myAlpha));
            Color color = background = this.isBackgroundSet() ? this.getBackground() : null;
            if (background != null) {
                g2d.setColor(background);
                Dimension size = this.getPreferredSize();
                g2d.fillRoundRect(0, 0, size.width, size.height, this.myArcWidth, this.myArcHeight);
            }
            g2d.translate(this.myHorizontalPadding, this.myVerticalPadding);
            this.myRenderer.draw(this, g2d);
            g2d.translate(-this.myHorizontalPadding, -this.myVerticalPadding);
        }
    }
}

