/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class LineChartModel
extends AspectModel<Aspect>
implements Updatable {
    @NotNull
    private final List<RangedContinuousSeries> mySeries = new ArrayList<RangedContinuousSeries>();
    private boolean myFirstUpdate = true;
    private long myAccumulatedElapsedNs = 0L;
    private final AtomicBoolean myIsUpdating = new AtomicBoolean(false);
    @NotNull
    private final Executor myExecutor;

    public LineChartModel() {
        this(AppExecutorUtil.getAppExecutorService());
    }

    @VisibleForTesting
    public LineChartModel(@NotNull Executor executor) {
        this.myExecutor = executor;
    }

    @Override
    public void update(long elapsedNs) {
        if (this.myIsUpdating.get()) {
            this.myAccumulatedElapsedNs += elapsedNs;
        } else {
            long totalNs = elapsedNs + this.myAccumulatedElapsedNs;
            this.myAccumulatedElapsedNs = 0L;
            this.myIsUpdating.set(true);
            CompletableFuture.runAsync(() -> {
                this.doUpdate(totalNs);
                this.myIsUpdating.set(false);
            }, this.myExecutor);
        }
    }

    private void doUpdate(long elapsedNs) {
        HashMap<Range, Double> maxPerRangeObject = new HashMap<Range, Double>();
        for (RangedContinuousSeries ranged : this.mySeries) {
            Range range = ranged.getYRange();
            double yMax = -1.7976931348623157E308;
            List seriesList = ranged.getSeries();
            if (seriesList.isEmpty()) continue;
            for (SeriesData series : seriesList) {
                double value = ((Long)series.value).longValue();
                if (!(yMax < value)) continue;
                yMax = value;
            }
            Double rangeMax = (Double)maxPerRangeObject.get(range);
            if (rangeMax != null && !(yMax > rangeMax)) continue;
            maxPerRangeObject.put(range, yMax);
        }
        boolean changed = this.myFirstUpdate;
        for (Map.Entry entry2 : maxPerRangeObject.entrySet()) {
            Range range = (Range)entry2.getKey();
            if (!(range.getMax() < (Double)entry2.getValue())) continue;
            double max = this.myFirstUpdate ? (Double)entry2.getValue() : Updater.lerp(range.getMax(), (Double)entry2.getValue(), 0.99f, elapsedNs, (double)((float)((Double)entry2.getValue() * (double)0.001f)));
            range.setMax(max);
            changed = true;
        }
        this.myFirstUpdate = false;
        if (changed) {
            this.changed(Aspect.LINE_CHART);
        }
    }

    public void addAll(@NotNull List<RangedContinuousSeries> series) {
        series.forEach(this::add);
    }

    public void add(@NotNull RangedContinuousSeries series) {
        this.mySeries.add(series);
        series.getXRange().addDependency(this).onChange(Range.Aspect.RANGE, () -> this.changed(Aspect.LINE_CHART));
    }

    public void remove(@NotNull RangedContinuousSeries series) {
        series.getXRange().removeDependencies(this);
        this.mySeries.remove(series);
    }

    @NotNull
    public List<RangedContinuousSeries> getSeries() {
        return this.mySeries;
    }

    public static enum Aspect {
        LINE_CHART;

    }
}

