/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/adtui/model/TimelineZoomHelper;", "", "dataRange", "Lcom/android/tools/adtui/model/Range;", "viewRange", "zoomLeft", "<init>", "(Lcom/android/tools/adtui/model/Range;Lcom/android/tools/adtui/model/Range;Lcom/android/tools/adtui/model/Range;)V", "zoom", "", "amountUs", "", "ratio", "updateZoomLeft", "targetRange", "paddingRatio", "handleZoomView", "elapsedNs", "", "intellij.android.adt.ui.model"})
public final class TimelineZoomHelper {
    @NotNull
    private final Range dataRange;
    @NotNull
    private final Range viewRange;
    @NotNull
    private final Range zoomLeft;

    public TimelineZoomHelper(@NotNull Range dataRange, @NotNull Range viewRange, @NotNull Range zoomLeft) {
        Intrinsics.checkNotNullParameter((Object)dataRange, (String)"dataRange");
        Intrinsics.checkNotNullParameter((Object)viewRange, (String)"viewRange");
        Intrinsics.checkNotNullParameter((Object)zoomLeft, (String)"zoomLeft");
        this.dataRange = dataRange;
        this.viewRange = viewRange;
        this.zoomLeft = zoomLeft;
    }

    public final void zoom(double amountUs, double ratio) {
        boolean isDataRangeFullyCoveredByViewRange;
        double deltaUs = amountUs;
        if (deltaUs == 0.0) {
            return;
        }
        if (deltaUs < 0.0) {
            double zoomMax = -0.9 * this.viewRange.getLength();
            deltaUs = Math.max(zoomMax, deltaUs);
        }
        this.zoomLeft.clear();
        double minUs = this.viewRange.getMin() - deltaUs * ratio;
        double maxUs = this.viewRange.getMax() + deltaUs * (1.0 - ratio);
        boolean bl = isDataRangeFullyCoveredByViewRange = this.dataRange.getMin() <= this.viewRange.getMin();
        if (isDataRangeFullyCoveredByViewRange && minUs < this.dataRange.getMin()) {
            maxUs += this.dataRange.getMin() - minUs;
            minUs = this.dataRange.getMin();
        }
        if (!isDataRangeFullyCoveredByViewRange && minUs < this.dataRange.getMin()) {
            maxUs = this.dataRange.getMax();
        }
        if (maxUs > this.dataRange.getMax()) {
            minUs -= maxUs - this.dataRange.getMax();
            maxUs = this.dataRange.getMax();
        }
        if (isDataRangeFullyCoveredByViewRange) {
            minUs = Math.max(minUs, this.dataRange.getMin());
        }
        this.zoomLeft.set(minUs - this.viewRange.getMin(), maxUs - this.viewRange.getMax());
    }

    public final void updateZoomLeft(@NotNull Range targetRange, double paddingRatio) {
        Intrinsics.checkNotNullParameter((Object)targetRange, (String)"targetRange");
        Range finalRange = new Range(targetRange.getMin() - targetRange.getLength() * paddingRatio, targetRange.getMax() + targetRange.getLength() * paddingRatio);
        if (finalRange.getMax() > this.dataRange.getMax()) {
            finalRange.setMax(this.dataRange.getMax());
        }
        this.zoomLeft.set(finalRange.getMin() - this.viewRange.getMin(), finalRange.getMax() - this.viewRange.getMax());
    }

    public final void handleZoomView(long elapsedNs) {
        if (!(this.zoomLeft.getMin() == 0.0) || !(this.zoomLeft.getMax() == 0.0)) {
            double min = Updater.lerp(0.0, this.zoomLeft.getMin(), 0.99999f, elapsedNs, 10.0);
            double max = Updater.lerp(0.0, this.zoomLeft.getMax(), 0.99999f, elapsedNs, 10.0);
            this.zoomLeft.set(this.zoomLeft.getMin() - min, this.zoomLeft.getMax() - max);
            if (this.viewRange.getMax() + max > this.dataRange.getMax()) {
                max = this.dataRange.getMax() - this.viewRange.getMax();
            }
            this.viewRange.set(this.viewRange.getMin() + min, this.viewRange.getMax() + max);
        }
    }
}

