/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.filter;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterResult;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class FilterHandler {
    private ArrayList<Consumer<FilterResult>> myMatchCountResultListeners = new ArrayList();
    private Filter myFilter = Filter.EMPTY_FILTER;

    public final void setFilter(@NotNull Filter filter) {
        this.myFilter = filter;
        FilterResult result = this.applyFilter(filter);
        if (filter.isEmpty() && result.isFilterEnabled()) {
            result = new FilterResult(result.getMatchCount(), result.getTotalCount(), false);
        }
        FilterResult finalResult = result;
        this.myMatchCountResultListeners.forEach((java.util.function.Consumer<Consumer<FilterResult>>)((java.util.function.Consumer<Consumer>)action -> action.consume((Object)finalResult)));
    }

    public final void addMatchCountResultListener(@NotNull Consumer<FilterResult> listener2) {
        this.myMatchCountResultListeners.add(listener2);
    }

    public final Filter getFilter() {
        return this.myFilter;
    }

    public final void refreshFilterContent() {
        this.setFilter(this.myFilter);
    }

    @NotNull
    protected abstract FilterResult applyFilter(@NotNull Filter var1);
}

