/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.NotNull;

public class EnergyAxisFormatter
extends BaseAxisFormatter {
    public static final String[] LABELS = new String[]{"Light", "Medium", "Heavy"};
    public static final int DEFAULT_MAJOR_INTERVAL = 200;
    public static final EnergyAxisFormatter DEFAULT = new EnergyAxisFormatter(0, LABELS.length, 1);
    public static final EnergyAxisFormatter LEGEND_FORMATTER = new EnergyAxisFormatter(0, LABELS.length, 1){

        @Override
        @NotNull
        public String getFormattedString(double globalRange, double value, boolean includeUnit) {
            if (value < (double)(200 * LABELS.length)) {
                return super.getFormattedString(globalRange, value, includeUnit);
            }
            return LABELS[LABELS.length - 1];
        }
    };

    private EnergyAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold) {
        super(maxMinorTicks, maxMajorTicks, switchThreshold);
    }

    @Override
    @NotNull
    public String getFormattedString(double globalRange, double value, boolean includeUnit) {
        double previousMarkerValue;
        int index = (int)Math.ceil(value / 200.0);
        if (index <= 0) {
            return "None";
        }
        if (index <= LABELS.length) {
            return LABELS[index - 1];
        }
        long majorInterval = this.getMajorInterval(globalRange);
        double d = previousMarkerValue = value % (double)majorInterval != 0.0 ? value - value % (double)majorInterval : value - (double)majorInterval;
        if (previousMarkerValue <= (double)(200 * (LABELS.length - 1))) {
            return LABELS[LABELS.length - 1];
        }
        return "";
    }

    @Override
    public long getMajorInterval(double range) {
        int numTicks = (int)(range / 200.0);
        if (numTicks < 1) {
            return (long)range;
        }
        if (numTicks <= LABELS.length) {
            return 200L;
        }
        int largestMarkerValue = LABELS.length * 200;
        for (numTicks = LABELS.length - 1; numTicks > 1; --numTicks) {
            long interval = largestMarkerValue / numTicks;
            if (!(range < (double)((long)largestMarkerValue + interval))) continue;
            return interval;
        }
        return largestMarkerValue;
    }

    @Override
    protected int getNumUnits() {
        return LABELS.length;
    }

    @Override
    @NotNull
    protected String getUnit(int index) {
        return index < LABELS.length ? LABELS[index] : "";
    }

    @Override
    protected int getUnitBase(int index) {
        return 1;
    }

    @Override
    protected int getUnitMultiplier(int index) {
        return 1;
    }

    @Override
    protected int getUnitMinimalInterval(int index) {
        return 1;
    }

    @Override
    @NotNull
    protected IntList getUnitBaseFactors(int index) {
        return new IntArrayList(0);
    }
}

