/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.adtui.stdui.KeyStrokes;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/adtui/stdui/CommonHyperLinkLabel;", "Lcom/intellij/ui/components/JBLabel;", "showAsLink", "", "strikeout", "<init>", "(ZZ)V", "hyperLinkListeners", "", "Lkotlin/Function0;", "", "getHyperLinkListeners", "()Ljava/util/List;", "normalForegroundColor", "Ljava/awt/Color;", "getNormalForegroundColor", "()Ljava/awt/Color;", "initialized", "updateUI", "paintComponent", "g", "Ljava/awt/Graphics;", "fireHyperLinkActivated", "getSmallFont", "Ljava/awt/Font;", "strikethrough", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nCommonHyperLinkLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonHyperLinkLabel.kt\ncom/android/tools/adtui/stdui/CommonHyperLinkLabel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1869#2,2:104\n*S KotlinDebug\n*F\n+ 1 CommonHyperLinkLabel.kt\ncom/android/tools/adtui/stdui/CommonHyperLinkLabel\n*L\n86#1:104,2\n*E\n"})
public final class CommonHyperLinkLabel
extends JBLabel {
    private final boolean showAsLink;
    private final boolean strikeout;
    @NotNull
    private final List<Function0<Unit>> hyperLinkListeners;
    private boolean initialized;

    public CommonHyperLinkLabel(boolean showAsLink, boolean strikeout) {
        this.showAsLink = showAsLink;
        this.strikeout = strikeout;
        this.hyperLinkListeners = new ArrayList();
        this.initialized = true;
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.setForeground(this.getNormalForegroundColor());
        this.setOpaque(false);
        this.setFocusable(this.showAsLink);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.updateUI();
        KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonHyperLinkLabel._init_$lambda$0(this), KeyStrokes.INSTANCE.getENTER(), "enter", null, 0, 24, null);
        KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonHyperLinkLabel._init_$lambda$1(this), KeyStrokes.INSTANCE.getSPACE(), "space", null, 0, 24, null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.fireHyperLinkActivated();
                event.consume();
            }
        });
    }

    public /* synthetic */ CommonHyperLinkLabel(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    @NotNull
    public final List<Function0<Unit>> getHyperLinkListeners() {
        return this.hyperLinkListeners;
    }

    @NotNull
    public final Color getNormalForegroundColor() {
        Color color;
        if (this.showAsLink) {
            Color color2 = JBUI.CurrentTheme.Link.Foreground.ENABLED;
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"ENABLED");
        } else {
            Color color3 = UIUtil.getLabelForeground();
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getLabelForeground(...)");
        }
        return color;
    }

    public void updateUI() {
        super.updateUI();
        if (this.initialized) {
            this.setFont(this.getSmallFont(this.showAsLink, this.strikeout));
            this.setForeground(this.getNormalForegroundColor());
        }
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.hasFocus() && g instanceof Graphics2D) {
            Insets insets = this.getInsets();
            int textWidth = RangesKt.coerceAtMost((int)(this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + (insets.left + insets.right)), (int)this.getWidth());
            DarculaUIUtil.paintFocusBorder((Graphics2D)((Graphics2D)g), (int)textWidth, (int)this.getHeight(), (float)0.0f, (boolean)true);
        }
    }

    private final void fireHyperLinkActivated() {
        if (this.showAsLink) {
            Iterable $this$forEach$iv = this.hyperLinkListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
        }
    }

    private final Font getSmallFont(boolean showAsLink, boolean strikethrough) {
        Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getLabelFont(...)");
        Font font2 = font;
        Map<TextAttribute, ?> map2 = font2.getAttributes();
        Intrinsics.checkNotNull(map2, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<java.awt.font.TextAttribute, kotlin.Any?>");
        Map attributes = TypeIntrinsics.asMutableMap(map2);
        if (showAsLink) {
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (strikethrough) {
            attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return new Font(attributes);
    }

    private static final Unit _init_$lambda$0(CommonHyperLinkLabel this$0) {
        this$0.fireHyperLinkActivated();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(CommonHyperLinkLabel this$0) {
        this$0.fireHyperLinkActivated();
        return Unit.INSTANCE;
    }

    public CommonHyperLinkLabel() {
        this(false, false, 3, null);
    }
}

