/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.stdui.LookupUI;
import com.android.tools.adtui.stdui.Matcher;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001?B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u00100\u001a\u00020\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u00020\b022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020\u0010H\u0002J\u0018\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020:2\u0006\u00105\u001a\u000206H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u00105\u001a\u000206H\u0016J\u0010\u0010=\u001a\u00020<2\u0006\u00105\u001a\u000206H\u0016J\b\u0010>\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR(\u0010#\u001a\u0004\u0018\u00010\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010(\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\u0018\"\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006@"}, d2={"Lcom/android/tools/adtui/stdui/DefaultLookupUI;", "Lcom/android/tools/adtui/stdui/LookupUI;", "<init>", "()V", "renderer", "Lcom/android/tools/adtui/stdui/DefaultLookupUI$MyLookupCellRenderer;", "list", "Lcom/intellij/ui/components/JBList;", "", "scrollPane", "Ljavax/swing/JScrollPane;", "Lorg/jetbrains/annotations/NotNull;", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "clickAction", "Lkotlin/Function0;", "", "getClickAction", "()Lkotlin/jvm/functions/Function0;", "setClickAction", "(Lkotlin/jvm/functions/Function0;)V", "visible", "", "getVisible", "()Z", "value", "", "visibleRowCount", "getVisibleRowCount", "()I", "setVisibleRowCount", "(I)V", "selectedIndex", "getSelectedIndex", "setSelectedIndex", "selectedValue", "getSelectedValue", "()Ljava/lang/String;", "setSelectedValue", "(Ljava/lang/String;)V", "semiFocused", "getSemiFocused", "setSemiFocused", "(Z)V", "popupSize", "Ljava/awt/Dimension;", "getPopupSize", "()Ljava/awt/Dimension;", "createList", "listModel", "Ljavax/swing/ListModel;", "matcher", "Lcom/android/tools/adtui/stdui/Matcher;", "editor", "Ljavax/swing/JComponent;", "updateElementHeight", "updateLocation", "location", "Ljava/awt/Point;", "screenBounds", "Ljava/awt/Rectangle;", "editorBounds", "hide", "MyLookupCellRenderer", "intellij.android.adt.ui"})
public final class DefaultLookupUI
implements LookupUI {
    @NotNull
    private final MyLookupCellRenderer renderer = new MyLookupCellRenderer();
    @NotNull
    private final JBList<String> list = new JBList();
    @NotNull
    private final JScrollPane scrollPane;
    @Nullable
    private JBPopup popup;
    @NotNull
    private Function0<Unit> clickAction;

    public DefaultLookupUI() {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.list), (int)20, (int)31);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        this.scrollPane = jScrollPane;
        this.clickAction = DefaultLookupUI::clickAction$lambda$0;
    }

    @Override
    @NotNull
    public Function0<Unit> getClickAction() {
        return this.clickAction;
    }

    @Override
    public void setClickAction(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.clickAction = function0;
    }

    @Override
    public boolean getVisible() {
        JBPopup jBPopup = this.popup;
        return jBPopup != null ? jBPopup.isVisible() : false;
    }

    @Override
    public int getVisibleRowCount() {
        return this.list.getVisibleRowCount();
    }

    @Override
    public void setVisibleRowCount(int value) {
        this.updateElementHeight();
        this.list.setVisibleRowCount(value);
    }

    @Override
    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    @Override
    public void setSelectedIndex(int value) {
        this.list.setSelectedIndex(value);
        this.list.ensureIndexIsVisible(value);
    }

    @Override
    @Nullable
    public String getSelectedValue() {
        return (String)this.list.getSelectedValue();
    }

    @Override
    public void setSelectedValue(@Nullable String value) {
        this.list.setSelectedValue((Object)value, true);
    }

    @Override
    public boolean getSemiFocused() {
        return this.renderer.getSemiFocused();
    }

    @Override
    public void setSemiFocused(boolean value) {
        this.renderer.setSemiFocused(value);
    }

    @Override
    @NotNull
    public Dimension getPopupSize() {
        Dimension dimension = this.list.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return dimension;
    }

    @Override
    public void createList(@NotNull ListModel<String> listModel, @NotNull Matcher matcher, @NotNull JComponent editor) {
        Intrinsics.checkNotNullParameter(listModel, (String)"listModel");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.renderer.setMatcher(matcher);
        this.list.setModel(listModel);
        this.list.setFocusable(false);
        this.list.setCellRenderer((ListCellRenderer)this.renderer);
        this.list.setSelectionMode(0);
        this.list.setBackground(UIUtil.getTableBackground());
        this.list.getAccessibleContext().setAccessibleName("Code Completion");
        this.list.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ DefaultLookupUI this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.getClickAction().invoke();
            }
        });
        AccessibleContextUtil.setParent((Component)((Component)this.list), (Component)editor);
    }

    private final void updateElementHeight() {
        int n;
        ListModel model2 = this.list.getModel();
        if (model2.getSize() > 0) {
            JList jList = (JList)this.list;
            Object e = model2.getElementAt(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"getElementAt(...)");
            n = this.renderer.getListCellRendererComponent((JList<? extends String>)jList, (String)((String)e), (int)0, (boolean)false, (boolean)false).getPreferredSize().height;
        } else {
            n = 16;
        }
        this.list.setFixedCellHeight(n);
    }

    @Override
    public void updateLocation(@NotNull Point location, @NotNull JComponent editor) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JBPopup currentPopup = this.popup;
        if (currentPopup == null || currentPopup.isDisposed()) {
            JBPopup jBPopup = this.popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.scrollPane, (JComponent)this.list).createPopup();
            if (jBPopup != null) {
                jBPopup.show(new RelativePoint((Component)editor, location));
            }
        } else {
            currentPopup.setLocation(new RelativePoint((Component)editor, location).getScreenPoint());
            Object object = currentPopup instanceof AbstractPopup ? (AbstractPopup)currentPopup : null;
            if (object != null && (object = object.getPopupWindow()) != null) {
                ((Window)object).setSize(((AbstractPopup)currentPopup).getContent().getPreferredSize());
            }
            currentPopup.setUiVisible(true);
        }
    }

    @Override
    @NotNull
    public Rectangle screenBounds(@NotNull JComponent editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = editor.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return new Rectangle(new Point(0, 0), toolkit.getScreenSize());
        }
        GraphicsConfiguration configuration = graphicsConfiguration;
        Rectangle screenBounds = configuration.getBounds();
        Insets screenInsets = toolkit.getScreenInsets(configuration);
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        Intrinsics.checkNotNull((Object)screenBounds);
        return screenBounds;
    }

    @Override
    @NotNull
    public Rectangle editorBounds(@NotNull JComponent editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Point topLeft = new Point();
        SwingUtilities.convertPointToScreen(topLeft, editor);
        return new Rectangle(topLeft.x, topLeft.y, editor.getWidth(), editor.getHeight());
    }

    @Override
    public void hide() {
        block0: {
            JBPopup jBPopup = this.popup;
            if (jBPopup == null) break block0;
            jBPopup.setUiVisible(false);
        }
    }

    private static final Unit clickAction$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/adtui/stdui/DefaultLookupUI$MyLookupCellRenderer;", "Lcom/intellij/ui/SimpleColoredComponent;", "Ljavax/swing/ListCellRenderer;", "", "<init>", "()V", "foregroundAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "matchedAttributes", "semiFocused", "", "getSemiFocused", "()Z", "setSemiFocused", "(Z)V", "matcher", "Lcom/android/tools/adtui/stdui/Matcher;", "getMatcher", "()Lcom/android/tools/adtui/stdui/Matcher;", "setMatcher", "(Lcom/android/tools/adtui/stdui/Matcher;)V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "unused", "intellij.android.adt.ui"})
    public static final class MyLookupCellRenderer
    extends SimpleColoredComponent
    implements ListCellRenderer<String> {
        @NotNull
        private final SimpleTextAttributes foregroundAttributes = new SimpleTextAttributes(0, UIUtil.getLabelForeground());
        @NotNull
        private final SimpleTextAttributes matchedAttributes = new SimpleTextAttributes(0, LookupCellRenderer.MATCHED_FOREGROUND_COLOR);
        private boolean semiFocused;
        @Nullable
        private Matcher matcher;

        public final boolean getSemiFocused() {
            return this.semiFocused;
        }

        public final void setSemiFocused(boolean bl) {
            this.semiFocused = bl;
        }

        @Nullable
        public final Matcher getMatcher() {
            return this.matcher;
        }

        public final void setMatcher(@Nullable Matcher matcher) {
            this.matcher = matcher;
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends String> list, @NotNull String value, int index, boolean selected, boolean unused) {
            List<TextRange> ranges;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.clear();
            this.setFont(list.getFont());
            this.setBackground(selected && this.semiFocused ? LookupCellRenderer.SELECTED_BACKGROUND_COLOR : (selected ? LookupCellRenderer.SELECTED_NON_FOCUSED_BACKGROUND_COLOR : LookupCellRenderer.BACKGROUND_COLOR));
            Matcher matcher = this.matcher;
            List<Object> list2 = ranges = matcher != null ? matcher.matchingFragments(value) : null;
            if (ranges != null) {
                SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)this, (String)value, (Iterable)ranges, (SimpleTextAttributes)this.foregroundAttributes, (SimpleTextAttributes)this.matchedAttributes);
            } else {
                this.append(value, this.foregroundAttributes);
            }
            return (Component)((Object)this);
        }
    }
}

