/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.adtui.ui.ScaledImageProvider;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.SVGLoader;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/adtui/ui/SVGScaledImageProvider;", "Lcom/android/tools/adtui/ui/ScaledImageProvider;", "url", "Ljava/net/URL;", "image", "Ljava/awt/Image;", "<init>", "(Ljava/net/URL;Ljava/awt/Image;)V", "initialImage", "getInitialImage", "()Ljava/awt/Image;", "createScaledImage", "ctx", "Lcom/intellij/ui/scale/ScaleContext;", "width", "", "height", "Companion", "intellij.android.adt.ui"})
public final class SVGScaledImageProvider
implements ScaledImageProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URL url;
    @Nullable
    private final Image image;

    public SVGScaledImageProvider(@NotNull URL url, @Nullable Image image) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.image = image;
    }

    @Override
    @Nullable
    public Image getInitialImage() {
        return this.image;
    }

    @Override
    @WorkerThread
    @NotNull
    public Image createScaledImage(@NotNull ScaleContext ctx, double width, double height) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        double size = RangesKt.coerceAtMost((double)width, (double)height);
        InputStream inputStream = this.url.openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openStream(...)");
        return SVGLoader.load((URL)this.url, (InputStream)inputStream, (ScaleContext)ctx, (double)size, (double)size);
    }

    @JvmStatic
    @NotNull
    public static final SVGScaledImageProvider create(@NotNull Icon icon) {
        return Companion.create(icon);
    }

    @JvmStatic
    @NotNull
    public static final SVGScaledImageProvider create(@NotNull CachedImageIcon cachedIcon) {
        return Companion.create(cachedIcon);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/adtui/ui/SVGScaledImageProvider$Companion;", "", "<init>", "()V", "create", "Lcom/android/tools/adtui/ui/SVGScaledImageProvider;", "icon", "Ljavax/swing/Icon;", "cachedIcon", "Lcom/intellij/ui/icons/CachedImageIcon;", "intellij.android.adt.ui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SVGScaledImageProvider create(@NotNull Icon icon) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            if (icon instanceof CachedImageIcon) {
                return this.create((CachedImageIcon)icon);
            }
            throw new IllegalArgumentException("Icon should be an instance of CachedImageIcon. Got " + icon.getClass().getSimpleName());
        }

        @JvmStatic
        @NotNull
        public final SVGScaledImageProvider create(@NotNull CachedImageIcon cachedIcon) {
            Intrinsics.checkNotNullParameter((Object)cachedIcon, (String)"cachedIcon");
            URL url = cachedIcon.getUrl();
            if (url != null) {
                return new SVGScaledImageProvider(url, cachedIcon.getRealImage());
            }
            throw new IllegalArgumentException("CachedImageIcon should have a valid URL");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

