/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.model.Stopwatch;
import com.android.tools.adtui.ui.ImagePanel;
import com.android.tools.adtui.ui.ImagePanelKt;
import com.android.tools.adtui.ui.ScaledImageProvider;
import com.android.tools.adtui.ui.ScalingImagePanel;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.concurrency.FutureUtils;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003*\u0001\u0011\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010)\u001a\u00020\u0015H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020\u0015H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0017H\u0002J\u0010\u00101\u001a\u00020/2\u0006\u00100\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u001d@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R(\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\u0016\u001a\u0004\u0018\u00010#@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00062"}, d2={"Lcom/android/tools/adtui/ui/ScalingImagePanel;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/android/tools/adtui/ui/ImagePanel;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "stopwatch", "Lcom/android/tools/adtui/model/Stopwatch;", "edtExecutor", "Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;", "boundedExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "taskExecutor", "resizedListener", "com/android/tools/adtui/ui/ScalingImagePanel$resizedListener$1", "Lcom/android/tools/adtui/ui/ScalingImagePanel$resizedListener$1;", "previousFuture", "Ljava/util/concurrent/Future;", "", "value", "Ljava/awt/Image;", "image", "getImage", "()Ljava/awt/Image;", "setImage", "(Ljava/awt/Image;)V", "", "active", "getActive", "()Z", "setActive", "(Z)V", "Lcom/android/tools/adtui/ui/ScaledImageProvider;", "scaledImageProvider", "getScaledImageProvider", "()Lcom/android/tools/adtui/ui/ScaledImageProvider;", "setScaledImageProvider", "(Lcom/android/tools/adtui/ui/ScaledImageProvider;)V", "dispose", "paintComponent", "g", "Ljava/awt/Graphics;", "repaintAsync", "userWidth", "", "img", "pixelWidth", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nScalingImagePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScalingImagePanel.kt\ncom/android/tools/adtui/ui/ScalingImagePanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,155:1\n14#2:156\n*S KotlinDebug\n*F\n+ 1 ScalingImagePanel.kt\ncom/android/tools/adtui/ui/ScalingImagePanel\n*L\n44#1:156\n*E\n"})
public class ScalingImagePanel
extends JBPanel<ImagePanel>
implements Disposable {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final Stopwatch stopwatch;
    @NotNull
    private final FutureCallbackExecutor edtExecutor;
    @NotNull
    private final ExecutorService boundedExecutor;
    @NotNull
    private final FutureCallbackExecutor taskExecutor;
    @NotNull
    private final resizedListener.1 resizedListener;
    @Nullable
    private Future<Unit> previousFuture;
    @Nullable
    private Image image;
    private boolean active;
    @Nullable
    private ScaledImageProvider scaledImageProvider;

    public ScalingImagePanel() {
        super(true);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ScalingImagePanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.stopwatch = new Stopwatch();
        this.edtExecutor = new FutureCallbackExecutor((Executor)EdtExecutorService.getInstance());
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ScalingImagePanel", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.boundedExecutor = executorService;
        this.taskExecutor = new FutureCallbackExecutor((Executor)this.boundedExecutor);
        this.resizedListener = new ComponentAdapter(this){
            final /* synthetic */ ScalingImagePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                ScalingImagePanel.access$repaintAsync(this.this$0);
            }
        };
        this.active = true;
    }

    @Nullable
    public final Image getImage() {
        return this.image;
    }

    public final void setImage(@Nullable Image value) {
        this.image = value;
        this.repaint();
    }

    public final boolean getActive() {
        return this.active;
    }

    public final void setActive(boolean value) {
        this.active = value;
        this.repaint();
    }

    @Nullable
    public final ScaledImageProvider getScaledImageProvider() {
        return this.scaledImageProvider;
    }

    public final void setScaledImageProvider(@Nullable ScaledImageProvider value) {
        this.scaledImageProvider = value;
        if (value == null) {
            this.removeComponentListener(this.resizedListener);
            this.repaint();
        } else {
            this.addComponentListener(this.resizedListener);
            this.setImage(value.getInitialImage());
            this.repaintAsync();
        }
    }

    public void dispose() {
        this.removeComponentListener(this.resizedListener);
        Future<Unit> future = this.previousFuture;
        if (future != null) {
            future.cancel(false);
        }
        this.boundedExecutor.shutdownNow();
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        ImagePanelKt.paintPanelImage(this, g, this.image, this.active, false);
    }

    private final void repaintAsync() {
        block1: {
            ScaledImageProvider scaledImageProvider = this.scaledImageProvider;
            if (scaledImageProvider == null) break block1;
            ScaledImageProvider provider = scaledImageProvider;
            boolean bl = false;
            double width = this.getWidth();
            double height = this.getHeight();
            ScaleContext ctx = ScaleContext.Companion.create((Component)((Object)this));
            ListenableFuture listenableFuture = this.taskExecutor.executeAsync(ScalingImagePanel::repaintAsync$lambda$4$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"executeAsync(...)");
            ListenableFuture newFuture = FutureUtils.catching((ListenableFuture)FutureUtils.transform((ListenableFuture)FutureUtils.transform((ListenableFuture)listenableFuture, (Executor)((Executor)this.taskExecutor), arg_0 -> ScalingImagePanel.repaintAsync$lambda$4$lambda$1(this, provider, ctx, width, height, arg_0)), (Executor)((Executor)this.edtExecutor), arg_0 -> ScalingImagePanel.repaintAsync$lambda$4$lambda$2(this, ctx, provider, arg_0)), (Executor)((Executor)this.edtExecutor), Exception.class, arg_0 -> ScalingImagePanel.repaintAsync$lambda$4$lambda$3(this, arg_0));
            Future<Unit> future = this.previousFuture;
            if (future != null) {
                future.cancel(false);
            }
            this.previousFuture = (Future)newFuture;
        }
    }

    private final int userWidth(Image img) {
        if (img instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)img).getUserWidth();
        }
        return img.getWidth(null);
    }

    private final int pixelWidth(Image img) {
        if (img instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)img).getRealWidth();
        }
        return img.getWidth(null);
    }

    private static final Unit repaintAsync$lambda$4$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Image repaintAsync$lambda$4$lambda$1(ScalingImagePanel this$0, ScaledImageProvider $provider, ScaleContext $ctx, double $width, double $height, Unit it) {
        this$0.stopwatch.start();
        Image result = $provider.createScaledImage($ctx, $width, $height);
        this$0.stopwatch.stop();
        this$0.LOG.debug("createScaleImage(scaleContext=" + $ctx + ", w=" + $width + ", h=" + $height + ") is done in " + TimeUnit.NANOSECONDS.toMillis(this$0.stopwatch.getTotalRunningTimeNs()) + " msec");
        return result;
    }

    private static final Unit repaintAsync$lambda$4$lambda$2(ScalingImagePanel this$0, ScaleContext $ctx, ScaledImageProvider $provider, Image newImage) {
        Intrinsics.checkNotNullParameter((Object)newImage, (String)"newImage");
        this$0.LOG.debug("Updating panel image (scaleContext=" + $ctx + ", userWidth=" + this$0.userWidth(newImage) + ", pixelWidth=" + this$0.pixelWidth(newImage) + ")");
        if (Intrinsics.areEqual((Object)$provider, (Object)this$0.scaledImageProvider)) {
            this$0.setImage(newImage);
        }
        return Unit.INSTANCE;
    }

    private static final Unit repaintAsync$lambda$4$lambda$3(ScalingImagePanel this$0, Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.LOG.warn("Error loading scaled image", (Throwable)e);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$repaintAsync(ScalingImagePanel $this) {
        $this.repaintAsync();
    }
}

