/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.stdui.ActionData;
import com.android.tools.adtui.stdui.UrlData;
import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.DetachedToolWindowManager;
import com.android.tools.adtui.workbench.LayeredPanel;
import com.android.tools.adtui.workbench.Layout;
import com.android.tools.adtui.workbench.MinimizedPanel;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.android.tools.adtui.workbench.SidePanel;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBenchLoadingPanel;
import com.android.tools.adtui.workbench.WorkBenchManager;
import com.android.tools.adtui.workbench.WorkBenchToolWindowListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class WorkBench<T>
extends JBLayeredPane
implements Disposable {
    private static Logger LOG = Logger.getInstance(WorkBench.class);
    private final Project myProject;
    private final String myName;
    private final PropertiesComponent myPropertiesComponent;
    private final WorkBenchManager myWorkBenchManager;
    private final FileEditorManager myFileEditorManager;
    private final List<ToolWindowDefinition<T>> myToolDefinitions;
    private final SideModel<T> myModel;
    private final ThreeComponentsSplitter mySplitter;
    private final WorkBenchLoadingPanel myLoadingPanel;
    private final JPanel myMainPanel;
    private final MinimizedPanel<T> myLeftMinimizePanel;
    private final MinimizedPanel<T> myRightMinimizePanel;
    private final AttachedToolWindow.ButtonDragListener<T> myButtonDragListener;
    private final PropertyChangeListener myMyPropertyChangeListener = this::handlePropertyEvent;
    private final List<WorkBenchToolWindowListener<T>> myWorkBenchToolWindowListeners;
    private FileEditor myFileEditor;
    private AtomicBoolean isInitialized = new AtomicBoolean(false);
    private boolean isDisposed = false;
    @NotNull
    private String myContext = "";

    public WorkBench(@NotNull Project project, @NotNull String name, @Nullable FileEditor fileEditor, @NotNull Disposable parentDisposable, int delayTimeMs) {
        this(project, name, fileEditor, InitParams.createParams(project), delayTimeMs);
        Disposer.register((Disposable)parentDisposable, this);
    }

    public WorkBench(@NotNull Project project, @NotNull String name, @Nullable FileEditor fileEditor, @NotNull Disposable parentDisposable) {
        this(project, name, fileEditor, parentDisposable, 1000);
    }

    public void init(@NotNull JComponent content, @NotNull T context, @NotNull List<ToolWindowDefinition<T>> definitions, boolean minimizedWindows) {
        this.mySplitter.setInnerComponent(content);
        this.init(context, definitions, minimizedWindows);
    }

    public void init(@NotNull T context, @NotNull List<ToolWindowDefinition<T>> definitions, boolean minimizedWindows) {
        LOG.debug("init");
        if (!this.isInitialized.getAndSet(true)) {
            this.initFirstTime();
        }
        this.myToolDefinitions.clear();
        this.myToolDefinitions.addAll(definitions);
        this.myModel.setContext(context);
        this.addToolsToModel(minimizedWindows);
    }

    private void initFirstTime() {
        if (ScreenReader.isActive()) {
            this.setFocusCycleRoot(true);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        }
        this.myLoadingPanel.stopLoading();
        this.myMainPanel.setVisible(true);
        this.mySplitter.addDividerResizeListener(this.createWidthUpdater());
        this.mySplitter.setFirstSize(this.getInitialSideWidth(Side.LEFT));
        if (this.mySplitter.getInnerComponent() != null) {
            this.mySplitter.setLastSize(this.getInitialSideWidth(Side.RIGHT));
        }
        if (!this.isDisposed) {
            this.myWorkBenchManager.register(this);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.myMyPropertyChangeListener);
        }
        if (!this.myProject.isDisposed()) {
            DetachedToolWindowManager.getInstance(this.myProject).updateToolWindowsForWorkBench(this);
        }
        if (this.mySplitter.getInnerComponent() == null) {
            Objects.requireNonNull(this.mySplitter.getFirstComponent()).setBorder((Border)JBUI.Borders.empty());
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public void updateUI() {
        this.myLoadingPanel.updateUI();
        this.myMainPanel.updateUI();
        this.myLeftMinimizePanel.updateUI();
        this.myRightMinimizePanel.updateUI();
        for (AttachedToolWindow<T> tool : this.myModel.getAllTools()) {
            tool.getMinimizedButton().updateUI();
        }
    }

    public void setLoadingText(@NotNull String loadingText) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setLoadingText: " + loadingText);
        }
        this.myLoadingPanel.setLoadingText(loadingText);
    }

    public void showLoading(@NotNull String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("showLoading: " + message);
        }
        this.setLoadingText(message);
        this.myLoadingPanel.startLoading();
    }

    public void hideLoading() {
        LOG.debug("hideLoading");
        this.myLoadingPanel.stopLoading();
    }

    public void loadingStopped(@NotNull String message) {
        this.loadingStopped(message, null);
    }

    public void loadingStopped(@NotNull String message, @Nullable ActionData actionData) {
        this.loadingStopped(message, AllIcons.General.Warning, null, actionData);
    }

    public void loadingStopped(@NotNull String message, @Nullable Icon icon, @Nullable UrlData urlData, ActionData ... actionData) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("loadingStopped " + message);
        }
        this.myLoadingPanel.abortLoading(message, icon, urlData, actionData);
    }

    public boolean isMessageVisible() {
        return this.myLoadingPanel.isLoadingOrHasError();
    }

    @TestOnly
    public WorkBenchLoadingPanel getLoadingPanel() {
        return this.myLoadingPanel;
    }

    public void setToolContext(@Nullable T context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setToolContext " + String.valueOf(context));
        }
        this.myModel.setContext(context);
    }

    public void setFileEditor(@Nullable FileEditor fileEditor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setFileEditor " + String.valueOf(fileEditor));
        }
        if (!this.myProject.isDisposed()) {
            DetachedToolWindowManager.getInstance(this.myProject).unregister(this.myFileEditor);
            DetachedToolWindowManager.getInstance(this.myProject).register(fileEditor, this);
        }
        this.myFileEditor = fileEditor;
        if (fileEditor != null && this.isCurrentEditor(fileEditor) && !this.myProject.isDisposed()) {
            DetachedToolWindowManager.getInstance(this.myProject).updateToolWindowsForWorkBench(this);
        }
    }

    public void dispose() {
        LOG.debug("dispose");
        this.isDisposed = true;
        this.myWorkBenchManager.unregister(this);
        if (!this.myProject.isDisposed()) {
            DetachedToolWindowManager.getInstance(this.myProject).unregister(this.myFileEditor);
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.myMyPropertyChangeListener);
        this.setToolContext(null);
        this.myModel.clearContextAndTools();
        this.myMainPanel.removeAll();
        this.mySplitter.setInnerComponent(null);
        this.mySplitter.setFirstComponent(null);
        this.mySplitter.setLastComponent(null);
        this.mySplitter.removeAll();
        this.myLoadingPanel.removeAll();
    }

    WorkBench(@NotNull Project project, @NotNull String name, @Nullable FileEditor fileEditor, @NotNull InitParams<T> params, int startDelayMs) {
        this.myProject = project;
        this.myName = name;
        this.myFileEditor = fileEditor;
        this.myPropertiesComponent = PropertiesComponent.getInstance();
        this.myWorkBenchManager = WorkBenchManager.getInstance();
        this.myFileEditorManager = FileEditorManager.getInstance((Project)project);
        this.myToolDefinitions = new ArrayList<ToolWindowDefinition<T>>(4);
        this.myModel = params.myModel;
        this.myModel.addListener(this::modelChanged);
        this.myButtonDragListener = new MyButtonDragListener();
        this.mySplitter = this.initSplitter(params.mySplitter);
        this.myLeftMinimizePanel = params.myLeftMinimizePanel;
        this.myRightMinimizePanel = params.myRightMinimizePanel;
        LayeredPanel<T> layeredPanel = new LayeredPanel<T>(this.myName, (JComponent)this.mySplitter, this.myModel);
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add(this.myLeftMinimizePanel, "West");
        this.myMainPanel.add((Component)((Object)layeredPanel), "Center");
        this.myMainPanel.add(this.myRightMinimizePanel, "East");
        this.myLoadingPanel = new WorkBenchLoadingPanel(new BorderLayout(), this, startDelayMs);
        this.myLoadingPanel.add(this.myMainPanel);
        Disposer.register((Disposable)this, layeredPanel);
        this.add(this.myLoadingPanel, JLayeredPane.DEFAULT_LAYER);
        this.myMainPanel.setVisible(false);
        this.myLoadingPanel.startLoading();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.myWorkBenchToolWindowListeners = new CopyOnWriteArrayList<WorkBenchToolWindowListener<T>>();
    }

    private boolean isCurrentEditor(@NotNull FileEditor fileEditor) {
        for (FileEditor editor : this.myFileEditorManager.getSelectedEditors()) {
            if (fileEditor != editor) continue;
            return true;
        }
        return false;
    }

    private void handlePropertyEvent(@NotNull PropertyChangeEvent event) {
        this.updateDetachedToolWindows(event);
        this.autoHide(event);
    }

    private void updateDetachedToolWindows(@NotNull PropertyChangeEvent event) {
        JComponent oldComponent;
        Object newValue = event.getNewValue();
        if (!(newValue instanceof JComponent)) {
            return;
        }
        JComponent newComponent = (JComponent)newValue;
        JComponent jComponent = oldComponent = event.getOldValue() instanceof JComponent ? (JComponent)event.getOldValue() : null;
        if (!(!SwingUtilities.isDescendingFrom(newComponent, (Component)((Object)this)) || oldComponent != null && SwingUtilities.isDescendingFrom(oldComponent, (Component)((Object)this)) || this.myProject.isDisposed())) {
            DetachedToolWindowManager.getInstance(this.myProject).updateToolWindowsForWorkBench(this);
        }
    }

    private void autoHide(@NotNull PropertyChangeEvent event) {
        JComponent newComponent;
        AttachedToolWindow<T> autoToolWindow = this.myModel.getVisibleAutoHideTool();
        if (autoToolWindow == null) {
            return;
        }
        Object newValue = event.getNewValue();
        if (newValue instanceof JComponent && !SwingUtilities.isDescendingFrom(newComponent = (JComponent)newValue, autoToolWindow.getComponent()) && !SwingUtilities.isDescendingFrom(autoToolWindow.getComponent(), newComponent)) {
            autoToolWindow.setPropertyAndUpdate(AttachedToolWindow.PropertyType.MINIMIZED, true);
        }
    }

    @NotNull
    private ThreeComponentsSplitter initSplitter(@NotNull ThreeComponentsSplitter splitter) {
        splitter.setDividerWidth(0);
        splitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setFirstComponent(new SidePanel<T>(Side.LEFT, this.myModel));
        splitter.setLastComponent(new SidePanel<T>(Side.RIGHT, this.myModel));
        splitter.setShowDividerControls(true);
        splitter.setFocusCycleRoot(false);
        splitter.setFocusTraversalPolicyProvider(true);
        splitter.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        return splitter;
    }

    @NotNull
    private String getUnscaledWidthPropertyName(@NotNull Layout layout, @NotNull Side side) {
        return "ATTACHED_TOOL_WINDOW." + layout.getPrefix() + this.myName + "." + side.name() + ".UNSCALED.WIDTH";
    }

    @NotNull
    private String getScaledWidthPropertyName(@NotNull Layout layout, @NotNull Side side) {
        return "ATTACHED_TOOL_WINDOW." + layout.getPrefix() + this.myName + "." + side.name() + ".WIDTH";
    }

    private int getSideWidth(@NotNull Layout layout, @NotNull Side side) {
        int width = this.myPropertiesComponent.getInt(this.getUnscaledWidthPropertyName(layout, side), -1);
        if (width != -1) {
            return JBUI.scale((int)width);
        }
        int scaledWidth = this.myPropertiesComponent.getInt(this.getScaledWidthPropertyName(layout, side), -1);
        if (scaledWidth != -1) {
            return -1;
        }
        this.myPropertiesComponent.unsetValue(this.getScaledWidthPropertyName(layout, side));
        this.setSideWidth(layout, side, scaledWidth);
        return scaledWidth;
    }

    private void setSideWidth(@NotNull Layout layout, @NotNull Side side, int value) {
        this.myPropertiesComponent.setValue(this.getUnscaledWidthPropertyName(layout, side), AdtUiUtils.unscale(value), -1);
    }

    private int getInitialSideWidth(@NotNull Side side) {
        int minimalWidth = this.getMinimumWidth(side);
        int width = this.getSideWidth(Layout.CURRENT, side);
        if (width == -1) {
            this.setSideWidth(Layout.DEFAULT, side, width);
            this.setSideWidth(Layout.CURRENT, side, width);
        }
        return Math.max(width, minimalWidth);
    }

    private int getMinimumWidth(@NotNull Side side) {
        Optional<Integer> initialMinimumWidth = this.myToolDefinitions.stream().filter(tool -> tool.getSide() == side).map(ToolWindowDefinition::getInitialMinimumWidth).max(Comparator.comparing(size -> size));
        return initialMinimumWidth.orElse(ToolWindowDefinition.DEFAULT_SIDE_WIDTH);
    }

    @NotNull
    private ComponentListener createWidthUpdater() {
        return new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                WorkBench.this.adjustSplitterForInsufficentSpace();
                WorkBench.this.updateBothWidths();
            }
        };
    }

    private void adjustSplitterForInsufficentSpace() {
        int minRightWidth;
        if (this.mySplitter.getWidth() <= 0 || !this.mySplitter.isVisible()) {
            return;
        }
        JComponent content = this.mySplitter.getInnerComponent();
        int actualCenterWidth = this.mySplitter.getWidth() - (this.mySplitter.getFirstSize() + this.mySplitter.getLastSize());
        int minCenterWidth = content != null ? Math.max(content.getMinimumSize().width, ToolWindowDefinition.DEFAULT_SIDE_WIDTH) : 0;
        int minLeftWidth = this.myModel.getVisibleTools(Side.LEFT).isEmpty() ? 0 : this.getMinimumWidth(Side.LEFT);
        int n = minRightWidth = this.myModel.getVisibleTools(Side.RIGHT).isEmpty() ? 0 : this.getMinimumWidth(Side.RIGHT);
        if (this.mySplitter.getFirstSize() >= minLeftWidth && this.mySplitter.getLastSize() >= minRightWidth && actualCenterWidth >= minCenterWidth) {
            return;
        }
        if (this.mySplitter.getWidth() >= minLeftWidth + minCenterWidth + minRightWidth) {
            int rightExcess;
            int excess = this.mySplitter.getWidth() - (minLeftWidth + minCenterWidth + minRightWidth);
            int leftExcess = Math.max(0, this.mySplitter.getFirstSize() - minLeftWidth);
            if (leftExcess + (rightExcess = Math.max(0, this.mySplitter.getLastSize() - minRightWidth)) > excess) {
                double reduction = 1.0 * (double)excess / (double)(leftExcess + rightExcess);
                this.mySplitter.setFirstSize(minLeftWidth + (int)((double)leftExcess * reduction));
                this.mySplitter.setLastSize(minRightWidth + (int)((double)rightExcess * reduction));
            }
        } else {
            int sections = 1 + (minLeftWidth > 0 ? 1 : 0) + (minRightWidth > 0 ? 1 : 0);
            int sectionWidth = this.mySplitter.getWidth() / sections;
            if (minLeftWidth > 0) {
                this.mySplitter.setFirstSize(sectionWidth);
            }
            if (minRightWidth > 0) {
                this.mySplitter.setLastSize(sectionWidth);
            }
        }
    }

    private void updateBothWidths() {
        this.updateWidth(Side.LEFT);
        this.updateWidth(Side.RIGHT);
    }

    private void restoreBothWidths() {
        this.mySplitter.setFirstSize(this.getInitialSideWidth(Side.LEFT));
        this.mySplitter.setLastSize(this.getInitialSideWidth(Side.RIGHT));
    }

    private void updateWidth(@NotNull Side side) {
        int minimalWidth = this.getMinimumWidth(side);
        int width = side.isLeft() ? this.mySplitter.getFirstSize() : this.mySplitter.getLastSize();
        if ((width = Math.max(minimalWidth, width)) != 0 && width != this.getSideWidth(Layout.CURRENT, side)) {
            this.setSideWidth(Layout.CURRENT, side, width);
        }
    }

    @NotNull
    private String getToolOrderPropertyName(@NotNull Layout layout) {
        return "ATTACHED_TOOL_WINDOW." + layout.getPrefix() + this.myName + ".TOOL_ORDER";
    }

    private void restoreToolOrder(@NotNull List<AttachedToolWindow<T>> tools) {
        String orderAsString = this.myPropertiesComponent.getValue(this.getToolOrderPropertyName(Layout.CURRENT));
        if (orderAsString == null) {
            return;
        }
        HashMap<String, Integer> order = new HashMap<String, Integer>(8);
        int number = 1;
        for (String string : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)orderAsString)) {
            order.put(string, number++);
        }
        for (AttachedToolWindow attachedToolWindow : tools) {
            Integer placement = (Integer)order.get(attachedToolWindow.getToolName());
            if (placement == null) {
                placement = number++;
            }
            attachedToolWindow.setToolOrder(placement);
        }
        tools.sort(Comparator.comparingInt(AttachedToolWindow::getToolOrder));
    }

    private void storeToolOrder(@NotNull Layout layout, @NotNull List<AttachedToolWindow<T>> tools) {
        StringBuilder builder = new StringBuilder();
        for (AttachedToolWindow<T> tool : tools) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(tool.getToolName());
        }
        this.myPropertiesComponent.setValue(this.getToolOrderPropertyName(layout), builder.toString());
    }

    private void setDefaultOrderIfMissing(@NotNull List<AttachedToolWindow<T>> tools) {
        if (!this.myPropertiesComponent.isValueSet(this.getToolOrderPropertyName(Layout.CURRENT))) {
            this.storeToolOrder(Layout.DEFAULT, tools);
            this.storeToolOrder(Layout.CURRENT, tools);
        }
    }

    private void modelChanged(@NotNull SideModel<T> model2, @NotNull SideModel.EventType type) {
        switch (type) {
            case SWAP: {
                this.mySplitter.setFirstSize(this.getSideWidth(Layout.CURRENT, Side.RIGHT));
                this.mySplitter.setLastSize(this.getSideWidth(Layout.CURRENT, Side.LEFT));
                this.updateBothWidths();
                this.myWorkBenchManager.updateOtherWorkBenches(this);
                break;
            }
            case UPDATE_DETACHED_WINDOW: {
                this.myWorkBenchManager.updateOtherWorkBenches(this);
                if (this.myProject.isDisposed()) break;
                DetachedToolWindowManager.getInstance(this.myProject).updateToolWindowsForWorkBench(this);
                break;
            }
            case LOCAL_UPDATE: {
                break;
            }
            case UPDATE: {
                this.notifyWorkBenchToolWindowListeners();
                this.myWorkBenchManager.updateOtherWorkBenches(this);
                break;
            }
            case UPDATE_TOOL_ORDER: {
                this.storeToolOrder(Layout.CURRENT, this.myModel.getAllTools());
                this.myWorkBenchManager.updateOtherWorkBenches(this);
                break;
            }
            default: {
                this.myWorkBenchManager.updateOtherWorkBenches(this);
            }
        }
    }

    private void addToolsToModel(boolean minimizedWindows) {
        ArrayList<AttachedToolWindow<T>> tools = new ArrayList<AttachedToolWindow<T>>(this.myToolDefinitions.size());
        for (ToolWindowDefinition<T> definition : this.myToolDefinitions) {
            AttachedToolWindow<T> toolWindow = new AttachedToolWindow<T>(definition, this.myButtonDragListener, this, this.myModel, minimizedWindows);
            tools.add(toolWindow);
        }
        this.setDefaultOrderIfMissing(tools);
        this.restoreToolOrder(tools);
        this.myModel.setTools(tools);
        this.notifyWorkBenchToolWindowListeners();
    }

    private void notifyWorkBenchToolWindowListeners() {
        this.myWorkBenchToolWindowListeners.forEach(t -> t.visibleToolWindowsChanged(this.myModel.getAllTools().stream().filter(w -> !w.isMinimized()).map(AttachedToolWindow::getToolName).collect(Collectors.toSet())));
    }

    public void hideContent() {
        this.myMainPanel.setVisible(false);
    }

    public boolean showContent() {
        this.hideLoading();
        boolean wasVisible = this.myMainPanel.isVisible();
        this.myMainPanel.setVisible(true);
        return !wasVisible;
    }

    public List<AttachedToolWindow<T>> getDetachedToolWindows() {
        return this.myModel.getDetachedTools();
    }

    public void storeDefaultLayout() {
        String orderAsString = this.myPropertiesComponent.getValue(this.getToolOrderPropertyName(Layout.CURRENT));
        this.myPropertiesComponent.setValue(this.getToolOrderPropertyName(Layout.DEFAULT), orderAsString);
        this.setSideWidth(Layout.DEFAULT, Side.LEFT, this.getSideWidth(Layout.CURRENT, Side.LEFT));
        this.setSideWidth(Layout.DEFAULT, Side.RIGHT, this.getSideWidth(Layout.CURRENT, Side.RIGHT));
        for (AttachedToolWindow<T> tool : this.myModel.getAllTools()) {
            tool.storeDefaultLayout();
        }
    }

    public void restoreDefaultLayout() {
        String orderAsString = this.myPropertiesComponent.getValue(this.getToolOrderPropertyName(Layout.DEFAULT));
        this.myPropertiesComponent.setValue(this.getToolOrderPropertyName(Layout.CURRENT), orderAsString);
        this.setSideWidth(Layout.CURRENT, Side.LEFT, this.getSideWidth(Layout.DEFAULT, Side.LEFT));
        this.setSideWidth(Layout.CURRENT, Side.RIGHT, this.getSideWidth(Layout.DEFAULT, Side.RIGHT));
        for (AttachedToolWindow<T> tool : this.myModel.getAllTools()) {
            tool.restoreDefaultLayout();
        }
        this.updateModel();
    }

    public void updateModel() {
        this.restoreBothWidths();
        this.restoreToolOrder(this.myModel.getAllTools());
        this.myModel.updateLocally();
    }

    public void doLayout() {
        this.myLoadingPanel.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    public void setContext(@NotNull String context) {
        this.myContext = context;
    }

    public void setDefaultPropertiesForContext(boolean minimizedByDefault) {
        List<AttachedToolWindow<AttachedToolWindow>> tools = this.myModel.getAllTools();
        if (tools.isEmpty()) {
            return;
        }
        tools.forEach(tool -> {
            tool.setDefaultProperty(AttachedToolWindow.PropertyType.LEFT, tool.getDefinition().getSide().isLeft());
            tool.setDefaultProperty(AttachedToolWindow.PropertyType.SPLIT, tool.getDefinition().getSplit().isBottom());
            tool.setDefaultProperty(AttachedToolWindow.PropertyType.AUTO_HIDE, tool.getDefinition().getAutoHide().isAutoHide());
            tool.setDefaultProperty(AttachedToolWindow.PropertyType.MINIMIZED, minimizedByDefault);
        });
        this.updateModel();
    }

    public void showToolWindow(@NotNull String name) {
        Optional<AttachedToolWindow> toolWindow = this.myModel.getAllTools().stream().filter(t -> t.getToolName().equals(name)).findFirst();
        if (toolWindow.isPresent() && toolWindow.get().isMinimized()) {
            AttachedToolWindow window = toolWindow.get();
            this.myModel.getAllTools().stream().filter(t -> t.isLeft() == window.isLeft() && t.isSplit() == window.isSplit()).forEach(t -> t.setMinimized(true));
            window.setMinimized(false);
            this.updateModel();
        }
    }

    @NotNull
    public String getContext() {
        return this.myContext;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public void addWorkBenchToolWindowListener(WorkBenchToolWindowListener<T> listener2) {
        this.myWorkBenchToolWindowListeners.add(listener2);
    }

    public int getAttachedToolWindowHeaderHeight() {
        return this.myModel.getAllTools().stream().findFirst().map(AttachedToolWindow::getHeaderHeight).orElse(0);
    }

    @TestOnly
    @Nullable
    public List<JComponent> getTopComponents(Side side) {
        return this.myModel.getTopTools(side).stream().map(AttachedToolWindow::getComponent).toList();
    }

    @TestOnly
    @Nullable
    public List<JComponent> getBottomComponents(Side side) {
        return this.myModel.getBottomTools(side).stream().map(AttachedToolWindow::getComponent).toList();
    }

    @TestOnly
    public T getModelContext() {
        return this.myModel.getContext();
    }

    @VisibleForTesting
    static class InitParams<T> {
        private final SideModel<T> myModel;
        private final ThreeComponentsSplitter mySplitter;
        private final MinimizedPanel<T> myLeftMinimizePanel;
        private final MinimizedPanel<T> myRightMinimizePanel;

        @VisibleForTesting
        InitParams(@NotNull SideModel<T> model2, @NotNull ThreeComponentsSplitter splitter, @NotNull MinimizedPanel<T> leftMinimizePanel, @NotNull MinimizedPanel<T> rightMinimizePanel) {
            this.myModel = model2;
            this.mySplitter = splitter;
            this.myLeftMinimizePanel = leftMinimizePanel;
            this.myRightMinimizePanel = rightMinimizePanel;
        }

        private static <T> InitParams<T> createParams(@NotNull Project project) {
            SideModel model2 = new SideModel(project);
            return new InitParams(model2, new ThreeComponentsSplitter(), new MinimizedPanel(Side.LEFT, model2), new MinimizedPanel(Side.RIGHT, model2));
        }
    }

    private class MyButtonDragListener
    implements AttachedToolWindow.ButtonDragListener<T> {
        private final int BUTTON_PANEL_WIDTH = JBUI.scale((int)21);
        private boolean myIsDragging;
        private MinimizedPanel<T> myPreviousButtonPanel;

        private MyButtonDragListener() {
        }

        @Override
        public void buttonDragged(@NotNull AttachedToolWindow<T> toolWindow, @NotNull AttachedToolWindow.DragEvent event) {
            if (!this.myIsDragging) {
                this.startDragging(event);
            }
            this.moveDragImage(toolWindow, event);
            this.notifyButtonPanel(toolWindow, event, false);
        }

        @Override
        public void buttonDropped(@NotNull AttachedToolWindow<T> toolWindow, @NotNull AttachedToolWindow.DragEvent event) {
            if (this.myIsDragging) {
                this.notifyButtonPanel(toolWindow, event, true);
                this.stopDragging(toolWindow, event);
            }
        }

        private void startDragging(@NotNull AttachedToolWindow.DragEvent event) {
            WorkBench.this.add(event.getDragImage(), JLayeredPane.DRAG_LAYER);
            this.myIsDragging = true;
        }

        private void stopDragging(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.DragEvent event) {
            AbstractButton button = tool.getMinimizedButton();
            button.setVisible(true);
            WorkBench.this.remove(event.getDragImage());
            WorkBench.this.revalidate();
            WorkBench.this.repaint();
            this.myPreviousButtonPanel = null;
            this.myIsDragging = false;
        }

        private void moveDragImage(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.DragEvent event) {
            AbstractButton button = tool.getMinimizedButton();
            Point position = SwingUtilities.convertPoint(button, event.getMousePoint(), (Component)((Object)WorkBench.this));
            Dimension buttonSize = button.getPreferredSize();
            Point dragPosition = event.getDragPoint();
            position.x = this.translate(position.x, dragPosition.x, 0, WorkBench.this.getWidth() - buttonSize.width);
            position.y = this.translate(position.y, dragPosition.y, 0, WorkBench.this.getHeight() - buttonSize.height);
            Component dragImage = event.getDragImage();
            Dimension size = dragImage.getPreferredSize();
            dragImage.setBounds(position.x, position.y, size.width, size.height);
            dragImage.revalidate();
            dragImage.repaint();
        }

        private void notifyButtonPanel(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.DragEvent event, boolean doDrop) {
            AbstractButton button = tool.getMinimizedButton();
            Point position = SwingUtilities.convertPoint(button, event.getMousePoint(), (Component)((Object)WorkBench.this));
            int yMidOfButton = position.y - event.getDragPoint().y + button.getHeight() / 2;
            if (position.x < this.BUTTON_PANEL_WIDTH) {
                this.notifyButtonPanel(tool, yMidOfButton, WorkBench.this.myLeftMinimizePanel, doDrop);
            } else if (position.x > WorkBench.this.getWidth() - this.BUTTON_PANEL_WIDTH) {
                this.notifyButtonPanel(tool, yMidOfButton, WorkBench.this.myRightMinimizePanel, doDrop);
            } else if (this.myPreviousButtonPanel != null) {
                this.myPreviousButtonPanel.dragExit(tool);
                this.myPreviousButtonPanel = null;
            }
        }

        private void notifyButtonPanel(@NotNull AttachedToolWindow<T> tool, int y, @NotNull MinimizedPanel<T> buttonPanel, boolean doDrop) {
            if (this.myPreviousButtonPanel != null && this.myPreviousButtonPanel != buttonPanel) {
                this.myPreviousButtonPanel.dragExit(tool);
            }
            this.myPreviousButtonPanel = buttonPanel;
            if (doDrop) {
                buttonPanel.dragDrop(tool, y);
            } else {
                buttonPanel.drag(tool, y);
            }
        }

        private int translate(int pos, int offset, int min, int max) {
            return Math.min(Math.max(pos - offset, min), max);
        }
    }
}

