/*
 * Decompiled with CFR 0.152.
 */
package com.google.play.policy.insights;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/google/play/policy/insights/PackageVisibilityPolicyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "policyinsights"})
public final class PackageVisibilityPolicyDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> PERMISSIONS = CollectionsKt.listOf((Object)"android.permission.QUERY_ALL_PACKAGES");
    @NotNull
    public static final String ID = "PackageVisibilityPolicy";
    @NotNull
    public static final String DESCRIPTION = "Package/App Visibility Insights";
    @NotNull
    private static final String EXPLANATION = "Accessing a user's installed app inventory is sensitive data. Google Play policy strictly \\\nlimits broad visibility (`QUERY_ALL_PACKAGES`), allowing it only for core app functionality \\\nthat requires extensive knowledge of installed apps for interoperability. You must \\\nprioritize using finite, targeted queries to access specific apps when possible, which can \\\nbe more privacy-friendly. Under no circumstances can data from the installed app inventory \\\nbe sold or shared for advertising or analytics monetization. \n\n**Dos:**\n\n- Submit a declaration form in your Play Console for `QUERY_ALL_PACKAGES` and any other \\\nhigh-risk permissions.\n- For your app review, clearly document why your app needs app visibility whether broad or \\\nmore targeted.\n- Access only the minimum data needed.\n- Follow the specific allowable use cases for `QUERY_ALL_PACKAGES.`\n\n**Don'ts:**\n\n- Request `QUERY_ALL_PACKAGES` if your need can be met with finite, targeted queries.\n- Gain broad app visibility via methods not explicitly allowed by policy.\n- Provide false information about your app's core functionality or data needs.\n- Collect or use unnecessary data from installed app data.\n\n**Helpful Links:**\n\nSee Policy page: https://goo.gle/play-policy-package-visibility \nSee Help Center article: https://goo.gle/play-help-broad-package-visibility \nSee Declaration form:  https://goo.gle/play-permission-decl-form\n\nAlways review the full policy in the Policy Center to ensure compliance.";
    @NotNull
    public static final String URL = "https://support.google.com/googleplay/android-developer/answer/9888170?hl=en#:~:text=package%20(app)%20visibility";
    @NotNull
    private static final String MESSAGE = "Protect user privacy by limiting all app visibility, especially `QUERY_ALL_PACKAGES` to \\\nessential core functions.";
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Attr nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        Attr attr = nameNode;
        if (CollectionsKt.contains((Iterable)PERMISSIONS, (Object)(attr != null ? attr.getValue() : null))) {
            Node node = element;
            Intrinsics.checkNotNull((Object)nameNode);
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)context.getLocation((Node)nameNode), (String)MESSAGE, null, (int)16, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        String string = EXPLANATION;
        Category category = Category.Companion.create("Play Policy", 84);
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(PackageVisibilityPolicyDetector.class, EnumSet.of((Enum)Scope.MANIFEST));
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)ID, (String)DESCRIPTION, (String)string, (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/google/play/policy/insights/PackageVisibilityPolicyDetector$Companion;", "", "<init>", "()V", "PERMISSIONS", "", "", "getPERMISSIONS", "()Ljava/util/List;", "ID", "DESCRIPTION", "EXPLANATION", "getEXPLANATION", "()Ljava/lang/String;", "URL", "MESSAGE", "getMESSAGE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "policyinsights"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPERMISSIONS() {
            return PERMISSIONS;
        }

        @NotNull
        public final String getEXPLANATION() {
            return EXPLANATION;
        }

        @NotNull
        public final String getMESSAGE() {
            return MESSAGE;
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

