/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.NameDetails;
import com.android.sdklib.SdkVersionInfo;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a*\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u0007\u001a(\u0010\u0007\u001a\u00020\b*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u001a\u001e\u0010\t\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u001a\u001e\u0010\u000b\u001a\u00020\b*\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\f"}, d2={"getFullApiName", "", "Lcom/android/sdklib/AndroidVersion;", "includeReleaseName", "", "includeCodeName", "includeMinorVersion", "getApiNameAndDetails", "Lcom/android/sdklib/NameDetails;", "getFullReleaseName", "includeApiLevel", "getReleaseNameAndDetails", "android.sdktools.sdklib"})
@JvmName(name="AndroidVersionUtils")
public final class AndroidVersionUtils {
    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName, boolean includeReleaseName, boolean includeCodeName, boolean includeMinorVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullApiName, (String)"<this>");
        NameDetails nameDetails = AndroidVersionUtils.getApiNameAndDetails($this$getFullApiName, includeReleaseName, includeCodeName, includeMinorVersion);
        if (nameDetails.getDetails() != null) {
            return nameDetails.getName() + " (" + nameDetails.getDetails() + ')';
        }
        return nameDetails.getName();
    }

    public static /* synthetic */ String getFullApiName$default(AndroidVersion androidVersion, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = true;
        }
        return AndroidVersionUtils.getFullApiName(androidVersion, bl, bl2, bl3);
    }

    @NotNull
    public static final NameDetails getApiNameAndDetails(@NotNull AndroidVersion $this$getApiNameAndDetails, boolean includeReleaseName, boolean includeCodeName, boolean includeMinorVersion) {
        String codeName;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getApiNameAndDetails, (String)"<this>");
        if ($this$getApiNameAndDetails.getCodename() != null) {
            return new NameDetails("API " + $this$getApiNameAndDetails.getCodename() + " Preview", null);
        }
        StringBuilder name = new StringBuilder("API ");
        StringBuilder stringBuilder = includeMinorVersion ? name.append($this$getApiNameAndDetails.getApiStringWithoutExtension()) : name.append($this$getApiNameAndDetails.getAndroidApiLevel().getMajorVersion());
        if (!$this$getApiNameAndDetails.isBaseExtension()) {
            StringBuilder stringBuilder2 = name.append(" ext. ");
            Integer n = $this$getApiNameAndDetails.getExtensionLevel();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getExtensionLevel(...)");
            stringBuilder2.append(((Number)n).intValue());
        }
        boolean useCodeName = false;
        useCodeName = includeCodeName;
        if (includeReleaseName) {
            String codeName2;
            String string2;
            String relName = SdkVersionInfo.getReleaseVersionString($this$getApiNameAndDetails.getApiLevel());
            if (relName == null) {
                String string3 = SdkVersionInfo.getCodeName($this$getApiNameAndDetails.getApiLevel());
                if (string3 != null) {
                    String string4;
                    String it = string4 = string3;
                    boolean bl = false;
                    useCodeName = false;
                    string2 = string4;
                } else {
                    string2 = null;
                }
            } else {
                string2 = codeName2 = null;
            }
            if ((string = relName) == null) {
                string = codeName2;
            }
        } else {
            string = null;
        }
        String releaseName = string;
        String string5 = codeName = useCodeName ? SdkVersionInfo.getCodeName($this$getApiNameAndDetails.getApiLevel()) : null;
        if (codeName == null && releaseName == null) {
            String string6 = name.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
            return new NameDetails(string6, null);
        }
        StringBuilder details = new StringBuilder();
        if (codeName != null) {
            details.append("\"").append(codeName).append("\"");
            if (releaseName != null) {
                details.append("; ");
            }
        }
        if (releaseName != null) {
            details.append("Android ").append(releaseName);
        }
        String string7 = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
        return new NameDetails(string7, details.toString());
    }

    public static /* synthetic */ NameDetails getApiNameAndDetails$default(AndroidVersion androidVersion, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = true;
        }
        return AndroidVersionUtils.getApiNameAndDetails(androidVersion, bl, bl2, bl3);
    }

    @NotNull
    public static final String getFullReleaseName(@NotNull AndroidVersion $this$getFullReleaseName, boolean includeApiLevel, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullReleaseName, (String)"<this>");
        NameDetails nameDetails = AndroidVersionUtils.getReleaseNameAndDetails($this$getFullReleaseName, includeApiLevel, includeCodeName);
        if (nameDetails.getDetails() != null) {
            return nameDetails.getName() + " (" + nameDetails.getDetails() + ')';
        }
        return nameDetails.getName();
    }

    public static /* synthetic */ String getFullReleaseName$default(AndroidVersion androidVersion, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.getFullReleaseName(androidVersion, bl, bl2);
    }

    @NotNull
    public static final NameDetails getReleaseNameAndDetails(@NotNull AndroidVersion $this$getReleaseNameAndDetails, boolean includeApiLevel, boolean includeCodeName) {
        String resolvedCodeName;
        Intrinsics.checkNotNullParameter((Object)$this$getReleaseNameAndDetails, (String)"<this>");
        if ($this$getReleaseNameAndDetails.getCodename() != null) {
            return new NameDetails("Android " + $this$getReleaseNameAndDetails.getCodename() + " Preview", null);
        }
        StringBuilder name = new StringBuilder();
        String releaseName = SdkVersionInfo.getReleaseVersionString($this$getReleaseNameAndDetails.getApiLevel());
        if (releaseName == null) {
            String knownCodeName = SdkVersionInfo.getCodeName($this$getReleaseNameAndDetails.getApiLevel());
            if (knownCodeName != null) {
                name.append("Android " + knownCodeName);
                if (includeApiLevel) {
                    name.append(" (API \"" + $this$getReleaseNameAndDetails.getApiStringWithoutExtension() + '\"');
                    if (!$this$getReleaseNameAndDetails.isBaseExtension()) {
                        name.append(" ext. " + $this$getReleaseNameAndDetails.getExtensionLevel());
                    }
                    name.append(")");
                }
            } else {
                name.append("Android API " + $this$getReleaseNameAndDetails.getApiStringWithoutExtension());
                if (includeApiLevel && !$this$getReleaseNameAndDetails.isBaseExtension()) {
                    name.append(" ext. " + $this$getReleaseNameAndDetails.getExtensionLevel());
                }
            }
            String string = name.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new NameDetails(string, null);
        }
        name.append("Android " + releaseName);
        String string = resolvedCodeName = includeCodeName ? SdkVersionInfo.getCodeName($this$getReleaseNameAndDetails.getApiLevel()) : null;
        if (resolvedCodeName == null && !includeApiLevel) {
            String string2 = name.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return new NameDetails(string2, null);
        }
        StringBuilder details = new StringBuilder();
        if (resolvedCodeName != null) {
            details.append('\"' + resolvedCodeName + '\"');
            if (includeApiLevel) {
                details.append("; ");
            }
        }
        if (includeApiLevel) {
            details.append("API " + $this$getReleaseNameAndDetails.getApiStringWithoutExtension());
            if (!$this$getReleaseNameAndDetails.isBaseExtension()) {
                details.append(" ext. " + $this$getReleaseNameAndDetails.getExtensionLevel());
            }
        }
        String string3 = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return new NameDetails(string3, details.toString());
    }

    public static /* synthetic */ NameDetails getReleaseNameAndDetails$default(AndroidVersion androidVersion, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.getReleaseNameAndDetails(androidVersion, bl, bl2);
    }

    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName, boolean includeReleaseName, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullApiName, (String)"<this>");
        return AndroidVersionUtils.getFullApiName$default($this$getFullApiName, includeReleaseName, includeCodeName, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName, boolean includeReleaseName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullApiName, (String)"<this>");
        return AndroidVersionUtils.getFullApiName$default($this$getFullApiName, includeReleaseName, false, false, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullApiName, (String)"<this>");
        return AndroidVersionUtils.getFullApiName$default($this$getFullApiName, false, false, false, 7, null);
    }
}

