/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.ISystemImage;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.IdDisplay;
import java.util.List;

public final class DeviceSystemImageMatcher {
    private DeviceSystemImageMatcher() {
    }

    public static boolean matches(Device device, ISystemImage image) {
        List<IdDisplay> tags = image.getTags();
        if (image.hasPlayStore() && !device.hasPlayStore()) {
            return false;
        }
        int apiLevel = image.getAndroidVersion().getApiLevel();
        if (device.getAllSoftware().stream().noneMatch(software -> software.getMinSdkLevel() <= apiLevel && apiLevel <= software.getMaxSdkLevel())) {
            return false;
        }
        if (!Device.isTablet(device) && SystemImageTags.isTabletImage(tags)) {
            return false;
        }
        String id = device.getTagId();
        if (id == null || id.equals(SystemImageTags.DEFAULT_TAG.getId())) {
            return !SystemImageTags.isWearImage(tags) && !SystemImageTags.isDesktopImage(tags) && !SystemImageTags.isTvImage(tags) && !SystemImageTags.isAutomotiveImage(tags) && !SystemImageTags.isXrHeadsetImage(tags) && !SystemImageTags.isAiGlassesImage(tags) && !tags.contains(SystemImageTags.CHROMEOS_TAG);
        }
        if (id.equals(SystemImageTags.ANDROID_TV_TAG.getId()) || id.equals(SystemImageTags.GOOGLE_TV_TAG.getId())) {
            return SystemImageTags.isTvImage(tags);
        }
        return tags.stream().map(IdDisplay::getId).anyMatch(i -> i.equals(id));
    }
}

