/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.installer;

import com.android.repository.api.Installer;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.PlatformTarget;
import java.nio.file.Path;

public class SourceInstallListener
implements PackageOperation.StatusChangeListener {
    private final AndroidSdkHandler mSdkHandler;

    public SourceInstallListener(AndroidSdkHandler sdkHandler) {
        this.mSdkHandler = sdkHandler;
    }

    public void statusChanged(PackageOperation op, ProgressIndicator progress2) throws PackageOperation.StatusChangeListenerException {
        if (op.getInstallStatus() == PackageOperation.InstallStatus.COMPLETE) {
            String targetHash = AndroidTargetHash.getPlatformHashString(((DetailsTypes.ApiDetailsType)op.getPackage().getTypeDetails()).getAndroidVersion());
            IAndroidTarget target = this.mSdkHandler.getAndroidTargetManager(progress2).getTargetFromHashString(targetHash, progress2);
            if (target instanceof PlatformTarget) {
                Path sourcePath = null;
                if (op instanceof Installer) {
                    sourcePath = op.getLocation(progress2);
                }
                ((PlatformTarget)target).setSources(sourcePath);
            }
        }
    }
}

