/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.targets;

import com.android.repository.Revision;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SystemImage
implements ISystemImage {
    private final Path mLocation;
    private final ImmutableList<IdDisplay> mTags;
    private final IdDisplay mVendor;
    private final List<String> mAbis;
    private final List<String> mTranslatedAbis;
    private final ImmutableList<Path> mSkins;
    private final AndroidVersion mAndroidVersion;
    private final RepoPackage mPackage;

    public SystemImage(Path location, Iterable<IdDisplay> tags, IdDisplay vendor, List<String> abis, List<String> translatedAbis, List<Path> skins, RepoPackage pkg) {
        Preconditions.checkArgument((!abis.isEmpty() ? 1 : 0) != 0);
        this.mLocation = location;
        this.mTags = ImmutableList.copyOf(tags);
        this.mVendor = vendor;
        this.mAbis = ImmutableList.copyOf(abis);
        this.mTranslatedAbis = ImmutableList.copyOf(translatedAbis);
        this.mSkins = ImmutableList.copyOf(skins);
        this.mPackage = pkg;
        TypeDetails details = pkg.getTypeDetails();
        assert (details instanceof DetailsTypes.ApiDetailsType);
        this.mAndroidVersion = ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
    }

    public SystemImage(Path location, IdDisplay tag, IdDisplay vendor, List<String> abi, List<String> translatedAbi, List<Path> skins, RepoPackage pkg) {
        this(location, (Iterable<IdDisplay>)ImmutableList.of((Object)tag), vendor, abi, translatedAbi, skins, pkg);
    }

    @Override
    public Path getLocation() {
        return this.mLocation;
    }

    @Override
    public List<IdDisplay> getTags() {
        return this.mTags;
    }

    @Override
    public IdDisplay getAddonVendor() {
        return this.mVendor;
    }

    @Override
    public String getPrimaryAbiType() {
        return this.mAbis.get(0);
    }

    @Override
    public List<String> getAbiTypes() {
        return this.mAbis;
    }

    @Override
    public List<String> getTranslatedAbiTypes() {
        return this.mTranslatedAbis;
    }

    @Override
    public List<Path> getSkins() {
        return this.mSkins;
    }

    @Override
    public AndroidVersion getAndroidVersion() {
        return this.mAndroidVersion;
    }

    @Override
    public RepoPackage getPackage() {
        return this.mPackage;
    }

    @Override
    public boolean obsolete() {
        return this.mPackage.obsolete();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SystemImage)) {
            return false;
        }
        SystemImage image = (SystemImage)object;
        return this.mLocation.equals(image.mLocation) && this.mTags.equals(image.mTags) && Objects.equals(this.mVendor, image.mVendor) && this.mAbis.equals(image.mAbis) && this.mTranslatedAbis.equals(image.mTranslatedAbis) && this.mSkins.equals(image.mSkins) && this.mAndroidVersion.equals((Object)image.mAndroidVersion) && this.mPackage.equals((Object)image.mPackage);
    }

    public int hashCode() {
        return Objects.hash(this.mLocation, this.mTags, this.mVendor, this.mAbis, this.mTranslatedAbis, this.mSkins, this.mAndroidVersion, this.mPackage);
    }

    public String toString() {
        return this.mPackage.getDisplayName();
    }

    @Override
    public Revision getRevision() {
        return this.mPackage.getVersion();
    }

    public static List<String> readAbisFromBuildProps(Path systemImageLocation) {
        List<String> abiList;
        PathFileWrapper buildPropFile = new PathFileWrapper(systemImageLocation.resolve("build.prop"));
        if (!buildPropFile.exists()) {
            return null;
        }
        Map<String, String> buildProp = ProjectProperties.parsePropertyFile(buildPropFile, null);
        if (buildProp == null) {
            return null;
        }
        String systemAbiList = buildProp.getOrDefault("ro.system.product.cpu.abilist", "");
        List<String> list = abiList = systemAbiList.trim().isEmpty() ? null : Arrays.asList(systemAbiList.split(","));
        if (abiList == null) {
            String cpuAbiList = buildProp.getOrDefault("ro.product.cpu.abilist", "");
            List<String> list2 = abiList = cpuAbiList.trim().isEmpty() ? null : Arrays.asList(cpuAbiList.split(","));
        }
        if (abiList == null) {
            abiList = new ArrayList<String>(2);
            String property = buildProp.get("ro.product.cpu.abi");
            if (property != null) {
                abiList.add(property);
            }
            if ((property = buildProp.get("ro.product.cpu.abi2")) != null) {
                abiList.add(property);
            }
        }
        return abiList;
    }
}

