/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.tools.idea.actions.DeviceChangeListener;
import com.android.tools.idea.actions.DeviceMenuActionKt;
import com.android.tools.idea.actions.PixelDeviceComparator;
import com.android.tools.idea.actions.ReferenceDeviceMetrics;
import com.android.tools.idea.actions.VarianceComparator;
import com.android.tools.idea.configurations.DeviceUtils;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000W\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0016\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\u001c\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0018\u0010\u001f\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010 \u001a\u00020\u0005\u001a\u0014\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010$\u001a\u00020%H\u0002\"2\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u0003 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\" \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017\"\u000e\u0010\u0018\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u0006&"}, d2={"metricsFor", "Lcom/android/tools/idea/actions/ReferenceDeviceMetrics;", "device", "Lcom/android/sdklib/devices/Device;", "isReferenceType", "", "isSameDevice", "d1", "d2", "PIXEL_DEVICE_COMPARATOR", "Ljava/util/Comparator;", "kotlin.jvm.PlatformType", "HAS_BEEN_RESIZED", "Lcom/intellij/openapi/actionSystem/DataKey;", "getHAS_BEEN_RESIZED", "()Lcom/intellij/openapi/actionSystem/DataKey;", "DEVICE_ID_TO_TOOLTIPS", "", "", "getDEVICE_ID_TO_TOOLTIPS", "()Ljava/util/Map;", "EMPTY_DEVICE_CHANGE_LISTENER", "com/android/tools/idea/actions/DeviceMenuActionKt$EMPTY_DEVICE_CHANGE_LISTENER$1", "Lcom/android/tools/idea/actions/DeviceMenuActionKt$EMPTY_DEVICE_CHANGE_LISTENER$1;", "NEXUS_NAME", "PIXEL_NAME", "GENERATION_REGEX", "Lkotlin/text/Regex;", "VARIANCE_ORDER", "", "[Ljava/lang/String;", "getDeviceLabel", "brief", "toDp", "", "", "density", "Lcom/android/resources/Density;", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nDeviceMenuAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceMenuAction.kt\ncom/android/tools/idea/actions/DeviceMenuActionKt\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,1036:1\n106#2:1037\n78#2,22:1038\n*S KotlinDebug\n*F\n+ 1 DeviceMenuAction.kt\ncom/android/tools/idea/actions/DeviceMenuActionKt\n*L\n1023#1:1037\n1023#1:1038,22\n*E\n"})
public final class DeviceMenuActionKt {
    private static final Comparator<Device> PIXEL_DEVICE_COMPARATOR;
    @NotNull
    private static final DataKey<Boolean> HAS_BEEN_RESIZED;
    @NotNull
    private static final Map<String, String> DEVICE_ID_TO_TOOLTIPS;
    @NotNull
    private static final EMPTY_DEVICE_CHANGE_LISTENER.1 EMPTY_DEVICE_CHANGE_LISTENER;
    @NotNull
    private static final String NEXUS_NAME = "Nexus";
    @NotNull
    private static final String PIXEL_NAME = "Pixel";
    @NotNull
    private static final Regex GENERATION_REGEX;
    @NotNull
    private static final String[] VARIANCE_ORDER;

    private static final ReferenceDeviceMetrics metricsFor(Device device) {
        Screen screen = device.getDefaultState().getHardware().getScreen();
        int n = screen.getXDimension();
        int n2 = screen.getYDimension();
        Density density = screen.getPixelDensity();
        Intrinsics.checkNotNullExpressionValue((Object)density, (String)"getPixelDensity(...)");
        return new ReferenceDeviceMetrics(n, n2, density, device.isScreenRound(), device.getChinSize());
    }

    private static final boolean isReferenceType(Device $this$isReferenceType) {
        return DeviceUtils.isCanonicalDevice((Device)$this$isReferenceType) || DeviceUtils.isReferenceDevice((Device)$this$isReferenceType) || Intrinsics.areEqual((Object)$this$isReferenceType.getId(), (Object)"Custom");
    }

    private static final boolean isSameDevice(Device d1, Device d2) {
        if (d1 == d2) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        boolean d1IsReference = DeviceMenuActionKt.isReferenceType(d1);
        boolean d2IsReference = DeviceMenuActionKt.isReferenceType(d2);
        return d1IsReference && d2IsReference ? Intrinsics.areEqual((Object)DeviceMenuActionKt.metricsFor(d1), (Object)DeviceMenuActionKt.metricsFor(d2)) : Intrinsics.areEqual((Object)d1.getId(), (Object)d2.getId());
    }

    @NotNull
    public static final DataKey<Boolean> getHAS_BEEN_RESIZED() {
        return HAS_BEEN_RESIZED;
    }

    @NotNull
    public static final Map<String, String> getDEVICE_ID_TO_TOOLTIPS() {
        return DEVICE_ID_TO_TOOLTIPS;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getDeviceLabel(@Nullable Device device, boolean brief) {
        if (device == null) {
            return "";
        }
        String name = device.getDisplayName();
        if (brief) {
            String string = name;
            Intrinsics.checkNotNull((Object)string);
            int nexus = StringsKt.indexOf$default((CharSequence)string, (String)NEXUS_NAME, (int)0, (boolean)false, (int)6, null);
            if (nexus != -1) {
                String string2 = name;
                Intrinsics.checkNotNull((Object)string2);
                int begin = StringsKt.indexOf$default((CharSequence)string2, (char)'(', (int)0, (boolean)false, (int)6, null);
                if (begin != -1) {
                    String string3 = name;
                    Intrinsics.checkNotNull((Object)string3);
                    int end = StringsKt.indexOf$default((CharSequence)string3, (char)')', (int)(++begin), (boolean)false, (int)4, null);
                    if (end != -1) {
                        String string4;
                        if (Intrinsics.areEqual((Object)name, (Object)"Nexus 7 (2012)")) {
                            string4 = "Nexus 7";
                        } else {
                            void $this$trim$iv;
                            string3 = name;
                            Intrinsics.checkNotNull((Object)string3);
                            String string5 = string3.substring(begin, end);
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                            string3 = string5;
                            boolean $i$f$trim = false;
                            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                            boolean $i$f$trim2 = false;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            string4 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                        }
                        return string4;
                    }
                }
            }
            String skipPrefix = "Android ";
            name = StringUtil.trimStart((String)name, (String)skipPrefix);
        }
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final double toDp(int $this$toDp, Density density) {
        return (double)$this$toDp * (double)160 / (double)density.getDpiValue();
    }

    public static final /* synthetic */ EMPTY_DEVICE_CHANGE_LISTENER.1 access$getEMPTY_DEVICE_CHANGE_LISTENER$p() {
        return EMPTY_DEVICE_CHANGE_LISTENER;
    }

    public static final /* synthetic */ boolean access$isSameDevice(Device d1, Device d2) {
        return DeviceMenuActionKt.isSameDevice(d1, d2);
    }

    public static final /* synthetic */ double access$toDp(int $receiver, Density density) {
        return DeviceMenuActionKt.toDp($receiver, density);
    }

    public static final /* synthetic */ Comparator access$getPIXEL_DEVICE_COMPARATOR$p() {
        return PIXEL_DEVICE_COMPARATOR;
    }

    public static final /* synthetic */ Regex access$getGENERATION_REGEX$p() {
        return GENERATION_REGEX;
    }

    public static final /* synthetic */ String[] access$getVARIANCE_ORDER$p() {
        return VARIANCE_ORDER;
    }

    static {
        Comparator<String> comparator = VarianceComparator.INSTANCE.reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        PIXEL_DEVICE_COMPARATOR = new PixelDeviceComparator(comparator).reversed();
        HAS_BEEN_RESIZED = DataKey.Companion.create("has_been_resized");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"_device_class_phone", (Object)"This reference device uses the COMPACT width size class, which represents 99% of Android phones in portrait orientation."), TuplesKt.to((Object)"_device_class_foldable", (Object)"This reference device uses the MEDIUM width size class, which represents foldables in unfolded portrait orientation, or 94% of all tablets in portrait orientation."), TuplesKt.to((Object)"_device_class_tablet", (Object)"This reference device uses the EXPANDED width size class, which represents 97% of Android tablets in landscape orientation."), TuplesKt.to((Object)"_device_class_desktop", (Object)"This reference device uses the EXPANDED width size class, which represents 97% of Android desktops in landscape orientation.")};
        DEVICE_ID_TO_TOOLTIPS = MapsKt.mapOf((Pair[])objectArray);
        EMPTY_DEVICE_CHANGE_LISTENER = new DeviceChangeListener(){

            public void onDeviceChanged(Device oldDevice, Device newDevice) {
                DeviceChangeListener.super.onDeviceChanged(oldDevice, newDevice);
            }

            public void onRevertToOriginal() {
                DeviceChangeListener.super.onRevertToOriginal();
            }
        };
        GENERATION_REGEX = new Regex("\\d+");
        objectArray = new String[]{"", "XL", "a", "a XL"};
        VARIANCE_ORDER = objectArray;
    }
}

