/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.configurations.AdaptiveIconShape;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.actions.ConfigurationAction;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.google.common.collect.Iterables;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ShapeMenuAction
extends DropDownAction {
    public ShapeMenuAction() {
        super("Adaptive Icon Shape", "Adaptive Icon Shape", null);
    }

    protected boolean updateActions(@NotNull DataContext context) {
        this.removeAll();
        Collection configurations = (Collection)context.getData(DesignerDataKeys.CONFIGURATIONS);
        if (configurations == null) {
            return true;
        }
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        AdaptiveIconShape currentShape = configuration != null ? configuration.getAdaptiveShape() : AdaptiveIconShape.getDefaultShape();
        for (AdaptiveIconShape shape : AdaptiveIconShape.values()) {
            this.add(new SetShapeAction(shape, shape == currentShape));
        }
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Collection configurations = (Collection)e.getData(DesignerDataKeys.CONFIGURATIONS);
        if (configurations == null) {
            return;
        }
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        AdaptiveIconShape shape = configuration != null ? configuration.getAdaptiveShape() : AdaptiveIconShape.getDefaultShape();
        e.getPresentation().setText(shape.getName());
        e.getPresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static class SetShapeAction
    extends ConfigurationAction {
        private final AdaptiveIconShape myShape;
        private final boolean myIsCurrentShape;

        private SetShapeAction(@NotNull AdaptiveIconShape shape, boolean isCurrentShape) {
            super(shape.getName());
            this.myShape = shape;
            this.myIsCurrentShape = isCurrentShape;
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.myIsCurrentShape);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setAdaptiveShape(this.myShape);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

