/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.actions.ConfigurationAction;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.layoutlib.AndroidTargets;
import com.android.tools.module.AndroidModuleInfo;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.google.common.collect.Iterables;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TargetMenuAction
extends DropDownAction {
    private static final int SHOW_FROM_API_LEVEL = 7;
    private final boolean myUseCompatibilityTarget;

    public TargetMenuAction(boolean useCompatibilityTarget) {
        super("API Version for Preview", "API Version for Preview", StudioIcons.LayoutEditor.Toolbar.ANDROID_API);
        this.myUseCompatibilityTarget = useCompatibilityTarget;
    }

    public TargetMenuAction() {
        this(false);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean visible;
        e.getPresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        Collection configurations = (Collection)e.getData(DesignerDataKeys.CONFIGURATIONS);
        if (configurations == null) {
            return;
        }
        Presentation presentation = e.getPresentation();
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        boolean bl = visible = configuration != null;
        if (visible) {
            String brief;
            int minSdk = this.getMinSdkVersion(configuration);
            IAndroidTarget compatibleTarget = ConfigurationManager.getFromConfiguration((Configuration)configuration).getTarget(minSdk);
            IAndroidTarget currentTarget = configuration.getTarget();
            if (compatibleTarget != null && (currentTarget == null || compatibleTarget.getVersion().compareTo(currentTarget.getVersion()) > 0)) {
                configuration.setTarget(compatibleTarget);
                currentTarget = compatibleTarget;
            }
            if (!(brief = TargetMenuAction.getRenderingTargetLabel(currentTarget, true)).equals(presentation.getText())) {
                presentation.setText(brief, false);
            }
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
        presentation.putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private int getMinSdkVersion(@NotNull Configuration configuration) {
        AndroidModuleInfo moduleInfo = configuration.getConfigModule().getAndroidModuleInfo();
        if (moduleInfo != null) {
            return moduleInfo.getMinSdkVersion().getFeatureLevel();
        }
        return -1;
    }

    @NotNull
    private List<SetTargetAction> getCompatibilitySetTargetActions(@NotNull Configuration configuration, boolean defaultSelectable) {
        IAndroidTarget highestTarget = configuration.getSettings().getHighestApiTarget();
        assert (highestTarget != null);
        ArrayList<SetTargetAction> actions2 = new ArrayList<SetTargetAction>();
        int highestApiLevel = highestTarget.getVersion().getFeatureLevel();
        int minApi = Math.max(this.getMinSdkVersion(configuration), 7);
        for (int apiLevel = highestApiLevel; apiLevel >= minApi; --apiLevel) {
            CompatibilityRenderTarget target = new CompatibilityRenderTarget(highestTarget, apiLevel, null);
            actions2.add(new SetTargetAction(target.getVersionName(), (IAndroidTarget)target, defaultSelectable));
        }
        return this.deduplicateSetTargetAction(actions2);
    }

    @NotNull
    private List<SetTargetAction> getRealSetTargetActions(@NotNull Configuration configuration, boolean defaultSelectable) {
        IAndroidTarget[] targets = configuration.getSettings().getTargets();
        ArrayList<SetTargetAction> actions2 = new ArrayList<SetTargetAction>();
        boolean haveRecent = false;
        int minSdk = this.getMinSdkVersion(configuration);
        for (int i = targets.length - 1; i >= 0; --i) {
            AndroidVersion version;
            IAndroidTarget target = targets[i];
            if (!AndroidTargets.isLayoutLibTarget((IAndroidTarget)target) || (version = target.getVersion()).getFeatureLevel() < minSdk) continue;
            if (version.getAndroidApiLevel().getMajorVersion() >= 7) {
                haveRecent = true;
            } else if (haveRecent) break;
            String title = TargetMenuAction.getRenderingTargetLabel(target, true);
            actions2.add(new SetTargetAction(title, target, defaultSelectable));
        }
        return this.deduplicateSetTargetAction(actions2);
    }

    @NotNull
    private List<SetTargetAction> deduplicateSetTargetAction(@NotNull List<SetTargetAction> targetActions) {
        LinkedHashMap<String, SetTargetAction> titleToActionMap = new LinkedHashMap<String, SetTargetAction>();
        for (SetTargetAction targetAction : targetActions) {
            String title = targetAction.myTitle;
            if (titleToActionMap.containsKey(title)) {
                SetTargetAction oldAction = (SetTargetAction)((Object)titleToActionMap.get(title));
                int oldRevision = oldAction.myTarget.getRevision();
                int newRevision = targetAction.myTarget.getRevision();
                AndroidVersion oldVersion = oldAction.myTarget.getVersion();
                AndroidVersion newVersion = targetAction.myTarget.getVersion();
                if (newVersion.compareTo(oldVersion) <= 0 && (newVersion.compareTo(oldVersion) != 0 || newRevision <= oldRevision)) continue;
                titleToActionMap.replace(title, targetAction);
                continue;
            }
            titleToActionMap.put(title, targetAction);
        }
        return titleToActionMap.values().stream().toList();
    }

    protected boolean updateActions(@NotNull DataContext context) {
        this.removeAll();
        Collection configurations = (Collection)context.getData(DesignerDataKeys.CONFIGURATIONS);
        if (configurations == null) {
            return true;
        }
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        if (configuration == null) {
            return true;
        }
        ConfigurationManager settings = ConfigurationManager.getFromConfiguration((Configuration)configuration);
        this.add(new TogglePickBestAction(settings));
        this.addSeparator();
        boolean isPickBest = settings.getStateManager().getProjectState().isPickTarget();
        List<SetTargetAction> actions2 = this.myUseCompatibilityTarget && settings.getHighestApiTarget() != null ? this.getCompatibilitySetTargetActions(configuration, isPickBest) : this.getRealSetTargetActions(configuration, isPickBest);
        this.addAll(actions2);
        return true;
    }

    public static String getRenderingTargetLabel(@Nullable IAndroidTarget target, boolean brief) {
        if (target == null) {
            return "<null>";
        }
        AndroidVersion version = target.getVersion();
        int majorVersion = version.getAndroidApiLevel().getMajorVersion();
        if (brief) {
            if (target.isPlatform()) {
                String codename = version.getCodename();
                if (codename != null && !codename.isEmpty()) {
                    if (codename.length() <= 3) {
                        return codename;
                    }
                    return Character.toString(codename.charAt(0));
                }
                return Integer.toString(majorVersion);
            }
            return target.getName() + ":" + majorVersion;
        }
        return String.format(Locale.US, "API %1$d: %2$s", majorVersion, target.getShortClasspathName());
    }

    @VisibleForTesting
    static class SetTargetAction
    extends ConfigurationAction {
        @VisibleForTesting
        final IAndroidTarget myTarget;
        private final String myTitle;
        private final boolean myDefaultSelectable;

        public SetTargetAction(@NotNull String title, @NotNull IAndroidTarget target, boolean defaultSelectable) {
            super(title);
            this.myTarget = target;
            this.myTitle = title;
            this.myDefaultSelectable = defaultSelectable;
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (commit) {
                this.setProjectWideTarget(configuration);
            } else {
                configuration.setTarget(this.myTarget);
            }
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Collection configurations = (Collection)e.getData(DesignerDataKeys.CONFIGURATIONS);
            if (configurations == null) {
                return;
            }
            Configuration config = (Configuration)Iterables.getFirst((Iterable)configurations, null);
            if (config != null) {
                ConfigurationManager configManager = ConfigurationManager.getFromConfiguration((Configuration)config);
                configManager.getStateManager().getProjectState().setPickTarget(false);
            }
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)true);
            super.actionPerformed(e);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Collection configurations = (Collection)e.getData(DesignerDataKeys.CONFIGURATIONS);
            if (configurations == null) {
                return;
            }
            Configuration config = (Configuration)Iterables.getFirst((Iterable)configurations, null);
            if (config == null) {
                return;
            }
            IAndroidTarget current = config.getTarget();
            boolean selected = !this.myDefaultSelectable && current != null && this.myTarget.getVersion().equals((Object)current.getVersion());
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)selected);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        @Override
        protected void pickedBetterMatch(@NotNull Configuration configuration, @NotNull VirtualFile file2, @NotNull VirtualFile old) {
            super.pickedBetterMatch(configuration, file2, old);
            this.setProjectWideTarget(configuration);
        }

        private void setProjectWideTarget(@NotNull Configuration configuration) {
            configuration.getSettings().setTarget(this.myTarget);
        }
    }

    private static class TogglePickBestAction
    extends AnAction
    implements Toggleable {
        private final ConfigurationManager myManager;

        TogglePickBestAction(ConfigurationManager manager) {
            super("Automatically Pick Best");
            this.myManager = manager;
            if (this.myManager.getStateManager().getProjectState().isPickTarget()) {
                this.getTemplatePresentation().putClientProperty("selected", (Object)true);
            }
        }

        private boolean isSelected() {
            return this.myManager.getStateManager().getProjectState().isPickTarget();
        }

        private void setSelected(boolean state) {
            this.myManager.getStateManager().getProjectState().setPickTarget(state);
            if (state) {
                this.myManager.setTarget(null);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            this.setSelected(!this.isSelected());
        }

        public void update(@NotNull AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            Toggleable.setSelected((Presentation)presentation, (boolean)this.isSelected());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

