/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.configurations.Configuration;
import com.android.tools.idea.actions.ThemeSelectionPanel;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.DoubleClickListener;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeSelectionDialog
extends DialogWrapper {
    @NotNull
    private final ThemeSelectionPanel myPanel;

    public ThemeSelectionDialog(@NotNull Configuration configuration) {
        this(configuration, Collections.emptySet());
    }

    public ThemeSelectionDialog(@NotNull Configuration configuration, @NotNull Set<String> excludedThemes) {
        super(ConfigurationManager.getFromConfiguration((Configuration)configuration).getProject());
        this.myPanel = new ThemeSelectionPanel(this, configuration, excludedThemes);
        this.setTitle("Select Theme");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel contentPanel = this.myPanel.getContentPanel();
        contentPanel.setPreferredSize((Dimension)JBUI.size((int)800, (int)500));
        this.myPanel.installDoubleClickListener(new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (ThemeSelectionDialog.this.getOKAction().isEnabled()) {
                    ThemeSelectionDialog.this.close(0);
                    return true;
                }
                return false;
            }
        });
        return contentPanel;
    }

    protected void doOKAction() {
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "AndroidThemeDialog";
    }

    @Nullable
    public String getTheme() {
        return this.myPanel.getTheme();
    }

    public void checkValidation() {
        this.initValidation();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String theme = this.myPanel.getTheme();
        if (theme == null) {
            return new ValidationInfo("Select a theme");
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }
}

