/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001aE\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\u0016\u001a\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0019\u001a\u00020\u0010\u001a6\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f0\u0001\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\b\u001c0\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u001a\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0019\u001a\u00020\u0010\u001a6\u0010\u001f\u001a\u0012\u0012\u000e\u0012\f0\u0001\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\b\u001c0\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u001a\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0019\u001a\u00020\u0010\u001a6\u0010!\u001a\u0012\u0012\u000e\u0012\f0\u0001\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\b\u001c0\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u001a\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0019\u001a\u00020\u0010\u001a6\u0010#\u001a\u0012\u0012\u000e\u0012\f0\u0001\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\b\u001c0\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u001a.\u0010$\u001a\u0010\u0012\f\u0012\n %*\u0004\u0018\u00010\u00010\u00010\u00182\u0006\u0010&\u001a\u00020'2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0007\u001a\u0016\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'2\u0006\u0010\t\u001a\u00020\u0001\u001a\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0002\u001a,\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u000e\b\u0002\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0002\u001a>\u0010.\u001a\u0012\u0012\u000e\u0012\f0\u0001\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\b\u001c0\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"ANDROID_THEME", "", "ANDROID_THEME_PREFIX", "PROJECT_THEME_PREFIX", "PROJECT_THEME", "RECENTLY_USED_THEMES_PROPERTY", "MAX_RECENTLY_USED_THEMES", "", "getPreferredThemeName", "theme", "createFilter", "Lkotlin/Function1;", "Lcom/android/tools/idea/editors/theme/datamodels/ConfiguredThemeEditorStyle;", "", "Lcom/android/tools/idea/configurations/ThemeStyleFilter;", "resolver", "Lcom/android/tools/idea/editors/theme/ThemeResolver;", "excludedNames", "", "baseThemes", "", "Lcom/android/ide/common/rendering/api/StyleResourceValue;", "(Lcom/android/tools/idea/editors/theme/ThemeResolver;Ljava/util/Set;[Lcom/android/ide/common/rendering/api/StyleResourceValue;)Lkotlin/jvm/functions/Function1;", "getFrameworkThemes", "", "themeResolver", "getFrameworkThemeNames", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "filter", "getProjectThemes", "getProjectThemeNames", "getLibraryThemes", "getLibraryThemeNames", "getRecommendedThemes", "getRecommendedThemeNames", "getRecentlyUsedThemes", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "addRecentlyUsedTheme", "", "getPublicThemes", "themes", "getFilteredByPrefixSortedByName", "excludedPrefixes", "getFilteredNames", "intellij.android.designer"})
@JvmName(name="ThemeUtils")
@SourceDebugExtension(value={"SMAP\nThemeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeUtils.kt\ncom/android/tools/idea/actions/ThemeUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n774#2:136\n865#2,2:137\n774#2:139\n865#2:140\n2746#2,3:141\n866#2:144\n1056#2:145\n774#2:146\n865#2,2:147\n1563#2:149\n1634#2,3:150\n*S KotlinDebug\n*F\n+ 1 ThemeUtils.kt\ncom/android/tools/idea/actions/ThemeUtils\n*L\n118#1:136\n118#1:137,2\n129#1:139\n129#1:140\n129#1:141,3\n129#1:144\n130#1:145\n134#1:146\n134#1:147,2\n134#1:149\n134#1:150,3\n*E\n"})
public final class ThemeUtils {
    @NotNull
    private static final String ANDROID_THEME = "android:Theme";
    @NotNull
    private static final String ANDROID_THEME_PREFIX = "android:Theme.";
    @NotNull
    private static final String PROJECT_THEME_PREFIX = "Theme.";
    @NotNull
    private static final String PROJECT_THEME = "Theme";
    @NotNull
    private static final String RECENTLY_USED_THEMES_PROPERTY = "android.recentlyUsedThemes";
    private static final int MAX_RECENTLY_USED_THEMES = 5;

    @NotNull
    public static final String getPreferredThemeName(@NotNull String theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        if (Intrinsics.areEqual((Object)theme, (Object)ANDROID_THEME) || Intrinsics.areEqual((Object)theme, (Object)PROJECT_THEME)) {
            return PROJECT_THEME;
        }
        return StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)theme, (CharSequence)ANDROID_THEME_PREFIX), (CharSequence)PROJECT_THEME_PREFIX), (CharSequence)"@style/");
    }

    @NotNull
    public static final Function1<ConfiguredThemeEditorStyle, Boolean> createFilter(@NotNull ThemeResolver resolver, @NotNull Set<String> excludedNames, StyleResourceValue ... baseThemes) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter(excludedNames, (String)"excludedNames");
        Intrinsics.checkNotNullParameter((Object)baseThemes, (String)"baseThemes");
        if (baseThemes.length == 0) {
            return arg_0 -> ThemeUtils.createFilter$lambda$0(excludedNames, arg_0);
        }
        return arg_0 -> ThemeUtils.createFilter$lambda$1(excludedNames, resolver, baseThemes, arg_0);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getFrameworkThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        ImmutableList immutableList = themeResolver.getFrameworkThemes();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getFrameworkThemes(...)");
        return ThemeUtils.getFilteredByPrefixSortedByName$default(ThemeUtils.getPublicThemes((List)immutableList), null, 2, null);
    }

    @NotNull
    public static final List<String> getFrameworkThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return ThemeUtils.getFilteredNames(ThemeUtils.getFrameworkThemes(themeResolver), filter2);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getProjectThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        ImmutableList immutableList = themeResolver.getLocalThemes();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getLocalThemes(...)");
        return ThemeUtils.getFilteredByPrefixSortedByName$default(ThemeUtils.getPublicThemes((List)immutableList), null, 2, null);
    }

    @NotNull
    public static final List<String> getProjectThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return ThemeUtils.getFilteredNames(ThemeUtils.getProjectThemes(themeResolver), filter2);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getLibraryThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        ImmutableList immutableList = themeResolver.getExternalLibraryThemes();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getExternalLibraryThemes(...)");
        Object[] objectArray = new String[]{"Base.", "Platform."};
        return ThemeUtils.getFilteredByPrefixSortedByName(ThemeUtils.getPublicThemes((List)immutableList), SetsKt.setOf((Object[])objectArray));
    }

    @NotNull
    public static final List<String> getLibraryThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        ImmutableList immutableList = themeResolver.getExternalLibraryThemes();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getExternalLibraryThemes(...)");
        return ThemeUtils.getFilteredNames(ThemeUtils.getPublicThemes((List)immutableList), filter2);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getRecommendedThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        List list = themeResolver.getRecommendedThemes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRecommendedThemes(...)");
        List recommendedThemes = list;
        Object[] objectArray = new List[]{ThemeUtils.getLibraryThemes(themeResolver), ThemeUtils.getFrameworkThemes(themeResolver)};
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), arg_0 -> ThemeUtils.getRecommendedThemes$lambda$2(recommendedThemes, arg_0)));
    }

    @NotNull
    public static final List<String> getRecommendedThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return ThemeUtils.getFilteredNames(ThemeUtils.getRecommendedThemes(themeResolver), filter2);
    }

    @JvmOverloads
    @NotNull
    public static final List<String> getRecentlyUsedThemes(@NotNull Project project, @NotNull Set<String> excludedNames) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(excludedNames, (String)"excludedNames");
        List list2 = PropertiesComponent.getInstance((Project)project).getList(RECENTLY_USED_THEMES_PROPERTY);
        return list2 != null && (list = CollectionsKt.minus((Iterable)list2, (Iterable)excludedNames)) != null ? list : CollectionsKt.emptyList();
    }

    public static /* synthetic */ List getRecentlyUsedThemes$default(Project project, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getRecentlyUsedThemes(project, set);
    }

    public static final void addRecentlyUsedTheme(@NotNull Project project, @NotNull String theme) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Collection collection = PropertiesComponent.getInstance((Project)project).getList(RECENTLY_USED_THEMES_PROPERTY);
        if (collection == null || (collection = CollectionsKt.toSet((Iterable)collection)) == null) {
            collection = SetsKt.emptySet();
        }
        Collection old = collection;
        List list = CollectionsKt.take((Iterable)SetsKt.plus((Set)SetsKt.setOf((Object)theme), (Iterable)old), (int)5);
        PropertiesComponent.getInstance((Project)project).setList(RECENTLY_USED_THEMES_PROPERTY, (Collection)list);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConfiguredThemeEditorStyle> getPublicThemes(List<? extends ConfiguredThemeEditorStyle> themes) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = themes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConfiguredThemeEditorStyle it = (ConfiguredThemeEditorStyle)element$iv$iv;
            boolean bl = false;
            if (!it.isPublic()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConfiguredThemeEditorStyle> getFilteredByPrefixSortedByName(List<? extends ConfiguredThemeEditorStyle> themes, Set<String> excludedPrefixes) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = themes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                ConfiguredThemeEditorStyle theme = (ConfiguredThemeEditorStyle)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = excludedPrefixes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String prefix = (String)element$iv;
                        boolean bl3 = false;
                        String string = theme.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (!StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ConfiguredThemeEditorStyle it = (ConfiguredThemeEditorStyle)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getQualifiedName());
                it = (ConfiguredThemeEditorStyle)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getQualifiedName())));
            }
        });
    }

    static /* synthetic */ List getFilteredByPrefixSortedByName$default(List list, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getFilteredByPrefixSortedByName(list, set);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getFilteredNames(List<? extends ConfiguredThemeEditorStyle> themes, Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = themes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filter2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConfiguredThemeEditorStyle configuredThemeEditorStyle = (ConfiguredThemeEditorStyle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getQualifiedName());
        }
        return (List)destination$iv$iv;
    }

    @JvmOverloads
    @NotNull
    public static final List<String> getRecentlyUsedThemes(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ThemeUtils.getRecentlyUsedThemes$default(project, null, 2, null);
    }

    private static final boolean createFilter$lambda$0(Set $excludedNames, ConfiguredThemeEditorStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return !$excludedNames.contains(style.getQualifiedName());
    }

    private static final boolean createFilter$lambda$1(Set $excludedNames, ThemeResolver $resolver, StyleResourceValue[] $baseThemes, ConfiguredThemeEditorStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return !$excludedNames.contains(style.getQualifiedName()) && $resolver.themeIsChildOfAny((StyleResourceValue)style.getStyleResourceValue(), Arrays.copyOf($baseThemes, $baseThemes.length));
    }

    private static final boolean getRecommendedThemes$lambda$2(List $recommendedThemes, ConfiguredThemeEditorStyle it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $recommendedThemes.contains(it.getStyleReference());
    }
}

