/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.NlModelUpdaterInterface;
import com.android.tools.idea.common.model.TagSnapshotTreeNode;
import com.android.tools.idea.compose.preview.ComposeViewInfo;
import com.android.tools.idea.compose.preview.ComposeViewInfoParserKt;
import com.android.tools.idea.compose.preview.PxBounds;
import com.android.tools.idea.compose.preview.navigation.PreviewNavigationKt;
import com.android.tools.idea.rendering.parsers.PsiXmlTag;
import com.android.tools.idea.uibuilder.model.NlComponentRegistrar;
import com.android.tools.idea.uibuilder.scene.AccessibilityViewInfoParserKt;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.Navigatable;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0016JD\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/common/model/AccessibilityModelUpdater;", "Lcom/android/tools/idea/common/model/NlModelUpdaterInterface;", "<init>", "()V", "updateFromTagSnapshot", "", "model", "Lcom/android/tools/idea/common/model/NlModel;", "newRoot", "Lcom/intellij/psi/xml/XmlTag;", "roots", "", "Lcom/android/tools/idea/common/model/TagSnapshotTreeNode;", "updateFromViewInfo", "viewInfos", "Lcom/android/ide/common/rendering/api/ViewInfo;", "createTree", "root", "Lcom/android/tools/idea/common/model/NlComponent;", "composeViewInfos", "Lcom/android/tools/idea/compose/preview/ComposeViewInfo;", "rootGlobalX", "", "rootGlobalY", "intellij.android.compose-designer"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAccessibilityModelUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibilityModelUpdater.kt\ncom/android/tools/idea/common/model/AccessibilityModelUpdater\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1#2:105\n1869#3,2:106\n1869#3,2:108\n1969#3,14:110\n*S KotlinDebug\n*F\n+ 1 AccessibilityModelUpdater.kt\ncom/android/tools/idea/common/model/AccessibilityModelUpdater\n*L\n54#1:106,2\n58#1:108,2\n88#1:110,14\n*E\n"})
public final class AccessibilityModelUpdater
implements NlModelUpdaterInterface {
    public static final int $stable;

    @Override
    public void updateFromTagSnapshot(@NotNull NlModel model, @Nullable XmlTag newRoot, @NotNull List<? extends TagSnapshotTreeNode> roots) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        NlComponent currentRootComponent = (NlComponent)CollectionsKt.firstOrNull((List)((List)model.getTreeReader().getComponents()));
        if (newRoot != null) {
            XmlTag currentRoot;
            NlComponent nlComponent = currentRootComponent;
            if (nlComponent != null) {
                NlComponent it = nlComponent;
                boolean bl = false;
                v1 = (XmlTag)ActionsKt.runReadAction(() -> AccessibilityModelUpdater.updateFromTagSnapshot$lambda$1$lambda$0(it));
            } else {
                v1 = currentRoot = null;
            }
            if (!Intrinsics.areEqual((Object)newRoot, currentRoot)) {
                XmlTag it = newRoot;
                boolean bl = false;
                currentRootComponent = model.createComponent(it);
            }
        }
        model.getTreeReader().setRootComponent(currentRootComponent);
    }

    @Override
    public void updateFromViewInfo(@NotNull NlModel model, @NotNull List<? extends ViewInfo> viewInfos) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(viewInfos, (String)"viewInfos");
        Map tagToViewInfo = new LinkedHashMap();
        Iterable $this$forEach$iv = viewInfos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiXmlTag tag;
            it = (ViewInfo)element$iv;
            boolean bl = false;
            Object object = it.getCookie();
            TagSnapshot tagSnapshot = object instanceof TagSnapshot ? (TagSnapshot)object : null;
            Object object2 = tagSnapshot != null ? tagSnapshot.tag : null;
            if ((object2 instanceof PsiXmlTag ? (PsiXmlTag)object2 : null) == null) continue;
            tag = tag;
            tagToViewInfo.put(tag.getPsiXmlTag(), it);
        }
        $this$forEach$iv = (Iterable)model.getTreeReader().getComponents();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (NlComponent)element$iv;
            boolean bl = false;
            XmlTag tag = (XmlTag)ActionsKt.runReadAction(() -> AccessibilityModelUpdater.updateFromViewInfo$lambda$5$lambda$4((NlComponent)it));
            ViewInfo viewInfo = (ViewInfo)tagToViewInfo.get(tag);
            ViewInfo viewInfo2 = viewInfo;
            if (viewInfo2 == null) {
                continue;
            }
            ((NlComponent)it).setAccessibilityId(AccessibilityViewInfoParserKt.getAccessibilitySourceId(viewInfo2));
            Logger logger = Logger.getInstance(AccessibilityModelUpdater.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            List<ComposeViewInfo> composeViewInfos = ComposeViewInfoParserKt.parseViewInfo(viewInfo, logger);
            Intrinsics.checkNotNull((Object)it);
            List list = viewInfo.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            this.createTree((NlComponent)it, composeViewInfos, list, model, viewInfo.getLeft(), viewInfo.getTop());
        }
    }

    private final void createTree(NlComponent root, List<ComposeViewInfo> composeViewInfos, List<? extends ViewInfo> viewInfos, NlModel model, int rootGlobalX, int rootGlobalY) {
        for (ViewInfo viewInfo : viewInfos) {
            Navigatable navigatable;
            NlComponent childComponent = new NlComponent(model, AccessibilityViewInfoParserKt.getAccessibilitySourceId(viewInfo));
            NlComponentRegistrar.INSTANCE.accept(childComponent);
            root.addChild(childComponent);
            int globalLeft = rootGlobalX + viewInfo.getLeft();
            int globalTop = rootGlobalY + viewInfo.getTop();
            int midPointX = globalLeft + (viewInfo.getRight() - viewInfo.getLeft()) / 2;
            int midPointY = globalTop + (viewInfo.getBottom() - viewInfo.getTop()) / 2;
            if (!((Collection)composeViewInfos).isEmpty()) {
                Object t;
                Iterable $this$maxBy$iv = composeViewInfos;
                boolean $i$f$maxByOrThrow = false;
                Iterator iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t = maxElem$iv;
                } else {
                    ComposeViewInfo it = (ComposeViewInfo)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getBounds().getWidth() * it.getBounds().getHeight();
                    do {
                        Object e$iv = iterator$iv.next();
                        ComposeViewInfo it2 = (ComposeViewInfo)e$iv;
                        boolean bl2 = false;
                        int v$iv = it2.getBounds().getWidth() * it2.getBounds().getHeight();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t = maxElem$iv;
                }
                PxBounds globalBounds = ((ComposeViewInfo)t).getBounds();
                midPointX = Math.min(midPointX, globalBounds.getRight());
                midPointY = Math.min(midPointY, globalBounds.getBottom());
            }
            if ((navigatable = PreviewNavigationKt.findNavigatableComponentHit$default(model.getModule(), composeViewInfos, midPointX, midPointY, null, 16, null)) != null) {
                childComponent.setNavigatable(navigatable);
            }
            List list = viewInfo.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            this.createTree(childComponent, composeViewInfos, list, model, globalLeft, globalTop);
        }
    }

    private static final XmlTag updateFromTagSnapshot$lambda$1$lambda$0(NlComponent $it) {
        return $it.getTag();
    }

    private static final XmlTag updateFromViewInfo$lambda$5$lambda$4(NlComponent $it) {
        return $it.getTag();
    }
}

