/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.NlModelUpdaterInterface;
import com.android.tools.idea.common.model.TagSnapshotTreeNode;
import com.android.tools.idea.rendering.parsers.PsiXmlTag;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultModelUpdater
implements NlModelUpdaterInterface {
    private void recordComponentMapping(@NotNull XmlTag tag, @NotNull NlComponent component, ModelUpdaterData data) {
        XmlTag prevTag = data.myComponentToTagMap.get(component);
        if (prevTag != null) {
            data.myTagToComponentMap.remove(prevTag);
        }
        data.myComponentToTagMap.put(component, tag);
        data.myTagToComponentMap.put(tag, component);
    }

    @Override
    @VisibleForTesting
    public void updateFromTagSnapshot(@NotNull NlModel model, @Nullable XmlTag newRoot, @NotNull List<? extends TagSnapshotTreeNode> roots) {
        ModelUpdaterData data = new ModelUpdaterData();
        data.myModel = model;
        if (newRoot == null) {
            data.myModel.getTreeReader().setRootComponent(null);
            return;
        }
        data.myModel.getTreeReader().setRootComponent((NlComponent)ApplicationManager.getApplication().runReadAction(() -> {
            if (!newRoot.isValid()) {
                return null;
            }
            for (TagSnapshotTreeNode tagSnapshotTreeNode : roots) {
                DefaultModelUpdater.gatherTagsAndSnapshots(tagSnapshotTreeNode, data.myTagToSnapshot);
            }
            this.mapOldToNew(newRoot, data);
            for (Map.Entry entry : data.myTagToComponentMap.entrySet()) {
                XmlTag tag = (XmlTag)entry.getKey();
                NlComponent component = (NlComponent)entry.getValue();
                if (component.getTagName().equals(tag.getName())) continue;
                data.myTagToComponentMap.clear();
                data.myComponentToTagMap.clear();
                break;
            }
            return this.createTree(newRoot, data);
        }));
        for (NlComponent nlComponent : data.myTagToComponentMap.values()) {
            nlComponent.setSnapshot(null);
        }
        for (TagSnapshotTreeNode tagSnapshotTreeNode : roots) {
            this.updateHierarchy(tagSnapshotTreeNode, data);
        }
    }

    @Override
    public void updateFromViewInfo(@NotNull NlModel model, @NotNull List<? extends ViewInfo> viewInfos) {
    }

    private void mapOldToNew(@NotNull XmlTag newRootTag, ModelUpdaterData data) {
        XmlTag oldTag;
        TagSnapshot snapshot;
        NlComponent component;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        for (NlComponent component2 : data.myModel.getTreeReader().getComponents()) {
            this.gatherTagsAndSnapshots(component2, data);
        }
        ArrayList<XmlTag> missing = new ArrayList<XmlTag>();
        Set remaining = Sets.newIdentityHashSet();
        remaining.addAll(data.myTagToComponentMap.keySet());
        DefaultModelUpdater.checkMissing(newRootTag, remaining, missing);
        if (missing.isEmpty()) {
            return;
        }
        if (remaining.isEmpty()) {
            return;
        }
        HashMap oldIds = Maps.newHashMap();
        for (Map.Entry<TagSnapshot, NlComponent> entry : data.mySnapshotToComponent.entrySet()) {
            String id;
            TagSnapshot snapshot2 = entry.getKey();
            if (snapshot2 == null || (id = snapshot2.getAttribute("id", "http://schemas.android.com/apk/res/android")) == null) continue;
            oldIds.put(id, entry.getValue());
        }
        ListIterator missingIterator = missing.listIterator();
        while (missingIterator.hasNext()) {
            XmlTag tag = (XmlTag)missingIterator.next();
            String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
            if (id == null || (component = (NlComponent)oldIds.get(id)) == null) continue;
            this.recordComponentMapping(tag, component, data);
            remaining.remove(component.getTagDeprecated());
            missingIterator.remove();
        }
        if (missing.isEmpty() || remaining.isEmpty()) {
            return;
        }
        ArrayListMultimap snapshotIds = ArrayListMultimap.create();
        for (XmlTag old : remaining) {
            NlComponent component3 = data.myTagToComponentMap.get(old);
            if (component3 == null || (snapshot = component3.getSnapshot()) == null) continue;
            snapshotIds.put((Object)snapshot.getSignature(), (Object)snapshot);
        }
        missingIterator = missing.listIterator();
        while (missingIterator.hasNext()) {
            TagSnapshot first;
            NlComponent component4;
            long signature;
            Collection snapshots;
            XmlTag tag = (XmlTag)missingIterator.next();
            TagSnapshot snapshot3 = data.myTagToSnapshot.get(tag);
            if (snapshot3 == null || (snapshots = snapshotIds.get((Object)(signature = snapshot3.getSignature()))).isEmpty() || (component4 = data.mySnapshotToComponent.get(first = (TagSnapshot)snapshots.iterator().next())) == null) continue;
            this.recordComponentMapping(tag, component4, data);
            remaining.remove(component4.getTagDeprecated());
            missingIterator.remove();
        }
        if (missing.size() == 1 && remaining.size() == 1 && (component = data.myTagToComponentMap.get(oldTag = (XmlTag)remaining.iterator().next())) != null) {
            XmlTag newTag = (XmlTag)missing.get(0);
            snapshot = component.getSnapshot();
            if (snapshot != null && snapshot.tagName.equals(newTag.getName())) {
                this.recordComponentMapping(newTag, component, data);
            }
        }
    }

    private static void checkMissing(XmlTag tag, Set<XmlTag> remaining, List<XmlTag> missing) {
        boolean found = remaining.remove(tag);
        if (!found) {
            missing.add(tag);
        }
        for (XmlTag child : tag.getSubTags()) {
            DefaultModelUpdater.checkMissing(child, remaining, missing);
        }
    }

    private void gatherTagsAndSnapshots(@NotNull NlComponent component, ModelUpdaterData data) {
        XmlTag tag = component.getTagDeprecated();
        this.recordComponentMapping(tag, component, data);
        data.mySnapshotToComponent.put(component.getSnapshot(), component);
        for (NlComponent child : component.getChildren()) {
            this.gatherTagsAndSnapshots(child, data);
        }
    }

    private static void gatherTagsAndSnapshots(@NotNull TagSnapshotTreeNode node, @NotNull Map<XmlTag, TagSnapshot> map2) {
        RenderXmlTag renderXmlTag;
        TagSnapshot snapshot = node.getTagSnapshot();
        if (snapshot != null && (renderXmlTag = snapshot.tag) instanceof PsiXmlTag) {
            PsiXmlTag xmlTag = (PsiXmlTag)renderXmlTag;
            map2.put(xmlTag.getPsiXmlTag(), snapshot);
        }
        for (TagSnapshotTreeNode child : node.getChildren()) {
            DefaultModelUpdater.gatherTagsAndSnapshots(child, map2);
        }
    }

    @NotNull
    private NlComponent createTree(@NotNull XmlTag tag, ModelUpdaterData data) {
        XmlTag[] subTags;
        NlComponent component = data.myTagToComponentMap.get(tag);
        if (component == null) {
            component = data.myModel.createComponent(tag);
            this.recordComponentMapping(tag, component, data);
        }
        if ((subTags = tag.getSubTags()).length > 0) {
            ArrayList<NlComponent> children = new ArrayList<NlComponent>(subTags.length);
            for (XmlTag subtag : subTags) {
                NlComponent child = this.createTree(subtag, data);
                children.add(child);
            }
            component.setChildren(children);
        } else {
            component.setChildren(null);
        }
        return component;
    }

    private void updateHierarchy(@NotNull TagSnapshotTreeNode node, ModelUpdaterData data) {
        TagSnapshot snapshot = (TagSnapshot)ApplicationManager.getApplication().runReadAction(node::getTagSnapshot);
        if (snapshot != null) {
            NlComponent component = data.mySnapshotToComponent.get(snapshot);
            if (component == null) {
                PsiXmlTag psiXmlTag = (PsiXmlTag)snapshot.tag;
                component = data.myTagToComponentMap.get(psiXmlTag != null ? psiXmlTag.getPsiXmlTag() : null);
            }
            if (component != null) {
                component.setSnapshot(snapshot);
                assert (snapshot.tag != null);
                component.setTag(((PsiXmlTag)snapshot.tag).getPsiXmlTag());
            }
        }
        for (TagSnapshotTreeNode child : node.getChildren()) {
            this.updateHierarchy(child, data);
        }
    }

    private static class ModelUpdaterData {
        protected NlModel myModel;
        protected final Map<XmlTag, NlComponent> myTagToComponentMap = Maps.newIdentityHashMap();
        protected final Map<NlComponent, XmlTag> myComponentToTagMap = Maps.newIdentityHashMap();
        protected final Map<TagSnapshot, NlComponent> mySnapshotToComponent = Maps.newIdentityHashMap();
        protected final Map<XmlTag, TagSnapshot> myTagToSnapshot = Maps.newHashMap();

        private ModelUpdaterData() {
        }
    }
}

