/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.annotations.concurrency.AnyThread;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.annotations.InputEventMask;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneHitListener;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.MultiComponentTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.rendering.RenderServiceUtilsKt;
import com.android.tools.idea.rendering.StudioRenderService;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.idea.rendering.parsers.PsiXmlTag;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.SecondarySelector;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.RenderTask;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.ide.PooledThreadExecutor;

public class Scene
implements SelectionListener,
Disposable {
    private static final int DRAG_THRESHOLD = JBUI.scale((int)10);
    private static final String PREFERENCE_KEY_PREFIX = "ScenePreference";
    private static final String SHOW_TOOLTIP_KEY = "ScenePreferenceShowToolTip";
    private static Boolean SHOW_TOOLTIP_VALUE = null;
    private final DesignSurface<?> myDesignSurface;
    private final SceneManager mySceneManager;
    private static final boolean DEBUG = false;
    private final HashMap<NlComponent, SceneComponent> mySceneComponents = new HashMap();
    @Nullable
    private SceneComponent myRoot;
    private boolean myIsAnimated = true;
    public static final int NO_LAYOUT = 0;
    public static final int IMMEDIATE_LAYOUT = 1;
    public static final int ANIMATED_LAYOUT = 2;
    private long myDisplayListVersion = 1L;
    private Target myOverTarget;
    private Target mySnapTarget;
    private SceneComponent myCurrentComponent;
    NlComponent myLastHoverConstraintComponent = null;
    private int mNeedsLayout = 0;
    protected int myPressedMouseX;
    protected int myPressedMouseY;
    private int myLastMouseX;
    private int myLastMouseY;
    @NotNull
    private final SceneHitListener myHoverListener;
    @NotNull
    private final SceneHitListener myHitListener;
    @NotNull
    private final SceneHitListener myFindListener;
    @NotNull
    private final SceneHitListener mySnapListener;
    @Nullable
    private Target myHitTarget = null;
    private Cursor myMouseCursor;
    private SceneComponent myHitComponent;
    List<SceneComponent> myNewSelectedComponentsOnRelease = new ArrayList<SceneComponent>();
    List<SceneComponent> myNewSelectedComponentsOnDown = new ArrayList<SceneComponent>();
    Set<SceneComponent> myHoveredComponents = new HashSet<SceneComponent>();
    @NotNull
    private FilterType myFilterType = FilterType.NONE;

    public Scene(@NotNull SceneManager sceneManager, @NotNull DesignSurface<?> surface2) {
        this.myDesignSurface = surface2;
        this.mySceneManager = sceneManager;
        SelectionModel selectionModel = this.myDesignSurface.getSelectionModel();
        this.myHoverListener = new SceneHitListener(selectionModel);
        this.myHitListener = new SceneHitListener(selectionModel);
        this.myFindListener = new SceneHitListener(selectionModel);
        this.mySnapListener = new SceneHitListener(selectionModel);
        selectionModel.addListener(this);
        this.myHoverListener.setTargetFilter(target -> {
            if (target instanceof AnchorTarget) {
                AnchorTarget anchorTarget = (AnchorTarget)target;
                if (this.myHitTarget == null) {
                    return !anchorTarget.isEdge();
                }
                if (this.myHitTarget instanceof AnchorTarget) {
                    return ((AnchorTarget)this.myHitTarget).isConnectible(anchorTarget);
                }
            }
            return true;
        });
        Disposer.register((Disposable)sceneManager, (Disposable)this);
    }

    public static void setTooltipVisibility(boolean visible) {
        SHOW_TOOLTIP_VALUE = visible;
        PropertiesComponent.getInstance().setValue(SHOW_TOOLTIP_KEY, visible);
    }

    public static boolean getTooltipVisibility() {
        if (SHOW_TOOLTIP_VALUE != null) {
            return SHOW_TOOLTIP_VALUE;
        }
        SHOW_TOOLTIP_VALUE = PropertiesComponent.getInstance().getBoolean(SHOW_TOOLTIP_KEY, false);
        return SHOW_TOOLTIP_VALUE;
    }

    public void dispose() {
        this.myDesignSurface.getSelectionModel().removeListener(this);
    }

    @NotNull
    public SceneManager getSceneManager() {
        return this.mySceneManager;
    }

    public boolean supportsRTL() {
        return true;
    }

    public boolean isResizeAvailable() {
        Configuration configuration = this.mySceneManager.getModel().getConfiguration();
        Device device = configuration.getCachedDevice();
        return device != null;
    }

    public boolean isInRTL() {
        Configuration configuration = this.mySceneManager.getModel().getConfiguration();
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier == null) {
            return false;
        }
        return qualifier.getValue() == LayoutDirection.RTL;
    }

    public int getRenderedApiLevel() {
        Configuration configuration = this.mySceneManager.getModel().getConfiguration();
        IAndroidTarget target = configuration.getTarget();
        if (target != null) {
            return target.getVersion().getApiLevel();
        }
        return 1;
    }

    public boolean isAnimated() {
        return this.myIsAnimated;
    }

    public void setAnimated(boolean animated) {
        this.myIsAnimated = animated;
    }

    @Nullable
    public SceneComponent getSceneComponent(@Nullable NlComponent component) {
        if (component == null) {
            return null;
        }
        return this.mySceneComponents.get(component);
    }

    @NotNull
    public DesignSurface<?> getDesignSurface() {
        return this.myDesignSurface;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        SceneComponent root = this.myRoot;
        if (root == null) {
            return null;
        }
        return root.getSceneComponent(componentId);
    }

    public List<NlComponent> getSelection() {
        return this.myDesignSurface.getSelectionModel().getSelection();
    }

    @Nullable
    public Object getSecondarySelection() {
        return this.myDesignSurface.getSelectionModel().getSecondarySelection();
    }

    @Nullable
    public SceneComponent getRoot() {
        return this.myRoot;
    }

    public Cursor getMouseCursor() {
        return this.myMouseCursor;
    }

    public boolean isCtrlMetaDown() {
        int ctrlMetaDownMask;
        int modifiersEx = this.getModifiersEx();
        return (modifiersEx & (ctrlMetaDownMask = AdtUiUtils.getActionMask())) != 0;
    }

    public boolean isShiftDown() {
        int modifiersEx = this.getModifiersEx();
        return (modifiersEx & 0x40) != 0;
    }

    @InputEventMask
    private int getModifiersEx() {
        return this.myDesignSurface.getGuiInputHandler().getLastModifiersEx();
    }

    public void addComponent(@NotNull SceneComponent component) {
        this.mySceneComponents.put(component.getNlComponent(), component);
        this.needsRebuildList();
    }

    public void removeComponent(@NotNull SceneComponent component) {
        component.removeFromParent();
        this.mySceneComponents.remove(component.getNlComponent(), component);
        this.needsRebuildList();
    }

    void removeAllComponents() {
        Iterator<Map.Entry<NlComponent, SceneComponent>> it = this.mySceneComponents.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<NlComponent, SceneComponent> entry = it.next();
            entry.getValue().removeFromParent();
            it.remove();
        }
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
        SceneComponent root = this.myRoot;
        if (root != null) {
            Scene.markSelection(root, model);
        }
    }

    private static void markSelection(@NotNull SceneComponent component, SelectionModel model) {
        component.setSelected(model.isSelected(component.getNlComponent()));
        component.setHighlighted(model.isHighlighted(component.getNlComponent()));
        for (SceneComponent child : component.getChildren()) {
            Scene.markSelection(child, model);
        }
    }

    @TestOnly
    public void buildDisplayList(@NotNull DisplayList displayList, long time) {
        this.layout(time, SceneContext.get());
        this.buildDisplayList(displayList, time, SceneContext.get());
    }

    @TestOnly
    public void buildDisplayList(@NotNull DisplayList displayList, long time, @NotNull SceneView sceneView) {
        this.buildDisplayList(displayList, time, sceneView.getContext());
    }

    public void repaint() {
        this.myDesignSurface.repaint();
    }

    @AnyThread
    void buildDisplayList(@NotNull DisplayList displayList, long time, SceneContext sceneContext) {
        SceneComponent root = this.myRoot;
        if (root != null) {
            root.buildDisplayList(time, displayList, sceneContext);
            sceneContext.swapPickerBuffer();
        }
    }

    @AnyThread
    public boolean layout(long time, SceneContext sceneContext) {
        boolean needsToRebuildDisplayList = false;
        SceneComponent root = this.myRoot;
        if (root != null && (needsToRebuildDisplayList = root.layout(sceneContext, time))) {
            this.needsRebuildList();
        }
        return needsToRebuildDisplayList;
    }

    public void select(List<SceneComponent> components) {
        if (this.myDesignSurface != null) {
            ArrayList<NlComponent> nlComponents = new ArrayList<NlComponent>();
            if (this.isShiftDown() || this.isCtrlMetaDown()) {
                List<NlComponent> selection = this.myDesignSurface.getSelectionModel().getSelection();
                nlComponents.addAll(selection);
            }
            for (SceneComponent sceneComponent : components) {
                if (sceneComponent == null) continue;
                NlComponent nlComponent = sceneComponent.getNlComponent();
                if ((this.isShiftDown() || this.isCtrlMetaDown()) && nlComponents.contains(nlComponent)) {
                    nlComponents.remove(nlComponent);
                    continue;
                }
                nlComponents.add(nlComponent);
            }
            this.myDesignSurface.getSelectionModel().setSelection(nlComponents);
        }
    }

    public void mouseHover(@NotNull SceneContext transform, int x, int y, @InputEventMask int modifiersEx) {
        SecondarySelector ss;
        SceneComponent root;
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myLastHoverConstraintComponent != null) {
            this.myLastHoverConstraintComponent.putClientProperty("CONSTRAINT_HOVER", null);
            this.myLastHoverConstraintComponent = null;
            this.needsRebuildList();
        }
        if ((root = this.myRoot) != null) {
            this.myHoverListener.find(transform, root, x, y, modifiersEx);
            this.mySnapListener.find(transform, root, x, y, modifiersEx);
        }
        this.repaint();
        Target closestTarget = this.myHoverListener.getClosestTarget(modifiersEx);
        String tooltip = null;
        if (this.myOverTarget != closestTarget || closestTarget != null && !closestTarget.isMouseHovered()) {
            if (this.myOverTarget != null) {
                this.myOverTarget.setMouseHovered(false);
                this.myOverTarget = null;
                this.needsRebuildList();
            }
            if (closestTarget != null) {
                closestTarget.setMouseHovered(true);
                this.myOverTarget = closestTarget;
                this.needsRebuildList();
            }
        }
        if (closestTarget != null) {
            tooltip = closestTarget.getToolTipText();
            Target snapTarget = this.myHoverListener.getFilteredTarget(closestTarget);
            if (snapTarget != this.mySnapTarget || snapTarget != null && !snapTarget.isMouseHovered()) {
                if (this.mySnapTarget != null) {
                    this.mySnapTarget.setMouseHovered(false);
                    this.mySnapTarget = null;
                    this.needsRebuildList();
                }
                if (snapTarget != null) {
                    snapTarget.setMouseHovered(true);
                    this.mySnapTarget = closestTarget;
                    this.needsRebuildList();
                }
            }
        }
        this.updateHoveredComponentsDrawState();
        SceneComponent closestComponent = this.myHoverListener.getClosestComponent();
        if (closestComponent != null && tooltip == null) {
            tooltip = closestComponent.getNlComponent().getTooltipText();
        }
        if (this.myCurrentComponent != closestComponent || closestComponent != null && closestComponent.getDrawState() != SceneComponent.DrawState.HOVER) {
            if (this.myCurrentComponent != null) {
                this.myCurrentComponent.setDrawState(SceneComponent.DrawState.NORMAL);
                this.myCurrentComponent = null;
            }
            if (closestComponent != null) {
                closestComponent.setDrawState(SceneComponent.DrawState.HOVER);
                this.myCurrentComponent = closestComponent;
            }
            this.needsRebuildList();
        }
        if ((closestComponent == null || closestComponent.getNlComponent().isRoot() && this.myHitTarget == null) && (ss = Scene.getSecondarySelector(transform, x, y)) != null) {
            NlComponent component = ss.getComponent();
            this.myLastHoverConstraintComponent = ss.getComponent();
            tooltip = this.getConstraintToolTip(ss);
            component.putClientProperty("CONSTRAINT_HOVER", (Object)ss.getConstraint());
            this.needsRebuildList();
        }
        if (Scene.getTooltipVisibility()) {
            this.getDesignSurface().setDesignToolTip(tooltip);
        }
        this.setCursor(transform, x, y, modifiersEx);
    }

    @NotNull
    private String getConstraintToolTip(@NotNull SecondarySelector ss) {
        Object tooltip;
        NlComponent component = ss.getComponent();
        String connect = "";
        String target = "";
        SecondarySelector.Constraint connection = ss.getConstraint();
        if (this.isInRTL()) {
            if (connection == SecondarySelector.Constraint.LEFT) {
                connection = SecondarySelector.Constraint.RIGHT;
            } else if (connection == SecondarySelector.Constraint.RIGHT) {
                connection = SecondarySelector.Constraint.LEFT;
            }
        }
        switch (connection) {
            case LEFT: {
                connect = "layout_constraintStart_toStartOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect = "layout_constraintStart_toEndOf")) == null) break;
                break;
            }
            case RIGHT: {
                connect = "layout_constraintEnd_toStartOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect = "layout_constraintEnd_toEndOf")) == null) break;
                break;
            }
            case TOP: {
                connect = "layout_constraintTop_toTopOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect = "layout_constraintTop_toBottomOf")) == null) break;
                break;
            }
            case BOTTOM: {
                connect = "layout_constraintBottom_toTopOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect = "layout_constraintBottom_toBottomOf")) == null) break;
                break;
            }
            case BASELINE: {
                connect = "layout_constraintBaseline_toBaselineOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect);
            }
        }
        try {
            connect = connect.substring("layout_constraint".length(), connect.length() - 2).replace("_to", " to ").toLowerCase();
            if (target != null) {
                target = target.substring(target.indexOf("/") + 1);
            }
            tooltip = component.getTooltipText() + " " + connect + " of " + target;
        }
        catch (Exception ex) {
            tooltip = "";
        }
        return tooltip;
    }

    private void updateHoveredComponentsDrawState() {
        ArrayList<SceneComponent> hitComponents = this.myHoverListener.getHitComponents();
        for (SceneComponent component : hitComponents) {
            if (component != this.myCurrentComponent) {
                NlComponent nlComponent = component.getAuthoritativeNlComponent();
                if (DecoratorUtilities.getTryingToConnectState(nlComponent) != null) {
                    component.setDrawState(SceneComponent.DrawState.HOVER);
                } else {
                    component.setDrawState(SceneComponent.DrawState.NORMAL);
                }
            }
            this.myHoveredComponents.remove(component);
        }
        Iterator<SceneComponent> iterator = this.myHoveredComponents.iterator();
        while (iterator.hasNext()) {
            SceneComponent component;
            component = iterator.next();
            component.setDrawState(SceneComponent.DrawState.NORMAL);
            iterator.remove();
        }
        this.myHoveredComponents.addAll(hitComponents);
    }

    private void setCursor(@NotNull SceneContext transform, int x, int y, @InputEventMask int modifiersEx) {
        this.myMouseCursor = Cursor.getDefaultCursor();
        if (this.myCurrentComponent != null && this.myCurrentComponent.isDragging()) {
            this.myMouseCursor = Cursor.getPredefinedCursor(13);
            return;
        }
        if (this.myOverTarget != null) {
            this.myMouseCursor = this.myOverTarget.getMouseCursor(modifiersEx);
            return;
        }
        SceneComponent component = this.findComponent(transform, x, y);
        if (component != null && component.getParent() != null) {
            this.myMouseCursor = Cursor.getPredefinedCursor(12);
        }
    }

    private void delegateMouseDownToSelection(int x, int y, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseDown(x, y);
                }
            }
        }
    }

    private void delegateMouseDragToSelection(int x, int y, @Nullable Target closestTarget, @NotNull SceneComponent currentComponent, @NotNull SceneContext context) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    ArrayList<Target> list = new ArrayList<Target>();
                    list.add(closestTarget);
                    target.mouseDrag(x, y, list, context);
                }
            }
        }
    }

    private void delegateMouseReleaseToSelection(int x, int y, @Nullable Target closestTarget, @NotNull SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            int count = selection.size();
            for (int i = 0; i < count; ++i) {
                SceneComponent c;
                NlComponent nlComponent = selection.get(i);
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseRelease(x, y, Collections.singletonList(closestTarget));
                }
            }
        }
    }

    private void delegateMouseCancelToSelection(@NotNull SceneComponent currentComponent) {
        NlComponent currentNlComponent = currentComponent.getNlComponent();
        Scene scene = currentComponent.getScene();
        List<SceneComponent> otherComponents = this.getSelection().stream().filter(it -> it != currentNlComponent).map(scene::getSceneComponent).filter(Objects::nonNull).toList();
        for (SceneComponent c : otherComponents) {
            ImmutableList<Target> targets = c.getTargets();
            for (Target t : targets) {
                if (!(t instanceof MultiComponentTarget)) continue;
                t.mouseCancel();
            }
        }
    }

    public void mouseDown(@NotNull SceneContext transform, int x, int y, @InputEventMask int modifiersEx) {
        this.myPressedMouseX = x;
        this.myPressedMouseY = y;
        this.mNeedsLayout = 0;
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        this.myFilterType = FilterType.NONE;
        SceneComponent root = this.myRoot;
        if (root == null) {
            return;
        }
        this.myNewSelectedComponentsOnDown.clear();
        this.myHitListener.setTargetFilter(it -> {
            if (it instanceof AnchorTarget) {
                return !((AnchorTarget)it).isEdge();
            }
            return true;
        });
        SecondarySelector secondarySelector = Scene.getSecondarySelector(transform, x, y);
        this.myHitListener.find(transform, root, x, y, modifiersEx);
        this.myHitTarget = this.myHitListener.getClosestTarget(modifiersEx);
        this.myHitComponent = this.myHitListener.getClosestComponent();
        if (this.myHitTarget != null) {
            this.myHitTarget.mouseDown(x, y);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDownToSelection(x, y, this.myHitTarget.getComponent());
            }
        } else if (this.myHitComponent != null && this.notInCurrentSelection(this.myHitComponent)) {
            this.myNewSelectedComponentsOnDown.add(this.myHitComponent);
            this.select(this.myNewSelectedComponentsOnDown);
        } else if (this.findSelectionOfCurve(secondarySelector)) {
            return;
        }
        this.myHitListener.setTargetFilter(null);
    }

    @Nullable
    public static SecondarySelector getSecondarySelector(@NotNull SceneContext transform, int x, int y) {
        Object obj = transform.findClickedGraphics(transform.getSwingXDip(x), transform.getSwingYDip(y));
        if (obj instanceof SecondarySelector) {
            return (SecondarySelector)obj;
        }
        return null;
    }

    public void mouseDrag(@NotNull SceneContext transform, int x, int y, @InputEventMask int modifiersEx) {
        if (this.myLastMouseX == x && this.myLastMouseY == y) {
            return;
        }
        SceneComponent root = this.myRoot;
        if (root == null) {
            return;
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myHitTarget != null) {
            if (!this.myHitTarget.getComponent().isDragging() && !this.myDesignSurface.getSelectionModel().isSelected(this.myHitTarget.getComponent().getNlComponent()) && Scene.isWithinThreshold(this.myPressedMouseX, x, transform) && Scene.isWithinThreshold(this.myPressedMouseY, y, transform)) {
                return;
            }
            LassoTarget lassoTarget = null;
            if (this.myHitTarget instanceof LassoTarget && (lassoTarget = (LassoTarget)this.myHitTarget).getSelectWhileDragging() && lassoTarget.getHasChanged()) {
                this.myNewSelectedComponentsOnRelease.clear();
                this.myNewSelectedComponentsOnRelease.addAll(lassoTarget.getIntersectingComponents());
                this.select(this.myNewSelectedComponentsOnRelease);
                lassoTarget.clearHasChanged();
            }
            this.myHitListener.setTargetFilter(target -> this.myHitTarget != target);
            this.myHitListener.find(transform, root, x, y, modifiersEx);
            SceneComponent targetComponent = this.myHitTarget.getComponent();
            if (lassoTarget == null && targetComponent != null && this.notInCurrentSelection(targetComponent)) {
                this.myNewSelectedComponentsOnRelease.clear();
                this.myNewSelectedComponentsOnRelease.add(targetComponent);
                this.select(this.myNewSelectedComponentsOnRelease);
            }
            this.myHitTarget.mouseDrag(x, y, this.myHitListener.myHitTargets, transform);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDragToSelection(x, y, this.myHitListener.getClosestTarget(modifiersEx), this.myHitTarget.getComponent(), transform);
            }
            this.myHitListener.setTargetFilter(null);
        }
        this.mouseHover(transform, x, y, modifiersEx);
        this.requestLayoutIfNeeded();
    }

    private static boolean isWithinThreshold(int pos1, int pos2, SceneContext transform) {
        int pos4;
        int pos3 = transform.getSwingDimensionDip(pos1);
        return Math.abs(pos3 - (pos4 = transform.getSwingDimensionDip(pos2))) < DRAG_THRESHOLD;
    }

    public void requestLayoutIfNeeded() {
        if (this.mNeedsLayout != 0) {
            SceneManager manager = this.getSceneManager();
            manager.requestLayoutAsync(this.mNeedsLayout == 2);
        }
    }

    private boolean findSelectionOfCurve(SecondarySelector ss) {
        if (ss == null) {
            return false;
        }
        NlComponent comp = ss.getComponent();
        SecondarySelector.Constraint sub = ss.getConstraint();
        this.myDesignSurface.getSelectionModel().setSecondarySelection(comp, (Object)sub);
        return true;
    }

    public void mouseRelease(@NotNull SceneContext transform, int x, int y, @InputEventMask int modifiersEx) {
        List<SceneComponent> changed;
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        SceneComponent closestComponent = this.myHitListener.getClosestComponent();
        if (this.myHitTarget != null) {
            SceneComponent root = this.myRoot;
            if (root != null) {
                this.myHitListener.find(transform, root, x, y, modifiersEx);
            }
            this.myHitTarget.mouseRelease(x, y, (List<Target>)this.myHitListener.getHitTargets());
            this.myHitTarget.getComponent().setDragging(false);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseReleaseToSelection(x, y, this.myHitListener.getClosestTarget(modifiersEx), this.myHitTarget.getComponent());
            }
        }
        this.myFilterType = FilterType.NONE;
        this.myNewSelectedComponentsOnRelease.clear();
        if (this.myHitComponent != null && closestComponent == this.myHitComponent) {
            this.myNewSelectedComponentsOnRelease.add(this.myHitComponent);
        }
        if (this.myHitTarget != null && (changed = this.myHitTarget.newSelection()) != null) {
            this.myNewSelectedComponentsOnRelease.clear();
            this.myNewSelectedComponentsOnRelease.addAll(changed);
        }
        SecondarySelector secondarySelector = Scene.getSecondarySelector(transform, x, y);
        boolean same = this.sameSelection();
        SceneComponent topHitComponent = this.myHitListener.getTopHitComponent();
        if (same && topHitComponent != closestComponent && Scene.isWithinThreshold(this.myPressedMouseX, x, transform) && Scene.isWithinThreshold(this.myPressedMouseY, y, transform)) {
            this.myNewSelectedComponentsOnRelease.clear();
            this.myNewSelectedComponentsOnRelease.add(topHitComponent);
            this.myHitTarget = null;
            same = this.sameSelection();
        }
        if (secondarySelector == null && !same && (this.myHitTarget == null || this.myHitTarget.canChangeSelection())) {
            this.select(this.myNewSelectedComponentsOnRelease);
        } else {
            this.myDesignSurface.getSelectionModel().clearSecondary();
            this.findSelectionOfCurve(secondarySelector);
        }
        this.myHitTarget = null;
        this.requestLayoutIfNeeded();
    }

    public void mouseCancel() {
        if (this.myHitTarget != null) {
            this.myHitTarget.mouseCancel();
            this.myHitTarget.getComponent().setDragging(false);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseCancelToSelection(this.myHitTarget.getComponent());
            }
        }
        this.myFilterType = FilterType.NONE;
        this.myNewSelectedComponentsOnRelease.clear();
        this.myHitTarget = null;
        this.requestLayoutIfNeeded();
    }

    private boolean notInCurrentSelection(@NotNull SceneComponent component) {
        List<NlComponent> currentSelection = this.myDesignSurface.getSelectionModel().getSelection();
        return !currentSelection.contains(component.getNlComponent());
    }

    private boolean sameSelection() {
        if (!this.myNewSelectedComponentsOnRelease.isEmpty() && this.myNewSelectedComponentsOnRelease.size() == this.myNewSelectedComponentsOnDown.size() && this.myNewSelectedComponentsOnRelease.containsAll(this.myNewSelectedComponentsOnDown)) {
            return true;
        }
        List<NlComponent> currentSelection = this.myDesignSurface.getSelectionModel().getSelection();
        if (this.myNewSelectedComponentsOnRelease.size() == currentSelection.size()) {
            int count = currentSelection.size();
            for (int i = 0; i < count; ++i) {
                NlComponent component = currentSelection.get(i);
                SceneComponent sceneComponent = this.getSceneComponent(component);
                if (this.myNewSelectedComponentsOnRelease.contains(sceneComponent)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void markNeedsLayout(int type) {
        this.mNeedsLayout = type;
    }

    public synchronized long getDisplayListVersion() {
        return this.myDisplayListVersion;
    }

    public synchronized void needsRebuildList() {
        ++this.myDisplayListVersion;
    }

    public List<SceneComponent> findWithin(int x, int y, int width, int height) {
        ArrayList<SceneComponent> within = new ArrayList<SceneComponent>();
        if (this.getRoot() != null) {
            Scene.addWithin(within, this.getRoot(), x, y, width, height);
        }
        return within;
    }

    private static boolean addWithin(@NotNull List<SceneComponent> result, @NotNull SceneComponent component, int x, int y, int width, int height) {
        if (component.getDrawX() + component.getDrawWidth() <= x || x + width <= component.getDrawX() || component.getDrawY() + component.getDrawHeight() <= y || y + height <= component.getDrawY()) {
            return false;
        }
        boolean found = false;
        for (SceneComponent child : component.getChildren()) {
            found |= Scene.addWithin(result, child, x, y, width, height);
        }
        if (!found) {
            result.add(component);
        }
        return true;
    }

    @Nullable
    public SceneComponent findComponent(@NotNull SceneContext transform, int x, int y) {
        SceneComponent root = this.myRoot;
        if (root == null) {
            return null;
        }
        this.myFindListener.find(transform, root, x, y, 0);
        return this.myFindListener.getClosestComponent();
    }

    @Nullable
    public Target findTarget(@NotNull SceneContext transform, int x, int y, @InputEventMask int modifiersEx) {
        SceneComponent root = this.myRoot;
        if (root == null) {
            return null;
        }
        this.myFindListener.find(transform, root, x, y, modifiersEx);
        return this.myFindListener.getClosestTarget(modifiersEx);
    }

    public Collection<SceneComponent> getSceneComponents() {
        return this.mySceneComponents.values();
    }

    public void setRoot(SceneComponent root) {
        this.myRoot = root;
    }

    @NotNull
    public FilterType getFilterType() {
        return this.myFilterType;
    }

    public void setFilterType(@NotNull FilterType filterType) {
        this.myFilterType = filterType;
    }

    @Nullable
    public Target getInteractingTarget() {
        return this.myHitTarget;
    }

    @NotNull
    public CompletableFuture<Dimension> measureWrapSize(@NotNull SceneComponent component) {
        return this.measure(component, (n, namespace, localName) -> {
            if ("layout_width".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            if ("layout_height".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            return null;
        });
    }

    @NotNull
    private CompletableFuture<Dimension> measure(@NotNull SceneComponent component, @Nullable RenderTask.AttributeFilter filter2) {
        NlComponent neleComponent = component.getNlComponent();
        if (!neleComponent.getBackend().isValid()) {
            return CompletableFuture.completedFuture(null);
        }
        NlModel model = neleComponent.getModel();
        XmlFile xmlFile = model.getFile();
        Module module = model.getModule();
        RenderService renderService = StudioRenderService.getInstance((Project)module.getProject());
        AndroidFacet facet = model.getFacet();
        return ((CompletableFuture)RenderServiceUtilsKt.taskBuilderWithHtmlLogger(renderService, model.getBuildTarget(), model.getConfiguration()).withPsiFile((RenderXmlFile)new PsiXmlFile(xmlFile)).build().thenCompose(task -> {
            if (task == null) {
                return CompletableFuture.completedFuture(null);
            }
            XmlTag tag = neleComponent.getTagDeprecated();
            return task.measureChild((RenderXmlTag)new PsiXmlTag(tag), filter2).whenCompleteAsync((map2, ex) -> task.dispose(), (Executor)PooledThreadExecutor.INSTANCE);
        })).thenApply(viewInfo -> {
            if (viewInfo == null) {
                return null;
            }
            viewInfo = RenderService.getSafeBounds((ViewInfo)viewInfo);
            return new Dimension(Coordinates.pxToDp(this.getSceneManager(), viewInfo.getRight() - viewInfo.getLeft()), Coordinates.pxToDp(this.getSceneManager(), viewInfo.getBottom() - viewInfo.getTop()));
        });
    }

    public List<Placeholder> getPlaceholders(@Nullable SceneComponent requester, @NotNull List<SceneComponent> draggedComponents) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        SceneComponent root = this.myRoot;
        if (root != null) {
            Scene.doGetPlaceholders((ImmutableList.Builder<Placeholder>)builder, root, requester, draggedComponents);
        }
        return builder.build();
    }

    private static void doGetPlaceholders(@NotNull ImmutableList.Builder<Placeholder> builder, @NotNull SceneComponent component, @Nullable SceneComponent requester, @NotNull List<SceneComponent> draggedComponents) {
        if (component == requester) {
            return;
        }
        NlComponent nlComponent = component.getNlComponent();
        ViewHandler handler = NlComponentHelperKt.getViewHandler(nlComponent, () -> {});
        if (handler != null) {
            builder.addAll(handler.getPlaceholders(component, draggedComponents));
        }
        for (SceneComponent child : component.getChildren()) {
            Scene.doGetPlaceholders(builder, child, requester, draggedComponents);
        }
    }

    public static enum FilterType {
        ALL,
        ANCHOR,
        VERTICAL_ANCHOR,
        HORIZONTAL_ANCHOR,
        BASELINE_ANCHOR,
        NONE,
        RESIZE;

    }
}

