/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.InteractionInformation;
import com.android.tools.idea.common.surface.KeyPressedEvent;
import com.android.tools.idea.common.surface.KeyReleasedEvent;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.MousePressedEvent;
import com.android.tools.idea.common.surface.MouseReleasedEvent;
import com.android.tools.idea.common.surface.SceneView;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneInteraction
implements Interaction {
    protected SceneView mySceneView;

    public SceneInteraction(@NotNull SceneView sceneView) {
        this.mySceneView = sceneView;
    }

    @Override
    public void begin(@NotNull InteractionEvent event) {
        if (event instanceof MousePressedEvent) {
            MouseEvent mouseEvent = (MouseEvent)((MousePressedEvent)event).getEventObject();
            this.begin(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiersEx());
        } else {
            Logger.getInstance(SceneInteraction.class).warn("The Scene Interaction shouldn't be started by event " + String.valueOf(event));
        }
    }

    public void begin(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        int androidX = Coordinates.getAndroidX(this.mySceneView, x);
        int androidY = Coordinates.getAndroidY(this.mySceneView, y);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.mouseDown(this.mySceneView.getContext(), dpX, dpY, modifiersEx);
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        if (event instanceof MouseDraggedEvent) {
            MouseEvent mouseEvent = (MouseEvent)((MouseDraggedEvent)event).getEventObject();
            int mouseX = mouseEvent.getX();
            int mouseY = mouseEvent.getY();
            this.mySceneView.getContext().setMouseLocation(mouseX, mouseY);
            this.update(mouseX, mouseY, mouseEvent.getModifiersEx());
        } else if (event instanceof KeyPressedEvent || event instanceof KeyReleasedEvent) {
            Scene scene = this.mySceneView.getScene();
            scene.needsRebuildList();
            scene.repaint();
        }
    }

    public void update(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        int androidX = Coordinates.getAndroidX(this.mySceneView, x);
        int androidY = Coordinates.getAndroidY(this.mySceneView, y);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.mouseDrag(this.mySceneView.getContext(), dpX, dpY, modifiersEx);
        this.mySceneView.getSurface().repaint();
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        int modifiers;
        int y;
        int x;
        if (!(event instanceof MouseReleasedEvent)) {
            Logger.getInstance(this.getClass()).error("The instance of event should be MouseReleasedEvent but it is " + String.valueOf(event.getClass()) + "; The SceneView is " + String.valueOf(this.mySceneView));
            InteractionInformation info = event.getInfo();
            x = info.getX();
            y = info.getY();
            modifiers = info.getModifiersEx();
        } else {
            MouseEvent mouseEvent = (MouseEvent)((MouseReleasedEvent)event).getEventObject();
            x = mouseEvent.getX();
            y = mouseEvent.getY();
            modifiers = mouseEvent.getModifiersEx();
        }
        this.end(x, y, modifiers);
    }

    public void end(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        int androidX = Coordinates.getAndroidX(this.mySceneView, x);
        int androidY = Coordinates.getAndroidY(this.mySceneView, y);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.mouseRelease(this.mySceneView.getContext(), dpX, dpY, modifiersEx);
        this.mySceneView.getSurface().repaint();
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        Scene scene = this.mySceneView.getScene();
        scene.mouseCancel();
        this.mySceneView.getSurface().repaint();
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return this.mySceneView.getScene().getMouseCursor();
    }
}

