/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.model.ScaleKt;
import com.android.tools.idea.common.surface.SceneView;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 !2\u00020\u0001:\u0001!B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/common/surface/LayoutData;", "", "scale", "", "x", "", "y", "scaledSize", "Ljava/awt/Dimension;", "<init>", "(DIILjava/awt/Dimension;)V", "getScale", "()D", "getX", "()I", "getY", "getScaledSize", "()Ljava/awt/Dimension;", "cachedDimension", "isValidFor", "", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class LayoutData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double scale;
    private final int x;
    private final int y;
    @NotNull
    private final Dimension scaledSize;
    @NotNull
    private final Dimension cachedDimension;
    public static final int $stable = 8;

    public LayoutData(double scale, int x, int y, @NotNull Dimension scaledSize) {
        Intrinsics.checkNotNullParameter((Object)scaledSize, (String)"scaledSize");
        this.scale = scale;
        this.x = x;
        this.y = y;
        this.scaledSize = scaledSize;
        this.cachedDimension = new Dimension();
    }

    public final double getScale() {
        return this.scale;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    @NotNull
    public final Dimension getScaledSize() {
        return this.scaledSize;
    }

    public final boolean isValidFor(@NotNull SceneView sceneView) {
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        return this.scale == sceneView.getScale() && this.x == sceneView.getX() && this.y == sceneView.getY() && Intrinsics.areEqual((Object)this.scaledSize, (Object)ScaleKt.scaleBy(sceneView.getContentSize(this.cachedDimension), sceneView.getScale()));
    }

    public final double component1() {
        return this.scale;
    }

    public final int component2() {
        return this.x;
    }

    public final int component3() {
        return this.y;
    }

    @NotNull
    public final Dimension component4() {
        return this.scaledSize;
    }

    @NotNull
    public final LayoutData copy(double scale, int x, int y, @NotNull Dimension scaledSize) {
        Intrinsics.checkNotNullParameter((Object)scaledSize, (String)"scaledSize");
        return new LayoutData(scale, x, y, scaledSize);
    }

    public static /* synthetic */ LayoutData copy$default(LayoutData layoutData, double d, int n, int n2, Dimension dimension, int n3, Object object) {
        if ((n3 & 1) != 0) {
            d = layoutData.scale;
        }
        if ((n3 & 2) != 0) {
            n = layoutData.x;
        }
        if ((n3 & 4) != 0) {
            n2 = layoutData.y;
        }
        if ((n3 & 8) != 0) {
            dimension = layoutData.scaledSize;
        }
        return layoutData.copy(d, n, n2, dimension);
    }

    @NotNull
    public String toString() {
        return "LayoutData(scale=" + this.scale + ", x=" + this.x + ", y=" + this.y + ", scaledSize=" + this.scaledSize + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.scale);
        result = result * 31 + Integer.hashCode(this.x);
        result = result * 31 + Integer.hashCode(this.y);
        result = result * 31 + this.scaledSize.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayoutData)) {
            return false;
        }
        LayoutData layoutData = (LayoutData)other;
        if (Double.compare(this.scale, layoutData.scale) != 0) {
            return false;
        }
        if (this.x != layoutData.x) {
            return false;
        }
        if (this.y != layoutData.y) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.scaledSize, (Object)layoutData.scaledSize);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/common/surface/LayoutData$Companion;", "", "<init>", "()V", "fromSceneView", "Lcom/android/tools/idea/common/surface/LayoutData;", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LayoutData fromSceneView(@NotNull SceneView sceneView) {
            Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
            return new LayoutData(sceneView.getScale(), sceneView.getX(), sceneView.getY(), ScaleKt.scaleBy(sceneView.getContentSize(null), sceneView.getScale()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

