/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceScreenShape;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.ShapePolicy;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0003"}, d2={"DEVICE_CONFIGURATION_SHAPE_POLICY", "Lcom/android/tools/idea/common/surface/ShapePolicy;", "SQUARE_SHAPE_POLICY", "intellij.android.designer"})
public final class ShapePolicyKt {
    @JvmField
    @NotNull
    public static final ShapePolicy DEVICE_CONFIGURATION_SHAPE_POLICY = new ShapePolicy(){

        public Shape getShape(SceneView sceneView) {
            Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
            Device device = sceneView.getConfiguration().getCachedDevice();
            if (device == null) {
                return null;
            }
            Device device2 = device;
            Dimension size = sceneView.getScaledContentSize();
            double originX = sceneView.getX();
            double originY = sceneView.getY();
            return DeviceScreenShape.screenShape((Device)device2, (double)originX, (double)originY, (Dimension)size);
        }
    };
    @JvmField
    @NotNull
    public static final ShapePolicy SQUARE_SHAPE_POLICY = new ShapePolicy(){

        public Shape getShape(SceneView sceneView) {
            Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
            Dimension size = sceneView.getScaledContentSize();
            return new Rectangle(sceneView.getX(), sceneView.getY(), size.width, size.height);
        }
    };
}

