/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.surface;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.resources.ResourceItemResolver;
import com.android.tools.adtui.ZoomController;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.AndroidStudioKotlinPluginUtils;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.layout.LayoutManagerSwitcher;
import com.android.tools.idea.common.model.ChangeType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DefaultSelectionModel;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.LerpDouble;
import com.android.tools.idea.common.scene.LerpPoint;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SurfaceInteractable;
import com.android.tools.idea.common.surface.ZoomChange;
import com.android.tools.idea.common.surface.ZoomControlsPolicy;
import com.android.tools.idea.common.surface.ZoomListener;
import com.android.tools.idea.common.surface.layout.DesignSurfaceViewport;
import com.android.tools.idea.naveditor.analytics.NavUsageTracker;
import com.android.tools.idea.naveditor.editor.NavActionManager;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavActionHelperKt;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.naveditor.scene.NavSceneManagerKt;
import com.android.tools.idea.naveditor.surface.NavDesignSurfaceActionHandler;
import com.android.tools.idea.naveditor.surface.NavDesignSurfaceToken;
import com.android.tools.idea.naveditor.surface.NavDesignSurfaceZoomController;
import com.android.tools.idea.naveditor.surface.NavInteractionHandler;
import com.android.tools.idea.naveditor.surface.SinglePositionableContentLayoutManager;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.progress.CancellationUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NavDesignSurface
extends DesignSurface<NavSceneManager>
implements ZoomListener {
    private static final int SCROLL_DURATION_MS = 300;
    private static final Object CONNECTION_CLIENT_PROPERTY_KEY = new Object();
    private static final String FAILED_DEPENDENCY = "Failed to add navigation dependency";
    private static final String FAILED_DEPENDENCY_TITLE = "Failed to Add Dependency";
    private NlComponent myCurrentNavigation;
    @VisibleForTesting
    AtomicReference<Future<?>> myScheduleRef = new AtomicReference();
    private DesignerEditorPanel myEditorPanel;
    private static final List<GoogleMavenArtifactId> NAVIGATION_DEPENDENCIES = ImmutableList.of((Object)GoogleMavenArtifactId.NAVIGATION_FRAGMENT, (Object)GoogleMavenArtifactId.NAVIGATION_UI);
    private static final List<GoogleMavenArtifactId> NAVIGATION_DEPENDENCIES_KTX = ImmutableList.of((Object)GoogleMavenArtifactId.NAVIGATION_FRAGMENT_KTX, (Object)GoogleMavenArtifactId.NAVIGATION_UI_KTX);
    private static final List<GoogleMavenArtifactId> ANDROIDX_NAVIGATION_DEPENDENCIES = ImmutableList.of((Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_FRAGMENT, (Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_UI);
    private static final List<GoogleMavenArtifactId> ANDROIDX_NAVIGATION_DEPENDENCIES_KTX = ImmutableList.of((Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_FRAGMENT_KTX, (Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_UI_KTX);
    private final NavDesignSurfaceZoomController myZoomController;
    private final Runnable onSchemaChange = () -> {
        SceneManager manager = (SceneManager)Iterables.getFirst(this.getSceneManagers(), null);
        if (manager != null) {
            manager.requestRender();
        }
    };

    @TestOnly
    public NavDesignSurface(@NotNull Project project) {
        this(project, null);
    }

    public NavDesignSurface(@NotNull Project project, @Nullable DesignerEditorPanel editorPanel2) {
        super(project, surface2 -> new NavActionManager((NavDesignSurface)surface2), SurfaceInteractable::new, NavInteractionHandler::new, new SinglePositionableContentLayoutManager(), surface2 -> new NavDesignSurfaceActionHandler((NavDesignSurface)surface2), new DefaultSelectionModel(), ZoomControlsPolicy.VISIBLE, false);
        this.myEditorPanel = editorPanel2;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NavDesignSurface.this.removeComponentListener(this);
                SceneManager manager = (SceneManager)Iterables.getFirst(NavDesignSurface.this.getSceneManagers(), null);
                if (manager != null) {
                    manager.requestRender();
                }
            }
        });
        this.getSelectionModel().addListener((SelectionModel unused, List<NlComponent> selection) -> this.updateCurrentNavigation(selection));
        this.myZoomController = new NavDesignSurfaceZoomController((Function0<? extends Dimension>)((Function0)() -> this.getSize()), (Function0<? extends DesignSurfaceViewport>)((Function0)this::getViewport), (Function0<NavSceneManager>)((Function0)() -> {
            NlModel model = this.getModel();
            return model != null ? (NavSceneManager)this.getSceneManager(model) : null;
        }), (Function1<? super SceneView, ? extends Dimension>)((Function1)this::getSizeFromSceneView), this.getAnalyticsManager(), this.getSelectionModel(), this);
        this.myZoomController.setZoomListener(this);
        this.myZoomController.setOnScaleListener(this);
    }

    @Override
    @Nullable
    public LayoutManagerSwitcher getLayoutManagerSwitcher() {
        return null;
    }

    @Override
    public void dispose() {
        Future<?> future = this.getScheduleRef().get();
        if (future != null) {
            future.cancel(false);
        }
        this.getScheduleRef().set(null);
        super.dispose();
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink) {
        Point2D.Float p2d;
        SceneComponent sceneComponent;
        Scene scene;
        super.uiDataSnapshot(sink);
        NlComponent selection = this.getSelectionModel().getPrimary();
        if (selection != null && NavComponentHelperKt.isAction(selection) && (scene = this.getScene()) != null && (sceneComponent = scene.getSceneComponent(selection)) != null && (p2d = NavActionHelperKt.getAnyPoint(sceneComponent, this.getFocusedSceneView().getContext())) != null) {
            sink.set(PlatformDataKeys.CONTEXT_MENU_POINT, (Object)new Point((int)p2d.x, (int)p2d.y));
        }
    }

    public void forceUserRequestedRefresh() {
    }

    public void forceRefresh() {
    }

    @Override
    @NotNull
    protected NavSceneManager createSceneManager(@NotNull NlModel model) {
        return new NavSceneManager(model, this);
    }

    @Override
    @NotNull
    public CompletableFuture<?> goingToSetModel(final NlModel model) {
        model.getConfiguration().getResourceResolver();
        final AndroidFacet facet = model.getFacet();
        final CompletableFuture result = new CompletableFuture();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (NavDesignSurface.tryToCreateSchema(facet)) {
                result.complete(null);
            } else if (this.requestAddDependency(model)) {
                application.invokeAndWait(() -> {
                    ListenableFuture syncResult = ProjectSystemUtil.getSyncManager((Project)this.getProject()).requestSyncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
                    Futures.addCallback((ListenableFuture)syncResult, (FutureCallback)new FutureCallback<Object>(){

                        public void onSuccess(@Nullable Object unused) {
                            ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(NavDesignSurface.this.getProject(), "Waiting for schema to be ready..."){

                                public void run(@NotNull ProgressIndicator indicator) {
                                    int initialAttempts = 3;
                                    int attempts = 3;
                                    while (attempts > 0) {
                                        DumbService.getInstance((Project)this.getProject()).waitForSmartMode();
                                        if (NavDesignSurface.tryToCreateSchema(facet)) {
                                            result.complete(null);
                                            return;
                                        }
                                        CancellationUtil.sleepCancellable((long)(500L * (long)(3 - --attempts)));
                                    }
                                    NavDesignSurface.this.showFailToAddMessage(result, model);
                                }
                            }, (ProgressIndicator)new EmptyProgressIndicator());
                        }

                        public void onFailure(@Nullable Throwable t) {
                            NavDesignSurface.this.showFailToAddMessage(result, model);
                        }
                    }, (Executor)MoreExecutors.directExecutor());
                }, ModalityState.nonModal());
            } else {
                this.showFailToAddMessage(result, model);
            }
        });
        return result;
    }

    @Override
    public void setModel(@Nullable NlModel model) {
        NlModel oldModel = (NlModel)Iterables.getOnlyElement(this.getModels(), null);
        if (oldModel != null) {
            NavigationSchema.removeSchemaRebuildListener((Module)oldModel.getModule(), (Runnable)this.onSchemaChange);
        }
        if (model != null) {
            NavigationSchema.addSchemaRebuildListener((Disposable)this, (Module)model.getModule(), (Runnable)this.onSchemaChange);
        }
        super.setModel(model);
        NavUsageTracker.Companion.getInstance(model).createEvent(NavEditorEvent.NavEditorEventType.OPEN_FILE).withNavigationContents().log();
    }

    private void showFailToAddMessage(@NotNull CompletableFuture<?> result, final @NotNull NlModel model) {
        if (this.myEditorPanel != null) {
            ProjectSystemSyncManager.SyncResultListener syncFailedListener = new ProjectSystemSyncManager.SyncResultListener(){

                public void syncEnded(@NotNull ProjectSystemSyncManager.SyncResult result) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (NavDesignSurface.tryToCreateSchema(model.getFacet())) {
                            NavDesignSurface.this.myEditorPanel.initNeleModel();
                            ((MessageBusConnection)NavDesignSurface.this.myEditorPanel.getClientProperty(CONNECTION_CLIENT_PROPERTY_KEY)).disconnect();
                            NavDesignSurface.this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, null);
                        }
                    });
                }
            };
            MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
            this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, connection);
            connection.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)syncFailedListener);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.onFailedToAddDependency());
        result.completeExceptionally(new Exception(FAILED_DEPENDENCY));
    }

    private void onFailedToAddDependency() {
        Messages.showErrorDialog((Project)this.getProject(), (String)FAILED_DEPENDENCY, (String)FAILED_DEPENDENCY_TITLE);
        if (this.myEditorPanel != null) {
            this.myEditorPanel.getWorkBench().loadingStopped(FAILED_DEPENDENCY);
        }
    }

    private boolean requestAddDependency(@NotNull NlModel model) {
        Project project = model.getProject();
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem((Project)project);
        Optional<NavDesignSurfaceToken> maybeToken = NavDesignSurfaceToken.EP_NAME.getExtensionList().stream().filter(t -> t.isApplicable(projectSystem)).findFirst();
        if (maybeToken.isEmpty()) {
            return false;
        }
        NavDesignSurfaceToken token = maybeToken.get();
        return token.modifyProject(projectSystem, model);
    }

    @Override
    @NotNull
    public ZoomController getZoomController() {
        return this.myZoomController;
    }

    @NotNull
    public static List<GoogleMavenArtifactId> getDependencies(@NotNull Module module) {
        boolean isKotlin = AndroidStudioKotlinPluginUtils.hasKotlinFacet((Module)module);
        if (MigrateToAndroidxUtil.isAndroidx((Project)module.getProject())) {
            return isKotlin ? ANDROIDX_NAVIGATION_DEPENDENCIES_KTX : ANDROIDX_NAVIGATION_DEPENDENCIES;
        }
        return isKotlin ? NAVIGATION_DEPENDENCIES_KTX : NAVIGATION_DEPENDENCIES;
    }

    private static boolean tryToCreateSchema(@NotNull AndroidFacet facet) {
        Module module = facet.getModule();
        return (Boolean)DumbService.getInstance((Project)module.getProject()).runReadActionInSmartMode(() -> {
            try {
                NavigationSchema.createIfNecessary((Module)module);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        });
    }

    @Override
    public void activate() {
        super.activate();
        NlModel model = this.getModel();
        if (model != null) {
            Module module = model.getModule();
            try {
                NavigationSchema.createIfNecessary((Module)module);
            }
            catch (ClassNotFoundException e) {
                return;
            }
            NavigationSchema schema = NavigationSchema.get((Module)module);
            if (!schema.quickValidate()) {
                if (this.myEditorPanel == null) {
                    return;
                }
                this.myEditorPanel.getWorkBench().showLoading("Refreshing Navigators...");
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        schema.rebuildSchema().get();
                        ApplicationManager.getApplication().invokeLater(() -> this.myEditorPanel.getWorkBench().hideLoading());
                    }
                    catch (Exception e) {
                        ApplicationManager.getApplication().invokeLater(() -> this.myEditorPanel.getWorkBench().loadingStopped("Error refreshing Navigators"));
                    }
                });
            } else {
                schema.rebuildSchema();
            }
        }
    }

    @Override
    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        NlModel model = this.getModel();
        ImmutableList components = (ImmutableList)this.getSelectionModel().getSelection().stream().map(component -> new DnDTransferComponent(component.getTagName(), component.getTagDeprecated().getText(), 0, 0)).collect(ImmutableList.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(model != null ? model.getTreeWriter().getId() : 0L, (ImmutableList<DnDTransferComponent>)components));
    }

    @NotNull
    public NlComponent getCurrentNavigation() {
        if (!this.validateCurrentNavigation().booleanValue()) {
            this.refreshRoot();
        }
        return this.myCurrentNavigation;
    }

    private Boolean validateCurrentNavigation() {
        NlComponent current = this.myCurrentNavigation;
        NlModel surfaceModel = this.getModel();
        if (current == null || surfaceModel == null || current.getModel() != surfaceModel) {
            return false;
        }
        while (current.getParent() != null) {
            NlComponent parent = current.getParent();
            if (!parent.getChildren().contains(current)) {
                return false;
            }
            current = parent;
        }
        ImmutableList<NlComponent> components = surfaceModel.getTreeReader().getComponents();
        assert (components.size() == 1);
        return current == components.get(0);
    }

    public CompletableFuture<Void> setCurrentNavigation(@NotNull NlComponent currentNavigation) {
        this.myCurrentNavigation = currentNavigation;
        Object sceneManager = this.getSceneManager(this.getModel());
        if (sceneManager != null) {
            ((SceneManager)sceneManager).update();
            currentNavigation.getModel().notifyModified(ChangeType.UPDATE_HIERARCHY);
        }
        return ((SceneManager)sceneManager).requestLayoutAsync(false).whenCompleteAsync((result, ex) -> {
            this.myZoomController.zoomToFit();
            this.repaint();
        }, (Executor)EdtExecutorService.getInstance());
    }

    @Override
    @NotNull
    protected Dimension getScrollToVisibleOffset() {
        return new Dimension(0, 0);
    }

    @Override
    public boolean getShouldStoreScale() {
        return false;
    }

    private Dimension getSizeFromSceneView(SceneView view) {
        SceneComponent root = view.getScene().getRoot();
        if (root == null) {
            return new Dimension(0, 0);
        }
        Rectangle boundingBox = NavSceneManagerKt.getBoundingBox(root);
        return boundingBox.getSize();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void notifyComponentActivate(@NotNull NlComponent component) {
        VirtualFile virtualFile;
        PsiFile file2;
        PsiClass psiClass;
        String className;
        NavEditorEvent.NavEditorEventType metricsEventType;
        String id;
        if (this.myCurrentNavigation == component) {
            return;
        }
        if (NavComponentHelperKt.isNavigation(component)) {
            if (!NavComponentHelperKt.isInclude(component)) {
                this.setCurrentNavigation(component);
                NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(NavEditorEvent.NavEditorEventType.ACTIVATE_NESTED).log();
                return;
            }
            id = component.getAttribute("http://schemas.android.com/apk/res-auto", "graph");
            metricsEventType = NavEditorEvent.NavEditorEventType.ACTIVATE_INCLUDE;
            if (id == null) {
                return;
            }
        } else {
            id = component.getAttribute("http://schemas.android.com/tools", "layout");
            metricsEventType = NavEditorEvent.NavEditorEventType.ACTIVATE_LAYOUT;
        }
        if (id != null) {
            VirtualFile virtualFile2;
            File file3;
            String fileName;
            Configuration configuration = (Configuration)Iterables.getOnlyElement(this.getConfigurations(), null);
            ResourceItemResolver resolver = configuration != null ? configuration.getResourceItemResolver() : null;
            ResourceValue value = resolver != null ? resolver.findResValue(id, false) : null;
            String string = fileName = value != null ? value.getValue() : null;
            if (fileName != null && (file3 = new File(fileName)).exists() && (virtualFile2 = VfsUtil.findFileByIoFile((File)file3, (boolean)false)) != null) {
                FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile2, true);
                NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(metricsEventType).log();
                return;
            }
        }
        if ((className = component.getAttribute("http://schemas.android.com/apk/res/android", "name")) != null && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject()))) != null && (file2 = psiClass.getContainingFile()) != null && (virtualFile = file2.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile, true);
            NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(NavEditorEvent.NavEditorEventType.ACTIVATE_CLASS).log();
            return;
        }
    }

    @Override
    public void onZoomChange(@NotNull ZoomChange update) {
        NavSceneManager sceneManager;
        NlModel model;
        boolean shouldRecenter = update.getZoomType() == ZoomType.FIT || update.getZoomType() == ZoomType.ACTUAL;
        boolean scaled = update.getHasScaleChanged();
        if ((scaled || shouldRecenter) && (model = this.getModel()) != null && (sceneManager = (NavSceneManager)this.getSceneManager(model)) != null) {
            sceneManager.requestLayoutAsync(false);
            this.validateScrollArea();
        }
        Dimension size = this.getViewSize();
        Dimension visibleSize = this.getExtentSize();
        int scrollPositionX = (size.width - visibleSize.width) / 2;
        int scrollPositionY = (size.height - visibleSize.height) / 2;
        if (shouldRecenter && (scrollPositionX != 0 || scrollPositionY != 0)) {
            this.setScrollPosition(scrollPositionX, scrollPositionY);
        }
    }

    @Override
    public void scrollToCenter(List<? extends NlComponent> list) {
        Scene scene = this.getScene();
        SceneView view = this.getFocusedSceneView();
        if (list.isEmpty() || scene == null || view == null) {
            return;
        }
        Rectangle selectionBounds = NavSceneManagerKt.getBoundingBox(list.stream().map(nlComponent -> scene.getSceneComponent((NlComponent)nlComponent)).filter(sceneComponent -> sceneComponent != null).collect(Collectors.toList()));
        Dimension swingViewportSize = this.getExtentSize();
        int swingStartCenterXInViewport = Coordinates.getSwingX(view, (int)selectionBounds.getCenterX()) - this.getPannable().getScrollPosition().x;
        int swingStartCenterYInViewport = Coordinates.getSwingY(view, (int)selectionBounds.getCenterY()) - this.getPannable().getScrollPosition().y;
        Point start = new Point(swingStartCenterXInViewport, swingStartCenterYInViewport);
        Point end = new Point(swingViewportSize.width / 2, swingViewportSize.height / 2);
        LerpPoint lerpPoint = new LerpPoint(start, end, this.getScrollDurationMs());
        double fitSelectionScale = this.getZoomController().getFitScale();
        fitSelectionScale = Math.min(fitSelectionScale, 1.0);
        LerpDouble zoomLerp = new LerpDouble(view.getScale(), fitSelectionScale, this.getScrollDurationMs());
        if (this.getScheduleRef().get() != null) {
            this.getScheduleRef().get().cancel(false);
        }
        Runnable action2 = () -> UIUtil.invokeAndWaitIfNeeded(() -> {
            long time = System.currentTimeMillis();
            Point pointSwingValue = (Point)lerpPoint.getValue(time);
            int targetSwingX = Coordinates.getSwingX(view, (int)selectionBounds.getCenterX());
            int targetSwingY = Coordinates.getSwingY(view, (int)selectionBounds.getCenterY());
            this.setScrollPosition(targetSwingX - pointSwingValue.x, targetSwingY - pointSwingValue.y);
            this.getZoomController().setScale((Double)zoomLerp.getValue(time), targetSwingX, targetSwingY);
            if (lerpPoint.isComplete(time)) {
                this.getScheduleRef().get().cancel(false);
                this.getScheduleRef().set(null);
            }
        });
        this.getScheduleRef().set(AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(action2, 0L, 10L, TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    @NotNull
    AtomicReference<Future<?>> getScheduleRef() {
        return this.myScheduleRef;
    }

    int getScrollDurationMs() {
        return 300;
    }

    public void refreshRoot() {
        NlModel model = this.getModel();
        if (model == null) {
            return;
        }
        NlComponent match = (NlComponent)model.getTreeReader().getComponents().get(0);
        if (this.myCurrentNavigation != null) {
            boolean includingParent = false;
            TagSnapshot currentSnapshot = this.myCurrentNavigation.getSnapshot();
            NlComponent currentParent = this.myCurrentNavigation.getParent();
            for (NlComponent component : model.getTreeReader().flattenComponents()::iterator) {
                if (!NavComponentHelperKt.isNavigation(component)) continue;
                if (component == this.myCurrentNavigation) {
                    return;
                }
                TagSnapshot componentSnapshot = component.getSnapshot();
                if (currentSnapshot != null && currentSnapshot == componentSnapshot) {
                    match = component;
                    break;
                }
                if (includingParent || !Objects.equals(component.getId(), this.myCurrentNavigation.getId())) continue;
                match = component;
                NlComponent componentParent = component.getParent();
                if (componentParent == null != (currentParent == null) || componentParent != null && !Objects.equals(componentParent.getId(), currentParent.getId())) continue;
                includingParent = true;
            }
        }
        if (this.myCurrentNavigation != match) {
            this.myCurrentNavigation = match;
            this.getSelectionModel().setSelection((List<? extends NlComponent>)ImmutableList.of((Object)this.myCurrentNavigation));
        }
    }

    @Override
    @NotNull
    public List<NlComponent> getSelectableComponents() {
        NlComponent root = this.getCurrentNavigation();
        return root.flatten().filter(component -> component == root || NavComponentHelperKt.isDestination(component) && component.getParent() == root || NavComponentHelperKt.isAction(component) && (component.getParent() == root || component.getParent() != null && component.getParent().getParent() == root || NavComponentHelperKt.getActionType(component, root) == ActionType.EXIT_DESTINATION)).collect(Collectors.toList());
    }

    private void updateCurrentNavigation(@NotNull List<NlComponent> selection) {
        if (selection.isEmpty()) {
            return;
        }
        if (this.getSelectableComponents().stream().anyMatch(selection::contains)) {
            return;
        }
        NlComponent selected = selection.get(0);
        NlComponent next = selected.getParent();
        if (next == null) {
            next = selected;
        }
        while (next != null && !NavComponentHelperKt.isNavigation(next)) {
            next = next.getParent();
        }
        if (next != null) {
            this.setCurrentNavigation(next);
        }
    }
}

