/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.actions;

import com.android.tools.idea.editors.fast.FastPreviewManager;
import com.android.tools.idea.editors.fast.FastPreviewManagerKt;
import com.android.tools.idea.preview.PreviewBundle;
import com.android.tools.idea.preview.essentials.PreviewEssentialsModeManager;
import com.android.tools.idea.preview.fast.FastPreviewSurface;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorNotifications;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/preview/actions/ToggleFastPreviewAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "fastPreviewSurfaceProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/actionSystem/DataContext;", "Lcom/android/tools/idea/preview/fast/FastPreviewSurface;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.preview-designer"})
public final class ToggleFastPreviewAction
extends AnAction {
    @NotNull
    private final Function1<DataContext, FastPreviewSurface> fastPreviewSurfaceProvider;

    public ToggleFastPreviewAction(@NotNull Function1<? super DataContext, ? extends FastPreviewSurface> fastPreviewSurfaceProvider) {
        Intrinsics.checkNotNullParameter(fastPreviewSurfaceProvider, (String)"fastPreviewSurfaceProvider");
        super(null, null, null);
        this.fastPreviewSurfaceProvider = fastPreviewSurfaceProvider;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean newState;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        FastPreviewManager fastPreviewManager = FastPreviewManagerKt.getFastPreviewManager((Project)project2);
        boolean bl = newState = !fastPreviewManager.isEnabled();
        if (newState) {
            fastPreviewManager.enable();
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            FastPreviewSurface fastPreviewSurface = (FastPreviewSurface)this.fastPreviewSurfaceProvider.invoke((Object)dataContext);
            if (fastPreviewSurface != null) {
                fastPreviewSurface.requestFastPreviewRefreshAsync();
            }
        } else {
            fastPreviewManager.disable();
        }
        EditorNotifications.getInstance((Project)project2).updateAllNotifications();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Project project = e.getProject();
        if (project == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        if (PreviewEssentialsModeManager.INSTANCE.isEssentialsModeEnabled()) {
            presentation2.setDescription(PreviewBundle.INSTANCE.message("action.preview.fast.refresh.disabled.in.essentials.mode.description", new Object[0]));
            presentation2.setEnabled(false);
        } else {
            presentation2.setDescription(PreviewBundle.INSTANCE.message("action.preview.fast.refresh.toggle.description", new Object[0]));
            presentation2.setEnabled(true);
        }
        presentation2.setText(FastPreviewManagerKt.getFastPreviewManager((Project)project).isEnabled() ? PreviewBundle.INSTANCE.message("action.preview.fast.refresh.disable.title", new Object[0]) : PreviewBundle.INSTANCE.message("action.preview.fast.refresh.enable.title", new Object[0]));
    }
}

