/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import android.view.View;
import android.view.ViewGroup;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ScrollViewScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.common.CommonDragHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollViewHandler
extends ViewGroupHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"scrollbarStyle", (Object)"style", (Object)"fillViewport", (Object)"clipToPadding");
    }

    @Override
    public void onChildInserted(@NotNull NlComponent parent, @NotNull NlComponent child, @NotNull InsertType insertType) {
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", "match_parent");
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", "wrap_content");
    }

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent node, @NotNull InsertType insertType) {
        if (insertType == InsertType.CREATE) {
            NlWriteCommandActionUtil.run(node, "Create Scroll View", () -> {
                NlComponent linear = NlComponentHelperKt.createChild(node, "android.widget.LinearLayout", null, InsertType.PROGRAMMATIC);
                if (linear != null) {
                    linear.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "vertical");
                }
            });
        }
        return true;
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        return new CommonDragHandler(editor, (ViewGroupHandler)this, layout, (List<? extends NlComponent>)components, type);
    }

    @Nullable
    public static ScrollHandler createScrollHandler(@NotNull ViewGroup viewGroup, NlComponent component) {
        int maxScrollableHeight = ScrollViewScrollHandler.getMaxScrollable(viewGroup, View::getHeight, View::getMeasuredHeight);
        if (maxScrollableHeight > 0) {
            return ScrollViewScrollHandler.createHandler(viewGroup, component, maxScrollableHeight, 10, ScrollViewScrollHandler.Orientation.VERTICAL);
        }
        return null;
    }

    @Override
    @Nullable
    public ScrollHandler createScrollHandler(@NotNull ViewEditor editor, @NotNull NlComponent component) {
        ViewGroup viewGroup = ScrollViewHandler.getViewGroupFromComponent(component);
        if (viewGroup == null) {
            return null;
        }
        return ScrollViewHandler.createScrollHandler(viewGroup, component);
    }

    @Nullable
    static ViewGroup getViewGroupFromComponent(@NotNull NlComponent component) {
        Object viewObject;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        Object object = viewObject = viewInfo != null ? viewInfo.getViewObject() : null;
        if (viewObject instanceof ViewGroup) {
            return (ViewGroup)viewObject;
        }
        return null;
    }

    @Override
    public boolean acceptsChild(@NotNull NlComponent layout, @NotNull NlComponent newChild) {
        return layout.getChildCount() == 0;
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions2) {
    }
}

