/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.ComponentAssistantViewAction;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.assistant.ComponentAssistantFactory;
import com.android.tools.idea.uibuilder.handlers.actions.PickTextAppearanceViewAction;
import com.android.tools.idea.uibuilder.handlers.assistant.TextViewAssistant;
import com.android.xml.XmlBuilder;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextViewHandler
extends ViewHandler {
    private static final Set<String> HAVE_REDUCED_SCALE_IN_PREVIEW = ImmutableSet.of((Object)"AutoCompleteTextView", (Object)"EditText", (Object)"MultiAutoCompleteTextView");
    private static final Set<String> TEXT_DEFAULT_VALUES = ImmutableSet.of((Object)"Hello World!", (Object)"TextView", (Object)"@string/hello_first_fragment", (Object)"@string/hello_blank_fragment", (Object)"@string/hello_world");

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        String text = component.getAttribute("http://schemas.android.com/apk/res/android", "text");
        if (!StringUtil.isEmpty((String)text)) {
            return String.format("\"%1$s\"", text);
        }
        return super.getTitleAttributes(component);
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        return new XmlBuilder().startTag(tagName).androidAttribute("text", tagName).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").endTag(tagName).toString();
    }

    @Override
    public double getPreviewScale(@NotNull String tagName) {
        if (HAVE_REDUCED_SCALE_IN_PREVIEW.contains(tagName)) {
            return 0.8;
        }
        return super.getPreviewScale(tagName);
    }

    @Override
    @NotNull
    public String getPreferredProperty() {
        return "text";
    }

    @Nullable
    private static ComponentAssistantFactory getComponentAssistant(@NotNull NlComponent component) {
        boolean shouldDisplay;
        String toolsText = component.getAttribute("http://schemas.android.com/tools", "text");
        String text = component.getAttribute("http://schemas.android.com/apk/res/android", "text");
        boolean bl = shouldDisplay = Strings.nullToEmpty((String)toolsText).startsWith("@tools:sample/") || Strings.isNullOrEmpty((String)toolsText) && (Strings.isNullOrEmpty((String)text) || TEXT_DEFAULT_VALUES.contains(text));
        if (!shouldDisplay) {
            return null;
        }
        return TextViewAssistant::createComponent;
    }

    @Override
    public boolean addPopupMenuActions(@NotNull SceneComponent component, @NotNull List<ViewAction> actions2) {
        boolean cacheable = super.addPopupMenuActions(component, actions2);
        actions2.add(new ComponentAssistantViewAction((Function1<? super NlComponent, ? extends ComponentAssistantFactory>)((Function1)TextViewHandler::getComponentAssistant)));
        return cacheable;
    }

    @Override
    public List<ViewAction> getPropertyActions(@NotNull List<NlComponent> components) {
        return ImmutableList.of((Object)new PickTextAppearanceViewAction("http://schemas.android.com/apk/res/android", "textAppearance"));
    }
}

